/*
 * get.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait get operation
 * for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

long int
rlog_get
(
    handle_t *&h,
    ios_$put_get_opts_t &options,
    void *buffer, 
    long int &buffer_length,
    status_$t *status
)
{
    long int amount = buffer_length;
    long int start;

    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( h->pfgs->stream_pointer < h->rlog->bof )
    {
        h->pfgs->stream_pointer = h->rlog->bof;
    }

    if( h->rlog->eof < h->pfgs->stream_pointer )
    {
        status->all = ios_$end_of_file;
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        pfm_$enable();
        return 0;
    }

    if( h->rlog->eof - h->pfgs->stream_pointer < amount )
    {
        amount = h->rlog->eof - h->pfgs->stream_pointer;
    }

    if( !amount )
    {
        status->all = ios_$end_of_file;
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        pfm_$enable();
        return amount;
    }

    start = h->pfgs->stream_pointer % h->rlog->length;

    if( start + amount > h->rlog->length )
    {
        /*
         * Two parts
         */
        long int first = h->rlog->length - start;
        long int second = amount - first;

        (void)memcpy(
                        (char *)buffer, 
                        &h->data[ start ],
                        first
                    );

        (void)memcpy(
                        &((char *)buffer)[ first ],
                        h->data,
                        second
                    );
    }
    else
    {
        /*
         * One part
         */
        (void)memcpy(
                        (char *)buffer,
                        &h->data[ start ],
                        amount
                    );
    }

    if( ! (options & ios_$preview_opt) )
    {
        h->pfgs->stream_pointer += amount;
    }

    status->all = status_$ok;
    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return amount;
}
