/*
 * get_ec.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait get_ec
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_get_ec
(
    handle_t *&h,
    ios_$ec_key_t &stream_key,
    ec2_$ptr_t *eventcount_pointer,
    status_$t *status
)
{
    switch( stream_key )
    {
        case ios_$get_ec_key:
            *eventcount_pointer = (ec2_$ptr_t) ec2_$always_ready_ec;
            status->all = status_$ok;
            break;
        case ios_$put_ec_key:
            *eventcount_pointer = &h->pfgs->sfcb->put;
            status->all = status_$ok;
            break;
        default:
            status->all = ios_$illegal_operation;
            break;
    }

    return;
}

