/*
 * import.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait import
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_import
(
    void *mgr_data,
    handle_t **ph,
    status_$t *status
)
{
    handle_t *h;

    pfm_$inhibit();

    h = *ph = rws_$alloc_heap_pool(rws_$stream_tm_pool, sizeof(handle_t));

    if( !(int)h )
    {
        status->all = ios_$insuff_memory;
        pfm_$enable();
        return;
    }

    *h = *(handle_t *)mgr_data;

    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    /*
     * Map the object
     */
    {
        ms_$acc_mode_t access_mode;
        unsigned long int length_mapped = 0;

        if( h->write )
        {
            access_mode = ms_$wr;
        }
        else if( h->read_intend_write )
        {
            access_mode = ms_$riw;
        }
        else
        {
            access_mode = ms_$r;
        }
    
        h->rlog = ms_$mapl_stream(
                                    h->pfgs->sfcb->header.xoid, 
                                    0, 
                                    sizeof(rlog_t),
                                    ms_$cowriters,
                                    access_mode,
                                    true,
                                    &length_mapped,
                                    status
                                );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);

            if( ! -- h->pfgs->users )
            {
                rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            }

            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        h->data = ms_$addmap(
                                h->rlog,
                                sizeof(rlog_t),
                                h->rlog->length,
                                &length_mapped,
                                status
                            );

        if( status->all != status_$ok )
        {
            status_$t spare;
            ms_$unmap(h->rlog, sizeof(rlog_t), &spare);
            sfcb_$free(h->pfgs->sfcb, &spare);

            if( ! -- h->pfgs->users )
            {
                rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            }

            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

    }

    status->all = status_$ok;
    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
