/*
 * initialize.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO_OC trait initialize
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_initialize
(
    xoid_$t &xoid,
    xoid_$t &copy_xoid,
    ios_$open_options_t &open_options,
    handle_t **ph,
    status_$t *status
)
{
    handle_t *h;

    pfm_$inhibit();

    h = *ph = rws_$alloc_heap_pool(rws_$stream_tm_pool, sizeof(handle_t));

    if( !(int)h )
    {
        status->all = ios_$insuff_memory;
        pfm_$enable();
        return;
    }

    h->pfgs = rws_$alloc_heap_pool(rws_$global_pool, sizeof(pfgs_t));

    if( !(int)h->pfgs )
    {
        status_$t spare;
        status->all = ios_$insuff_memory;
        rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
        pfm_$enable();
        return;
    }

    h->append_mode = false;
    h->inq_only = open_options & ios_$inquire_only_opt ? true : false;
    h->write = open_options & ios_$write_opt ? true : false;
    h->read_intend_write = open_options & ios_$read_intend_write_opt ? true : false;
    h->read_only = h->write || h->read_intend_write ? false : true;
    h->regulated = open_options & ios_$unregulated_opt ? false : true;

    sfcb_$get(rlog_$uid, xoid, sizeof(sfcb_t), &h->pfgs->sfcb, status);

    if( status->all != status_$ok )
    {
        status_$t spare;
        rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
        rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
        pfm_$enable();
        return;
    }

    h->pfgs->sfcb->regulated_readers = 0;
    h->pfgs->sfcb->regulated_riw_ers = 0;
    h->pfgs->sfcb->regulated_writers = 0;
    h->pfgs->sfcb->unregulated_readers = 0;
    h->pfgs->sfcb->unregulated_riw_ers = 0;
    h->pfgs->sfcb->unregulated_writers = 0;
    h->pfgs->sfcb->delete_on_close = false;
    h->pfgs->sfcb->ascii = true;
    ec2_$init(&h->pfgs->sfcb->put);

    if( copy_xoid != xoid_$nil )
    {
        ms_$acc_mode_t access_mode;
        unsigned long int length_mapped = 0;
        rlog_t *bak_header;
        char *bak;

        if( open_options & ios_$write_opt )
        {
            access_mode = ms_$wr;
        }
        else if( open_options & ios_$read_intend_write_opt )
        {
            access_mode = ms_$riw;
        }
        else
        {
            access_mode = ms_$r;
        }

        bak_header = ms_$mapl_stream(
                                        copy_xoid,
                                        0,
                                        sizeof(rlog_t),
                                        ms_$cowriters,
                                        ms_$r,
                                        true,
                                        &length_mapped,
                                        status
                                    );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        bak = ms_$addmap(
                            bak_header,
                            sizeof(rlog_t),
                            bak_header->length,
                            &length_mapped,
                            status
                        );

        if( status->all != status_$ok )
        {
            status_$t spare;
            ms_$unmap(bak_header, length_mapped, &spare);
            sfcb_$free(h->pfgs->sfcb, &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        h->rlog = ms_$mapl_stream(
                                    xoid,
                                    0,
                                    sizeof(rlog_t),
                                    ms_$cowriters,
                                    access_mode,
                                    true,
                                    &length_mapped,
                                    status
                                 );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);
            ms_$unmap(bak, length_mapped, &spare);
            ms_$unmap(bak_header, sizeof(rlog_t), &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        h->data = ms_$addmap(
                                h->rlog,
                                sizeof(rlog_t),
                                bak_header->length,
                                &length_mapped,
                                status
                            );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);
            ms_$unmap(h->rlog, sizeof(rlog_t), &spare);
            ms_$unmap(bak, length_mapped, &spare);
            ms_$unmap(bak_header, sizeof(rlog_t), &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        * h->rlog = * bak_header;

        if( h->rlog->eof < h->rlog->length )
        {
            (void)memcpy(h->data, bak, h->rlog->eof);
        }
        else
        {
            (void)memcpy(h->data, bak, h->rlog->length);
        }

        ms_$unmap(bak, bak_header->length, status);
        ms_$unmap(bak_header, sizeof(rlog_t), status);
    }
    else
    {
        ms_$acc_mode_t access_mode;
        unsigned long int length_mapped = 0;

        if( open_options & ios_$write_opt )
        {
            access_mode = ms_$wr;
        }
        else if( open_options & ios_$read_intend_write_opt )
        {
            access_mode = ms_$riw;
        }
        else
        {
            access_mode = ms_$r;
        }

        h->rlog = ms_$mapl_stream(
                                    xoid,
                                    0,
                                    sizeof(rlog_t),
                                    ms_$cowriters,
                                    access_mode,
                                    true,
                                    &length_mapped,
                                    status
                                 );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

        h->rlog->length = DEFAULT_LENGTH;
        h->rlog->bof = h->rlog->eof = 0;

        h->data = ms_$addmap(
                                h->rlog,
                                sizeof(rlog_t),
                                h->rlog->length,
                                &length_mapped,
                                status
                            );

        if( status->all != status_$ok )
        {
            status_$t spare;

            switch( status->all )
            {
                case ms_$no_rights:
                    status->all = ios_$no_rights;
                    break;
                case ms_$insufficient_rights:
                    status->all = ios_$insufficient_rights;
                    break;
                case ms_$object_not_found:
                    status->all = ios_$object_not_found;
                    break;
                case ms_$in_use:
                    status->all = ios_$concurrency_violation;
                    break;
                default:
                    break;
            }

            sfcb_$free(h->pfgs->sfcb, &spare);
            ms_$unmap(h->rlog, sizeof(rlog_t), &spare);
            rws_$release_heap_pool(h->pfgs, rws_$global_pool, &spare);
            rws_$release_heap_pool(h, rws_$stream_tm_pool, &spare);
            pfm_$enable();
            return;
        }

    }

    if( h->regulated )
    {
        if( h->write )
        {
            h->pfgs->sfcb->regulated_writers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->regulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->regulated_readers++;
        }
    }
    else
    {
        if( h->write )
        {
            h->pfgs->sfcb->unregulated_writers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->unregulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->unregulated_readers++;
        }
    }

    h->pfgs->users = 1;

    if( open_options & ios_$position_to_eof_opt )
    {
        h->pfgs->stream_pointer = h->rlog->eof;
    }
    else
    {
        h->pfgs->stream_pointer = h->rlog->bof;
    }

    status->all = status_$ok;
    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
