/*
 * inq_byte_pos.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait inq_byte_pos
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

long int
rlog_inq_byte_pos
(
    handle_t *&h,
    ios_$pos_opt_t &pos_opt,
    status_$t *status
)
{
    long int position;

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    switch( pos_opt )
    {
        case ios_$bof:
            position = h->rlog->bof - h->rlog->bof;
            status->all = status_$ok;
            break;
        case ios_$current:
            position = h->pfgs->stream_pointer - h->rlog->bof;
            status->all = status_$ok;
            break;
        case ios_$eof:
            position = h->rlog->eof - h->rlog->bof;
            status->all = status_$ok;
            break;
        default:
            position = 0;
            status->all = ios_$illegal_operation;
            break;
    }

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return position;
}
