/*
 * inq_conn_flags.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait inq_conn_flags
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

ios_$conn_flag_set
rlog_inq_conn_flags
(
    handle_t *&h,
    status_$t *status
)
{
    ios_$conn_flag_set flags = 0;

    if( h->append_mode )
    {
        flags |= ios_$cf_append_mask;
    }

    if( h->read_intend_write )
    {
        flags |= ios_$cf_read_intend_write_mask;
    }
    else if( h->write )
    {
        flags |= ios_$cf_write_mask;
    }

    if( ! h->regulated )
    {
        flags |= ios_$cf_unregulated_mask;
    }

    status->all = status_$ok;

    return flags;
}
