/*
 * inq_short_key.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait inq_short_key
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

long int
rlog_inq_short_key
(
    handle_t *&h,
    ios_$pos_opt_t &position_option,
    status_$t *status
)
{   
    long int result;

    switch( position_option )
    {
        case ios_$bof:
            result = h->rlog->bof;
            break;
        case ios_$current:
            result = h->pfgs->stream_pointer;
            break;
        case ios_$eof:
            result = h->rlog->eof;
            break;
        default:
            status->all = ios_$illegal_operation;
            return 0;
    }

    if( result < h->rlog->bof )
    {
        result = h->rlog->bof;
    }

    status->all = status_$ok;

    return result;
}
