/*
 * mkrlog.c
 *
 * Version 2.0 : Frederick Roeber : 4 June 1992
 *
 * This file contains the routine which makes a rolling log.
 *
 */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "rlog.h"
#include "mkrlog.h"

/*
 * _mkrlog_status
 *
 * For users who are interested in the apollo error value, it is stored in
 * this external variable.
 */

status_$t _mkrlog_status;

/*
 * mkrlog
 *
 * This routine is based on mkfifo(2) and mknod(2).  It takes a path, a unix
 * filemode, and a size.  If the size is zero, the default value defined in
 * the type manager is used.  The filemode is modified by the umask(2) value.
 * It returns a zero for success, or -1 on error.
 */

int
mkrlog
(
    char *path,
    int mode,
    long int size
)
{
    ios_$id_t stream_id;
    handle_t *h;
    mode_t cmask;

    ios_$create(
                path, 
                strlen(path), 
                rlog_$uid, 
                ios_$make_backup_mode, 
                ios_$write_opt,
                &stream_id,
                &_mkrlog_status
               );

    if( _mkrlog_status.all != status_$ok )
    {
        return -1;
    }

    if( size )
    {
        h = ios_$get_handle(stream_id, rlog_$uid, &_mkrlog_status);
    
        if( _mkrlog_status.all != status_$ok )
        {
            return -1;
        }
    
        h->rlog->length = size;
        h->data[size - 1] = '\0';
    
        ios_$truncate(stream_id, &_mkrlog_status);
    
        if( _mkrlog_status.all != status_$ok )
        {
            return -1;
        }
    }

    ios_$close(stream_id, &_mkrlog_status);

    if( _mkrlog_status.all != status_$ok )
    {
        return -1;
    }

    cmask = umask(0);
    (void)umask(cmask);

    return chmod(path, mode & ~cmask);
}
