/*
 * prototypes.h
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the prototypes of the rlog type manager routines.
 *
 */

/*
 * open.c
 */

void
rlog_open
(
    xoid_$t &xoid,
    ios_$open_options_t &open_options,
    handle_t **ph,
    status_$t *status
);

/*
 * initialize.c
 */

void
rlog_initialize
(
    xoid_$t &xoid,
    xoid_$t &copy_xoid,
    ios_$open_options_t &open_options,
    handle_t **ph,
    status_$t *status
);

/*
 * close.c
 */

boolean
rlog_close
(
    handle_t *&h,
    status_$t *status
);

/*
 * equal.c
 */

boolean
rlog_equal
(
    handle_t *&h1,
    handle_t *&h2
);

/*
 * export.c
 */

void
rlog_export
(
    handle_t *&h,
    void *mgr_data,
    short int &buf_size,
    short int *mgr_buf_size,
    status_$t *status
);

/*
 * force_write_file.c
 */

void
rlog_force_write_file
(
    handle_t *&h,
    status_$t *status
);

/*
 * get.c
 */

long int
rlog_get
(
    handle_t *&h,
    ios_$put_get_opts_t &options,
    void *buffer, 
    long int &buffer_length,
    status_$t *status
);

/*
 * get_ec.c
 */

void
rlog_get_ec
(
    handle_t *&h,
    ios_$ec_key_t &stream_key,
    ec2_$ptr_t *eventcount_pointer,
    status_$t *status
);

/*
 * import.c
 */

void
rlog_import
(
    void *mgr_data,
    handle_t **ph,
    status_$t *status
);

/*
 * inq_byte_pos.c
 */

long int
rlog_inq_byte_pos
(
    handle_t *&h,
    ios_$pos_opt_t &pos_opt,
    status_$t *status
);

/*
 * inq_conn_flags.c
 */

ios_$conn_flag_set
rlog_inq_conn_flags
(
    handle_t *&h,
    status_$t *status
);

/*
 * inq_file_attr.c
 */

void
rlog_inq_file_attr
(
    handle_t *&h,
    time_$clockh_t *dt_created,
    time_$clockh_t *dt_modified,
    time_$clockh_t *dt_used,
    long int *blocks,
    status_$t *status
);

/*
 * inq_full_key.c
 */

void
rlog_inq_full_key
(
    handle_t *&h,
    ios_$pos_opt_t &position_option,
    ios_$seek_key_t *full_key,
    status_$t *status
);

/*
 * inq_mgr_flags.c
 */

ios_$mgr_flag_set
rlog_inq_mgr_flags
(
    handle_t *&h,
    status_$t *status
);

/*
 * inq_obj_flags.c
 */

ios_$obj_flag_set
rlog_inq_obj_flags
(
    handle_t *&h,
    status_$t *status
);

/*
 * inq_rec_type.c
 */

ios_$rtype_t
rlog_inq_rec_type
(
    handle_t *&h,
    status_$t *status
);

/*
 * inq_short_key.c
 */

long int
rlog_inq_short_key
(
    handle_t *&h,
    ios_$pos_opt_t &position_option,
    status_$t *status
);

/*
 * post_fork.c
 */

void
rlog_post_fork
(
    handle_t *&h,
    status_$t *status
);

/*
 * pre_fork.c
 */

void
rlog_pre_fork
(
    handle_t *&h,
    status_$t *status
);

/*
 * put.c
 */

void
rlog_put
(
    handle_t *&h,
    ios_$put_get_opts_t &options,
    void *buffer,
    long int &buffer_length,
    status_$t *status
);

/*
 * putp.c
 */

long int
rlog_putp
(
    handle_t *&h,
    ios_$put_get_opts_t &options,
    void *buffer,
    long int &buffer_length,
    status_$t *status
);

/*
 * seek.c
 */

void
rlog_seek
(
    handle_t *&h,
    ios_$abs_rel_t &abs_rel,
    ios_$seek_type_t &seek_type,
    long int &offset_value,
    status_$t *status
);

/*
 * seek_full_key.c
 */

void
rlog_seek_full_key
(
    handle_t *&h,
    ios_$seek_key_t &full_key,
    status_$t *status
);

/*
 * seek_short_key.c
 */

void
rlog_seek_short_key
(
    handle_t *&h,
    long int &short_key,
    status_$t *status
);

/*
 * seek_to_bof.c
 */

void
rlog_seek_to_bof
(
    handle_t *&h,
    status_$t *status
);

/*
 * seek_to_eof.c
 */

void
rlog_seek_to_eof
(
    handle_t *&h,
    status_$t *status
);

/*
 * set_conn_flag.c
 */

void
rlog_set_conn_flag
(
    handle_t *&h,
    ios_$conn_flag_t &conn_flag,
    boolean &on_off,
    status_$t *status
);

/*
 * set_obj_flag.c
 */

void
rlog_set_obj_flag
(
    handle_t *&h,
    ios_$obj_flag_t &obj_flag,
    boolean &on_off,
    status_$t *status
);

/*
 * set_rec_type.c
 */

void
rlog_set_rec_type
(
    handle_t *&h,
    ios_$rtype_t &record_type,
    long int &record_length,
    status_$t *status
);

/*
 * truncate.c
 */

void
rlog_truncate
(
    handle_t *&h,
    status_$t *status
);

