/*
 * rlog.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the entry-point vectors for the IO and IO_OC traits and
 * the initialization routine for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"


/*
 * rlog_io_epv
 *
 * This is the normal I/O trait entry-point vector.
 */

io_$epv
rlog_io_epv =
{
    rlog_export,
    rlog_import,
    rlog_pre_fork,
    rlog_post_fork,
    rlog_close,
    rlog_get_ec,
    rlog_inq_mgr_flags,
    rlog_inq_obj_flags,
    rlog_set_obj_flag,
    rlog_inq_conn_flags,
    rlog_set_conn_flag,
    rlog_get,
    0, /* locate */
    rlog_put,
    0, /* inq_rec_remainder */
    rlog_seek,
    rlog_seek_full_key,
    rlog_seek_short_key,
    rlog_seek_to_bof,
    rlog_seek_to_eof,
    rlog_inq_short_key,
    rlog_inq_full_key,
    0, /* inq_rec_pos */
    rlog_inq_byte_pos,
    rlog_truncate,
    0, /* inq_cur_rec_len */
    rlog_inq_rec_type,
    rlog_set_rec_type,
    rlog_force_write_file,
    rlog_inq_file_attr,
    rlog_equal,
    0, /* export_to */
    rlog_putp
};

/*
 * rlog_io_oc_epv
 *
 * This is the "ordinary object" open trait entry-point vector.
 */

io_oc_$epv
rlog_io_oc_epv =
{
    rlog_open,
    rlog_initialize
};

/*
 * ios_$initialize
 *
 * This is the type manager initialization routine.  It just declares the epvs.
 */

void
ios_$initialize
(
    void
)
{
    trait_$kind_t k = (trait_$kind_t)( 1 << (int)trait_$kind_local ) |
                      (trait_$kind_t)( 1 << (int)trait_$kind_near_remote );

    status_$t status;

    trait_$mgr_dcl(rlog_$uid, (void *)&io_$trait, k, &rlog_io_epv, &status);

    if( status.all != status_$ok )
    {
        pfm_$error_trap(status);
    }

    trait_$mgr_dcl(rlog_$uid, (void *)&io_oc_$trait, k, &rlog_io_oc_epv, &status);

    if( status.all != status_$ok )
    {
        pfm_$error_trap(status);
    }

    return;
}
