/*
 * rlog.h
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This is the main header file for the rlog type manager.  It includes all of
 * the needed apollo header files, and defines the basic data structures.
 *
 */

#include <apollo/base.h>
#include <apollo/mutex.h>
#include <apollo/sfcb.h>
#include <apollo/ios.h>
#include <apollo/pfm.h>
#include <apollo/rws.h>
#include <apollo/ms.h>
#include <apollo/ec2.h>
#include <apollo/trait.h>
#include <apollo/io_traits.h>

/*
 * rlog_t
 *
 * This is the structure of the file header.  It contains the values of the 
 * maximum length and the stream indices for the beginning and end of the file.
 */

typedef
struct rlog_struct
{
    unsigned long int length;
    unsigned long int bof;
    unsigned long int eof;
}
rlog_t;

/*
 * sfcb_t
 *
 * This is the rlog type manager's definition of the shared file control block.
 * It contains the system-defined header, a put eventcount, and the 
 * numbers of regluated, read-intend-write, and write-enabled users.
 */

typedef
struct sfcb_struct
{
    sfcb_$header_t header;
    ec2_$eventcount_t put;
    unsigned int regulated_readers;
    unsigned int regulated_riw_ers;
    unsigned int regulated_writers;
    unsigned int unregulated_readers;
    unsigned int unregulated_riw_ers;
    unsigned int unregulated_writers;
    boolean delete_on_close;
    boolean ascii;
}
sfcb_t;

/*
 * pfgs_t
 *
 * This is the per-family global storage area datatype.  It contains a pointer
 * to the sfcb, the per-family stream pointer, the number of family users.
 */

typedef
struct pfgs_struct
{
    sfcb_t *sfcb;
    unsigned long int stream_pointer;
    unsigned int users;
}
pfgs_t;

/*
 * handle_t
 *
 * This is the type manager's handle for the object.  It contains a pointer
 * to the pfgs, a pointer to the object, and the access mode flags.
 */

typedef
struct handle_struct
{
    pfgs_t *pfgs;
    rlog_t *rlog;
    char *data;
    boolean append_mode;
    boolean inq_only;
    boolean read_only;
    boolean read_intend_write;
    boolean write;
    boolean regulated;
}
handle_t;

/*
 * DEFAULT_LENGTH
 *
 * This is the default length for a new log object.
 */

#define DEFAULT_LENGTH 16384

/*
 * rlog_$uid
 *
 * This external is the unique identifier for the rlog type.
 */

extern uid_$t rlog_$uid;
