/*
 * rlog_size.c
 *
 * Version 1.0 : Frederick Roeber : 15 June 1992
 *
 * This program determines the full size of an rlog file.
 *
 */

#include <stdio.h>
#include <string.h>

#include "rlog.h"

#include <apollo/error.h>

extern uid_$t rlog_$uid;

int
main
(
    int argc,
    char *argv[]
)
{
    status_$t status;

    while( argv++, --argc )
    {
        uid_$t type_uid;
        handle_t *h;

        ios_$id_t fd = ios_$open(
                                    *argv, 
                                    strlen(*argv), 
                                    ios_$inquire_only_opt,
                                    &status
                                );

        if( status.all != status_$ok )
        {
            fprintf(stderr, "Cannot open %s:", *argv);
            error_$print(status);
            continue;
        }

        ios_$inq_type_uid(fd, &type_uid, &status);

        if( status.all != status_$ok )
        {
            fprintf(stderr, "Cannot get type of %s:", *argv);
            error_$print(status);
            continue;
        }

        if( type_uid != rlog_$uid )
        {
            fprintf(stderr, "%s is not a rolling log.\n", *argv);
            continue;
        }

        h = ios_$get_handle(fd, rlog_$uid, &status);

        if( status.all != status_$ok )
        {
            fprintf(stderr, "Cannot get handle of %s:", *argv);
            error_$print(status);
            continue;
        }

        printf("%s: %d\n", *argv, h->rlog->length);

        ios_$close(fd, &status);

        if( status.all != status_$ok )
        {
            fprintf(stderr, "Cannot close %s:", *argv);
            error_$print(status);
            continue;
        }
    }

    return 0;
}
