/*
 * seek_to_bof.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait seek_to_bof
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_seek_to_bof
(
    handle_t *&h,
    status_$t *status
)
{
    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
        return;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    h->pfgs->stream_pointer = h->rlog->bof;
    status->all = status_$ok;

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
