/*
 * close.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait close operation
 * for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

boolean
rlog_close
(
    handle_t *&h,
    status_$t *status
)
{
    boolean delete_on_close;
    status_$t my_status;

    status->all = status_$ok;

    rlog_force_write_file(h, &my_status);

    if( my_status.all != status_$ok )
    {
        *status = my_status;
    }

    pfm_$inhibit();

    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( h->regulated )
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->regulated_readers--;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->regulated_riw_ers--;
        }
        else
        {
            h->pfgs->sfcb->regulated_writers--;
        }
    }
    else
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->unregulated_readers--;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->unregulated_riw_ers--;
        }
        else
        {
            h->pfgs->sfcb->unregulated_writers--;
        }
    }

    if( h->pfgs->sfcb->header.use_count == 1 )
    {
        delete_on_close = h->pfgs->sfcb->delete_on_close;
    }
    else
    {
        delete_on_close = false;
    }

    ms_$unmap(h->data, h->rlog->length, &my_status);

    if( my_status.all != status_$ok )
    {
        *status = my_status;
    }

    ms_$unmap(h->rlog, sizeof(rlog_t), &my_status);

    if( my_status.all != status_$ok )
    {
        *status = my_status;
    }

    sfcb_$free(h->pfgs->sfcb, &my_status);

    if( my_status.all != status_$ok )
    {
        *status = my_status;
    }

    if( ! -- h->pfgs->users )
    {
        rws_$release_heap_pool(h->pfgs, rws_$global_pool, &my_status);

        if( my_status.all != status_$ok )
        {
            *status = my_status;
        }
    }

    rws_$release_heap_pool(h, rws_$stream_tm_pool, &my_status);

    if( my_status.all != status_$ok )
    {
        *status = my_status;
    }

    pfm_$enable();
    return delete_on_close;
}
