/*
 * inq_file_attr.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait inq_file_attr
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_inq_file_attr
(
    handle_t *&h,
    time_$clockh_t *dt_created,
    time_$clockh_t *dt_modified,
    time_$clockh_t *dt_used,
    long int *blocks,
    status_$t *status
)
{
    short int attrib_len = 0;
    ms_$attrib_t attrib_buffer;

    ms_$attributes(
                    h->rlog, 
                    &attrib_buffer, 
                    &attrib_len, 
                    sizeof(ms_$attrib_t),
                    status
                  );

    if( status->all != status_$ok )
    {
        return;
    }

    *dt_created = attrib_buffer.dtcr;
    *dt_modified = attrib_buffer.dtm;
    *dt_used = attrib_buffer.dtu;
    *blocks = attrib_buffer.blocks_used;

    return;
}
