/*
 * make_rlog.c
 *
 * Version 2.0 : Frederick Roeber : 4 June 1992
 *
 * This file contains the program which creates a new rolling log.
 *
 */

#include <stdio.h>

#include <apollo/base.h>
#include <apollo/error.h>

#include "mkrlog.h"

/*
 * main
 *
 * The main routine.  Usage: make_rlog <pathname> [size]
 */

int
main
(
    int argc,
    char *argv[]
)
{
    if( argc < 2 )
    {
        puts("Usage: make_rlog <pathname> [size]");
        puts("\tThe pathname is required, the size (in bytes) is optional.");
        return 1;
    }

    if( mkrlog(argv[1], 0666, argc > 2 ? atoi(argv[2]) : 0) )
    {
        extern status_$t _mkrlog_status;

        if( _mkrlog_status.all != status_$ok )
        {
            fprintf(stderr, "Cannot create rolling log %s:", argv[1]);
            error_$print(_mkrlog_status);
            return 2;
        }
        else
        {
            char buffer[BUFSIZ];
            sprintf(buffer, "Cannot create rolling log %s", argv[1]);
            perror(buffer);
            return 3;
        }
    }

    return 0;
}
