/*
 * post_fork.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait post_fork
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_post_fork
(
    handle_t *&h,
    status_$t *status
)
{
    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( h->regulated )
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->regulated_readers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->regulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->regulated_writers++;
        }
    }
    else
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->unregulated_readers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->unregulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->unregulated_writers++;
        }
    }

    h->pfgs->users ++;
    h->pfgs->sfcb->header.use_count ++;

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();

    status->all = status_$ok;

    return;
}

