/*
 * putp.c
 * 
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait putp operation
 * for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

long int
rlog_putp
(
    handle_t *&h,
    ios_$put_get_opts_t &options,
    void *buffer,
    long int &buffer_length,
    status_$t *status
)
{   
    long int amount = buffer_length;
    long int start;

    if( options & ios_$preview_opt )
    {
        status->all = status_$ok;
        return 0;
    }

    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
        return 0;
    }

    if( h->read_only || h->read_intend_write )
    {
        status->all = ios_$read_only_err;
        return 0;
    }

    if( buffer_length < 0 )
    {
        status->all = ios_$put_bad_rec_len;
        return 0;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( amount > h->rlog->length )
    {
        amount = h->rlog->length;
        buffer = (void *)&((char *)buffer)[ buffer_length - amount ];
    }

    if( h->pfgs->stream_pointer < h->rlog->bof )
    {
        h->pfgs->stream_pointer = h->rlog->bof;
    }

    if( h->append_mode )
    {
        h->pfgs->stream_pointer = h->rlog->eof;
    }

    start = h->pfgs->stream_pointer % h->rlog->length;

    if( start + amount > h->rlog->length )
    {
        /*
         * Two parts
         */
        long int first_amount = h->rlog->length - start;
        long int second_amount = amount - first_amount;

        (void)memcpy(&h->data[ start ], (char *)buffer, first_amount);
        (void)memcpy(h->data, &((char *)buffer)[ first_amount ], second_amount);
    }
    else
    {
        /*
         * One part
         */
        (void)memcpy(&h->data[ start ], (char *)buffer, amount);
    }

    if( h->pfgs->stream_pointer + amount > h->rlog->eof )
    {
        h->rlog->eof = h->pfgs->stream_pointer + amount;
    }

    if( 
        h->rlog->eof > h->rlog->length &&
        h->rlog->eof - h->rlog->length > h->rlog->bof 
      )
    {
        h->rlog->bof = h->rlog->eof - h->rlog->length;
    }

    h->pfgs->stream_pointer += amount;

    ec2_$advance(&h->pfgs->sfcb->put, status);

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return buffer_length;
}
