/*
 * seek.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait seek operation
 * for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_seek
(
    handle_t *&h,
    ios_$abs_rel_t &abs_rel,
    ios_$seek_type_t &seek_type,
    long int &offset_value,
    status_$t *status
)
{   
    long int new_value = offset_value;

    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
        return;
    }

    if( seek_type == ios_$rec_seek )
    {
        status->all = ios_$illegal_operation;
        return;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( abs_rel == ios_$relative )
    {
        new_value += h->pfgs->stream_pointer;
    }

    if( new_value < h->rlog->bof )
    {
        status->all = ios_$BOF_err;
        pfm_$enable();
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        return;
    }

    if( new_value > h->rlog->eof )
    {
        status->all = ios_$end_of_file;
        pfm_$enable();
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        return;
    }

    h->pfgs->stream_pointer = new_value;
    status->all = status_$ok;
    pfm_$enable();
    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    return;
}
