/*
 * set_conn_flag.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait set_conn_flag
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_set_conn_flag
(
    handle_t *&h,
    ios_$conn_flag_t &conn_flag,
    boolean &on_off,
    status_$t *status
)
{   
    status->all = status_$ok;

    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
        return;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    switch( conn_flag )
    {
        case ios_$cf_append:
            h->append_mode = on_off;
            break;
        case ios_$cf_ipc:
        case ios_$cf_tty:
        case ios_$cf_vt:

            if( on_off )
            {
                status->all = ios_$illegal_operation;
            }

            break;
        case ios_$cf_unregulated:

            if( on_off )
            {
                if( h->regulated )
                {
                    h->regulated = false;

                    if( h->read_only )
                    {
                        h->pfgs->sfcb->regulated_readers--;
                        h->pfgs->sfcb->unregulated_readers++;
                    }
                    else if( h->read_intend_write )
                    {
                        h->pfgs->sfcb->regulated_riw_ers--;
                        h->pfgs->sfcb->unregulated_riw_ers++;
                    }
                    else
                    {
                        h->pfgs->sfcb->regulated_writers--;
                        h->pfgs->sfcb->unregulated_writers++;
                    }
                }
            }
            else
            {
                if( ! h->regulated )
                {
                    if( h->read_only )
                    {
                        if( h->pfgs->sfcb->unregulated_writers )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            h->regulated = true;
                            h->pfgs->sfcb->unregulated_readers--;
                            h->pfgs->sfcb->regulated_readers++;
                        }
                    }
                    else if( h->read_intend_write )
                    {
                        if( 
                               h->pfgs->sfcb->unregulated_riw_ers
                            || h->pfgs->sfcb->unregulated_writers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            h->regulated = true;
                            h->pfgs->sfcb->unregulated_riw_ers--;
                            h->pfgs->sfcb->regulated_riw_ers++;
                        }
                    }
                    else
                    {
                        if( 
                               h->pfgs->sfcb->unregulated_riw_ers
                            || h->pfgs->sfcb->unregulated_writers
                            || h->pfgs->sfcb->unregulated_readers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            h->regulated = true;
                            h->pfgs->sfcb->unregulated_writers--;
                            h->pfgs->sfcb->regulated_writers++;
                        }
                    }
                }
            }

            break;
        case ios_$cf_read_intend_write:
        case ios_$cf_write:

            if( h->read_only )
            {
                if( ! on_off )
                {
                    break;
                }

                if( conn_flag == ios_$cf_read_intend_write )
                {
                    if( h->regulated )
                    {
                        if( 
                               h->pfgs->sfcb->regulated_riw_ers
                            || h->pfgs->sfcb->unregulated_riw_ers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$riw, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$riw, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_only = false;
                            h->read_intend_write = true;
                            h->pfgs->sfcb->regulated_readers--;
                            h->pfgs->sfcb->regulated_riw_ers++;
                        }
                    }
                    else
                    {
                        if( h->pfgs->sfcb->regulated_riw_ers )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$riw, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$riw, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_only = false;
                            h->read_intend_write = true;
                            h->pfgs->sfcb->unregulated_readers--;
                            h->pfgs->sfcb->unregulated_riw_ers++;
                        }
                    }
                }
                else /* conn_flag == ios_$cf_write */
                {
                    if( h->regulated )
                    {
                        if( 
                               h->pfgs->sfcb->regulated_riw_ers
                            || h->pfgs->sfcb->unregulated_riw_ers
                            || h->pfgs->sfcb->regulated_readers
                            || h->pfgs->sfcb->unregulated_readers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_only = false;
                            h->read_intend_write = true;
                            h->pfgs->sfcb->regulated_readers--;
                            h->pfgs->sfcb->regulated_writers++;
                        }
                    }
                    else
                    {
                        if( 
                               h->pfgs->sfcb->regulated_riw_ers
                            || h->pfgs->sfcb->regulated_readers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_only = false;
                            h->read_intend_write = true;
                            h->pfgs->sfcb->unregulated_readers--;
                            h->pfgs->sfcb->unregulated_writers++;
                        }
                    }
                }
            }
            else if( h->read_intend_write )
            {
                if( conn_flag == ios_$cf_read_intend_write )
                {
                    xoid_$t xoid;
                    unsigned long int length = h->rlog->length;
                    unsigned long int length_mapped = 0;

                    xoid = h->pfgs->sfcb->header.xoid;

                    if( on_off )
                    {
                        break;
                    }

                    h->read_only = true;
                    h->read_intend_write = false;

                    ms_$fw_file(h->rlog, status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    ms_$fw_file(h->data, status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    ms_$unmap(h->rlog, sizeof(rlog_t), status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    ms_$unmap(h->data, length, status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    h->rlog = ms_$mapl_stream(
                                                xoid,
                                                0,
                                                sizeof(rlog_t),
                                                ms_$cowriters,
                                                ms_$r,
                                                true,
                                                &length_mapped,
                                                status
                                             );

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    h->data = ms_$addmap(
                                            h->rlog,
                                            sizeof(rlog_t),
                                            h->rlog->length,
                                            &length_mapped,
                                            status
                                        );

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    if( h->regulated )
                    {
                        h->pfgs->sfcb->regulated_riw_ers--;
                        h->pfgs->sfcb->regulated_readers++;
                    }
                    else
                    {
                        h->pfgs->sfcb->unregulated_riw_ers--;
                        h->pfgs->sfcb->unregulated_readers++;
                    }
                }
                else
                {
                    if( ! on_off )
                    {
                        break;  
                    }

                    if( h->regulated )
                    {
                        if( 
                               h->pfgs->sfcb->regulated_readers
                            || h->pfgs->sfcb->unregulated_readers
                          )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_intend_write = false;
                            h->write = true;
                            h->pfgs->sfcb->regulated_riw_ers--;
                            h->pfgs->sfcb->regulated_writers++;
                        }
                    }
                    else
                    {
                        if( h->pfgs->sfcb->regulated_readers )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$wr, status);

                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->read_intend_write = false;
                            h->write = true;
                            h->pfgs->sfcb->unregulated_riw_ers--;
                            h->pfgs->sfcb->unregulated_writers++;
                        }
                    }
                }
            }
            else /* h->write */
            {
                if( conn_flag == ios_$cf_read_intend_write )
                {
                    if( !on_off )
                    {
                        break;
                    }

                    h->write = false;
                    h->read_intend_write = true;

                    ms_$relock(h->rlog, ms_$riw, status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    ms_$relock(h->data, ms_$riw, status);

                    if( status->all != status_$ok )
                    {
                        break;
                    }

                    if( h->regulated )
                    {
                        h->pfgs->sfcb->regulated_writers--;
                        h->pfgs->sfcb->regulated_riw_ers++;
                    }
                    else
                    {
                        h->pfgs->sfcb->unregulated_writers--;
                        h->pfgs->sfcb->unregulated_riw_ers++;
                    }
                }
                else
                {
                    if( on_off )
                    {
                        break;
                    }

                    if( h->regulated )
                    {
                        ms_$relock(h->rlog, ms_$r, status);
    
                        if( status->all != status_$ok )
                        {
                            break;
                        }

                        ms_$relock(h->data, ms_$r, status);
    
                        if( status->all != status_$ok )
                        {
                            break;
                        }

                        h->write = false;
                        h->read_only = true;
                        h->pfgs->sfcb->regulated_writers--;
                        h->pfgs->sfcb->regulated_readers++;
                    }
                    else
                    {
                        if( h->pfgs->sfcb->unregulated_writers )
                        {
                            status->all = ios_$concurrency_violation;
                        }
                        else
                        {
                            ms_$relock(h->rlog, ms_$r, status);
        
                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            ms_$relock(h->data, ms_$r, status);
        
                            if( status->all != status_$ok )
                            {
                                break;
                            }

                            h->write = false;
                            h->read_only = true;
                            h->pfgs->sfcb->unregulated_writers--;
                            h->pfgs->sfcb->unregulated_readers++;
                        }
                    }
                }
            }

            break;
        default:
            status->all = ios_$illegal_operation;
            break;
    }

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
