/*
 * set_obj_flag.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait set_obj_flag
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_set_obj_flag
(
    handle_t *&h,
    ios_$obj_flag_t &obj_flag,
    boolean &on_off,
    status_$t *status
)
{
    status->all = status_$ok;

    if( h->inq_only )
    {
        status->all = ios_$inq_only_error;
        return;
    }

    switch( obj_flag )
    {
        case ios_$of_ascii:
            h->pfgs->sfcb->ascii = on_off;
            break;
        case ios_$of_delete_on_close:
            h->pfgs->sfcb->delete_on_close = on_off;
            break;
        case ios_$of_ftncc:
        case ios_$of_sparse_ok:
            status->all = ios_$flag_not_supported;
            break;
        case ios_$of_cond:
            break;
        default:
            status->all = ios_$illegal_operation;
    }

    return;
}
