/*
 * truncate.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait truncate
 * operation for the rlog type manager.
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_truncate
(
    handle_t *&h,
    status_$t *status
)
{
    if( h->inq_only || ! h->write )
    {
        status->all = ios_$illegal_operation;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    h->rlog->bof = h->rlog->eof = 0;
    h->pfgs->stream_pointer = 0;

    ms_$truncate(h->rlog, sizeof(rlog_t), status);

    if( status->all != status_$ok )
    {
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        pfm_$enable();
        return;
    }

    ms_$truncate(h->data, h->rlog->length, status);

    if( status->all != status_$ok )
    {
        mutex_$unlock(&h->pfgs->sfcb->header.slock);
        pfm_$enable();
        return;
    }

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
