/* 
    Copyright 1995 Sentinet Ltd
    All rights reserved.

    Lyndon David and Tom Brock

    Redistribution and use in any form are permitted provided that the
    following restrictions are are met:
	1.  Source distributions must retain this entire copyright notice
	    and comment.
	2.  Binary distributions must include the acknowledgement "This
	    product includes software developed by Lyndon David" in the
	    documentation or other materials provided with the
	    distribution.  This must not be represented as an endorsement
	    or promotion without specific prior written permission.
	3.  The origin of this software must not be misrepresented, either
	    by explicit claim or by omission.  Credits must appear in the
	    source and documentation.
	4.  Altered versions must be plainly marked as such in the source
	    and documentation and must not be misrepresented as being the
	    original software.
    This software is provided "as is" and without any express or implied
    warranties, including, without limitation, the implied warranties of
    merchantability and fitness for a particular purpose.


SCCS revision @(#)send_waitfor.c	2.1 5/20/95

*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <string.h>
#include <sys/time.h>

int main(int argc, char *argv[])
    {
    FILE *fpi,*fpo;
    time_t start_time;
    time_t end_time;
    double difference;
    fd_set fdset;
    struct timeval timeout;
    
    int i,timetowait,gotmatch;
    size_t maxlen;
    char *ptr;                        /* pointer to string receiving incoming charcters */

/* start the clock and initialize variable logging */
/* successfull string match                        */

    start_time=time(NULL);
    gotmatch=(1==0);

/* initialize timeout for waiting for character from */
/* serial port ie dont wait                          */

    timeout.tv_sec=1;
    timeout.tv_usec=0;

/* check that there are at least 4 parameters passed */
/* argv[0]  name used to call program                */
/* argv[1]  device name to open                      */
/* argv[2]  max time to wait                         */
/* argv[3]  sendstring                               */
/* argv[4]  string1                                  */


    if(argc<4)
        {
        fprintf(stderr,"Error: Insufficient arguments supplied\n");
        exit(EXIT_FAILURE);
        }

/* check that argv[2] is a valid time to wait for a match */
/* for stringn arriving at port. Must be postitive and    */
/* 0 shall be wait forever                                */

    if(sscanf(argv[2],"%i",&timetowait)!=1)
        {
        fprintf(stderr,"Error in time to wait parameter\n");
        exit(EXIT_FAILURE);
        }

    if(timetowait<0)
        {
        fprintf(stderr,"Error in time to wait parameter, must be positive\n");
        exit(EXIT_FAILURE);
        }

/* read in device path and open for reading and writing */

    fpi = fopen(argv[1], "r");
    if (fpi==NULL) 
        {
        perror("Error opening stream ");
        exit(EXIT_FAILURE);
        }

    fpo = fopen(argv[1], "w");
    if (fpo==NULL) 
        {
        perror("Error opening stream ");
        exit(EXIT_FAILURE);
        }

    setbuf(fpi,NULL);
/*    setbuf(fpo,NULL);  */

/* send sendstring */

    if (fprintf(fpo,"%s\r",argv[3])<0)
        {
        perror("Error writing to stream ");
        exit(EXIT_FAILURE);
        }
       
    fflush(fpo);
  
/* determine max length of stringn           */
/* if there are only 4 args then there is    */
/* nothing to wait for so quit now           */

    if (argc>4)
        {
        maxlen=0;
        i=4;
        while (i<argc)
            {
            if (strlen(argv[i])>maxlen)
                maxlen=strlen(argv[i]);
            i=i+1;
            }

/* allocate storage space for incoming characters */
/* note that an extra byte is added for the end   */
/* null character. Initially fill the string with */
/* spaces                                         */

        ptr=calloc((maxlen+1),sizeof(char));
        if (ptr==NULL)
            {
            fprintf(stderr,"Error allocating memory\n");
            exit(EXIT_FAILURE);
            }
        ptr[maxlen]=0;
        for(i=0;i<maxlen;i++)
            ptr[i]=55;


/* now read characters from input stream until time is up or match made */


        while((((difftime(time(NULL),start_time)<=timetowait))||(timetowait==0))&&(!gotmatch))
            {
            FD_ZERO(&fdset);
            FD_SET(fileno(fpi),&fdset);
            select(fileno(fpi)+1,&fdset,NULL,NULL,&timeout);
            if(FD_ISSET(fileno(fpi),&fdset))
                {
/* we can now get the available character and add it */
/* to the end of the incoming string                 */
/* also send a copy to standard error so we can see  */
/* what is going on                                  */

                for(i=0;i<(maxlen-1);i++)
                    ptr[i]=ptr[i+1];
                ptr[maxlen-1]=getc(fpi);

                fprintf(stderr,"%s",&ptr[maxlen-1]);

/* the incoming string is now ready to be scanned       */
/* to see if it contains a match for any of the strings */
/* if we get a match then we send a newline to finish   */
/* off the output to standard error then send the match */
/* string out to standard out                           */

                for(i=4;i<argc;i++)
                    {
                    if(strstr(ptr,argv[i])!=NULL)
                        {
                        gotmatch=(1==1);
                        fprintf(stderr,"\n");
                        printf("%s\n",argv[i]);
                        i=argc;
                        }
                    }
                }
            }
        }


/* At this point we either have a match, in this case gotmatch is true */
/* or there was no match or there were no match strings given          */
/* in this case gotmatch will be false the newline to standare error   */
/* is to finish off the output neatly if you have both stderr and      */
/* stdout going to a terminal together                                 */

    if(!gotmatch)
        {
        fprintf(stderr,"\n");
        printf("No match\n");
        }

/* close streams and exit */


    fclose(fpi);
    fclose(fpi);
    exit(EXIT_SUCCESS);

    }
