/*
 * sntp server.  See rfc1361.
 * Jim Rees University of Michigan Jan 1998
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#ifdef __STDC__
#include <unistd.h>
#include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>

#define PORT 123
#define UNIXOFFSET -2085978496

struct {
    unsigned char livnmode, stratum, poll, prec;
    unsigned int delay, disp, refid;
    unsigned int reftime[2], origtime[2], rcvtime[2], txtime[2];
} pkt;

int vflag;

#ifndef __STDC__
extern char *optarg;
#endif

int
main(ac, av)
int ac;
char *av[];
{
    int i, fd, len, n, mode, port = PORT;
    struct sockaddr_in saddr;
    struct timeval tv;
    unsigned long ntpsec, ntpmsec;

    while ((i = getopt(ac, av, "vp:")) != -1) {
	switch (i) {
	case 'p':
	    port = atoi(optarg);
	    break;
	case 'v':
	    vflag = 1;
	    break;
	}
    }

    if (ac < 2) {
	fprintf(stderr, "usage: sntpd [-v] [-p port]\n");
	exit(1);
    }

    /* Get a socket */

    if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror("socket");
	exit(1);
    }

    /* Bind it to the port */

    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(port);
    saddr.sin_addr.s_addr = INADDR_ANY;

    if (bind(fd, (struct sockaddr *) &saddr, sizeof saddr) < 0) {
	perror("bind");
	exit(1);
    }

    /* Service requests */

    while (1) {
	len = sizeof saddr;
	if ((n = recvfrom(fd, &pkt, sizeof pkt, 0, (struct sockaddr *) &saddr, &len)) < 0) {
	    perror("recvfrom");
	    break;
	}

	/* LI=0, same version, fix mode */
	mode = pkt.livnmode & 0x7;
	mode = (mode == 3) ? 4 : 2;
	pkt.livnmode &= 0x38;
	pkt.livnmode |= mode;

	pkt.stratum = 1;
	pkt.prec = 0;
	pkt.delay = 0;
	pkt.disp = 0;
	pkt.refid = 0;

	/* Get the time and fill it in */
	gettimeofday(&tv, NULL);
	ntpsec = htonl(tv.tv_sec + UNIXOFFSET);
	ntpmsec = htonl(tv.tv_usec * 4295);
	pkt.reftime[0] = ntpsec;
	pkt.reftime[1] = ntpmsec;
	pkt.rcvtime[0] = ntpsec;
	pkt.rcvtime[1] = ntpmsec;
	pkt.txtime[0] = ntpsec;
	pkt.txtime[1] = ntpmsec;

	if (sendto(fd, &pkt, sizeof pkt, 0, (struct sockaddr *) &saddr, sizeof saddr) < 0)
	    perror("sendto");

	if (vflag)
	    printf("%s:%d n %d\n", inet_ntoa(saddr.sin_addr), ntohs(saddr.sin_port), n);
    }
    close(fd);
    exit(0);
}

/*
copyright 1997
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
