      program stwar_main
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                       
c    STWAR_MAIN is a small driver that calls the various routines that 
c    handle the phases for each wave.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include '/sys/ins/time.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 font(3), clock(3), wait(3)
      integer*4 bitmap_desc, shields, score, wave, status, zero
      integer*4 center(2, 10), radius(10), score_inc, start
      real seed, phox(10), phoy(10), phoz(10), phvel(3, 10), p(3, 3)
      real z
      character text*10, bonus*80
      logical scored, photon(10), hit_port, refresh, cleared, fire
      common / phot$/ phox, phoy, phoz, phvel, photon
      data score, shields / 0, 9/
      data wait / 0, 0, 15000/
      data scored, refresh / 2 * .true./
      data ending /'01', '02', '03', '04', '05', '06', '07', '08', '09',
     &             '10', '11', '12', '13', '14', '15', '16', '17', '18',
     &             '19', '20', '21', '22', '23', '24', '25', '26', '27',
     &             '28', '29', '30', '31', '32', '33', '34', '35', '36',
     &             '37', '38', '39', '40'/
      data p, z / 10 * 0.0/
c
c    read the data file for wave information
c
      open (unit = 1 , file = '//plumbum/usr/local/src/games/stwar/stwar
     1_info.dir/stwar_main.info')
      read (1, *) towers_max, towers_cycle
      read (1, *) tunnel_max, tunnel_cycle
      read (1, *) (start_level(i), i = 1, 3)
      read (1, *) (start_bonus(i), i = 1, 3)
      close (1)
c
c    set up the static graphics
c
      call stwar_screen_init (bitmap_desc, font)
      call gpr_$set_clipping_active (.false., status)
      call stwar_update_score (0, 0, scored)
      call stwar_update_shields (shields, font)
      call stwar_pick_wave (wave, start, font)
      call gpr_$set_clipping_active (.false., status)
c
c    seed the random number generator using the system clock
c
      call cal_$get_local_time (clock)
      seed = abs(clock(3) / 33000.0)      
      seed = min (1.0, seed)
      seed = max (0.0, seed)
      clock(1) = 0
      clock(2) = 12
      clock(3) = 0
c
c    print out the wave number
c
      call gpr_$move (int2(705), int2(70), status)
      write (text, '(i3)') wave
      call gpr_$set_text_font (font(1), status)
      call gpr_$set_text_value (6, status)
      call gpr_$text (text, int2(3), status)
      call gpr_$set_clipping_active (.true., status)
c
c   start the wave loop (infinite)
c
 10   continue
      call stwar_photons 
      call stwar_draw_photons (z, p, center, radius, refresh)
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
      call stwar_tfight (score, wave, shields, font, fire, seed)
      call stwar_photons 
      call stwar_draw_photons (z, p, center, radius, refresh)
      call stwar_ds (.true., font, fire, score, seed)
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
      call stwar_towers (score, wave, shields, font, seed, cleared)
 20   continue
      call stwar_photons 
      call stwar_draw_photons (z, p, center, radius, refresh)
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
      call stwar_tunnel (score, wave, shields, font, seed, hit_port)      
      if (.not. hit_port) then
        shields = shields - 1
        if (shields .lt. 0) then
          call stwar_scores (score, font)
        end if
        call stwar_update_shields (shields, font)        
        goto 20
      end if
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
      fire = .false.
      call stwar_ds (.false., font, fire, score, seed)
c
c    assign bonus points (death star, towers, shields left)
c    and add bonus shields
c
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
      call gpr_$set_clipping_active (.false., status)
      call gpr_$set_text_font (font(1), status)      
      call gpr_$set_text_value (6, status)       
      bonus = '                     25,000'
      call gpr_$move (int2(150), int2(225), status)
      call gpr_$text (bonus, int2(27), status)
      call gpr_$set_text_value (9, status)      
      bonus = 'BONUS FOR DESTROYING'
      call gpr_$move (int2(150), int2(200), status)
      call gpr_$text (bonus, int2(20), status)
      bonus = 'DEATH STAR .........'
      call gpr_$move (int2(150), int2(225), status)
      call gpr_$text (bonus, int2(20), status)
      score = score + 25000
      score_inc = 25000
      scored = .true.
      do 30 i = 1, 30
        call stwar_update_score (score, score_inc, scored)
        call time_$wait (time_$relative, wait, status)
 30   continue
      j = 300
      if (cleared) then
        call gpr_$set_text_value (6, status)       
        bonus = '                     50,000'
        i = j + 25
        call gpr_$move (int2(150), int2(i), status)
        call gpr_$text (bonus, int2(27), status)
        call gpr_$set_text_value (9, status)      
        bonus = 'BONUS FOR DESTROYING'
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(20), status)
        bonus = 'ALL TOWERS .........'
        call gpr_$move (int2(150), int2(i), status)
        call gpr_$text (bonus, int2(20), status)
        score = score + 50000
        score_inc = 50000
        scored = .true.
        do 40 i = 1, 30
          call stwar_update_score (score, score_inc, scored)
          call time_$wait (time_$relative, wait, status)
 40     continue
        j = 400
      end if          
      call gpr_$set_text_value (6, status)       
      score_inc = shields * 5000
      write (bonus, '(21x, i2, '',000'')') score_inc / 1000
      i = j + 25
      call gpr_$move (int2(150), int2(i), status)
      call gpr_$text (bonus, int2(27), status)
      call gpr_$set_text_value (9, status)      
      bonus = 'BONUS FOR REMAINING'
      call gpr_$move (int2(150), int2(j), status)
      call gpr_$text (bonus, int2(20), status)
      bonus = 'SHIELDS ............'
      call gpr_$move (int2(150), int2(i), status)
      call gpr_$text (bonus, int2(20), status)
      score = score + score_inc
      scored = .true.
      do 50 i = 1, 30
        call stwar_update_score (score, score_inc, scored)
        call time_$wait (time_$relative, wait, status)
 50   continue      
      if (start .ne. 0) then
        j = j + 100
        call gpr_$set_text_value (6, status)       
        write (bonus, '(20x, i3, '',000'')') start / 1000
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(27), status)
        call gpr_$set_text_value (9, status)      
        bonus = 'STARTING WAVE BONUS'
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(19), status)
        score = score + start
        score_inc = start
        scored = .true.
        start = 0
        do 60 i = 1, 30
          call stwar_update_score (score, score_inc, scored)
          call time_$wait (time_$relative, wait, status)
 60     continue        
        j = j - 25
      end if
      j = j + 100
      i = min (2, 9 - shields)
      shields = shields + i
      call gpr_$set_text_value (9, status)      
      if (i. eq. 2) then
        bonus = '2 SHIELDS REPLACED'
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(18), status)
        j = j + 25
      else if (i .eq. 1) then
        bonus = '1 SHIELD REPLACED'
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(17), status)
        j = j + 25
      end if
      if (shields .eq. 9) then
        call gpr_$set_text_value (7, status)      
        bonus = 'SHIELDS AT FULL STRENGTH'
        call gpr_$move (int2(150), int2(j), status)
        call gpr_$text (bonus, int2(24), status)
      end if
      call stwar_update_shields (shields, font)
      wave = wave + 1
      call gpr_$move (int2(705), int2(70), status)
      write (text, '(i3)') wave
      call gpr_$set_text_value (6, status)
      call gpr_$text (text, int2(3), status)
      call time_$wait (time_$relative, clock, status)
      goto 10
      end
         
