      subroutine stwar_ds (in, font, fire, score, seed)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.0                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        1/87                             *****
c    *****                                                         *****
c    *****        Massachusetts  Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                       
c     STWAR_DS handles the graphics for the approach and
c     retreat from the death star.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'     
c
      integer*2 position(2), event_type, font(3), cur_op(8)
      integer*2 timer(3), origin(2)
      integer*4 status, star(3, 40), counter, cursor_bitmap
      integer*4 ix, iz, score, score_inc, inc
      real p(3, 3), dr(3, 3), r(3, 3), b(3, 3), seed, rand
      real c(3, 3), side, crit, xt, yt, zt, stpnt(3, 40)
      real x, y, z, phi, psi, theta, c1, s1, c2, s2, c3, s3
      real ct, st, cp, sp, sx, sz, rnorm, chkx, chkz, yvel
      real rscale, w1(3, 3), w2(3, 3)
      double precision turn, duration, elapsed
      logical in, fire, shoot, event, active, moved, rotate
      logical ds, scored
      character key
      external rand
      common /star$/ star, stpnt
      data rscale / 4.0e-4/
c
c    set up some initial parameters
c
      counter = 0
      score_inc = 0
      inc     = 2
      scored  = .false.
      rotate  = .false.
      shoot   = .false.
c
c    set up the additional rotation matrix r
c
      do 20 i = 1, 3
        do 30 j = 1, 3
          r(i, j) = 0.0
 30     continue
        r(i, i) = 1.0
 20   continue
      if (in) then
        theta = 0.02 * (rand(seed))
        if (rand(seed) .gt. 0.5) theta = -theta
        c4 = cos(theta)
        s4 = sin(theta)
        call stwar_view_dr (w1, seed)
        w2(1, 1) = c4
        w2(2, 1) = 0.0
        w2(3, 1) = -s4
        w2(1, 2) = 0.0
        w2(2, 2) = 1.0
        w2(3, 2) = 0.0
        w2(1, 3) = s4
        w2(2, 3) = 0.0
        w2(3, 3) = c4
        call stwar_matrix_multiply (w2, w1, dr, 1)
        do 40 i = 1, 60
          call stwar_matrix_multiply (dr, r, c, 2)
          do 50 j = 1, 3
            do 60 k = 1, 3
              r(j, k) = c(j, k)
 60         continue
 50       continue
 40     continue
        rotate = .true.
      end if
      if (in) then
        x = 0.0
        y = 5000.0
        z = 0.0
        yvel = -45.0
      else
        x = 0.0
        y = 500.0
        z = 0.0
        yvel = +40.0
        counter = 60
      end if        
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    begin animation
c
110   continue
      passes = 0
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin , status)
120   continue
        if (passes .ge. 2) goto 130
          passes = passes + 1
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            if (key .eq. 'a') then
              fire = .true.
            else if (key .eq. 'A') then
              fire = .false.
            else if (key .eq. 'b') then
              position(1) = 400
              position(2) = 425
              call gpr_$set_cursor_position (position, status)         
            else if (key .eq. 'c') then
              call pause (font)
            end if
          end if
        goto 120
130   continue
c
c    limit x and z positions and cursor location (no clipping)
c
      ix = position(1) - 400.0
      iz = position(2) - 425.0
      moved = .false.                               
      if (abs(ix) .gt. 305) then
        position(1) = 400 + sign(305, ix)
        moved = .true.
      end if
      if (abs(iz) .gt. 305) then
        position(2) = 425 + sign(305, iz)
        moved = .true.
      end if      
      if (moved) then
        call gpr_$set_cursor_position (position, status)
      end if                    
c
c    set up the base rotation matrix
c
      st = sin (rscale * (position(1) - 400))
      ct = cos (rscale * (position(1) - 400))
      sp = sin (0.25 * rscale * (position(2) - 425))
      cp = cos (0.25 * rscale * (position(2) - 425))
      b(1, 1) = ct
      b(2, 1) = -sp * st
      b(3, 1) = -cp * st
      b(1, 2) = 0.0
      b(2, 2) = cp
      b(3, 2) = -sp
      b(1, 3) = st
      b(2, 3) = sp * ct
      b(3, 3) = cp * ct
c
c    update the additional rotation matrix
c
      counter = counter + 1
      if (counter .gt. 60) rotate = .false.
      if (rotate) then
        call stwar_matrix_multiply (dr, r, c, 1)
        do 140 i = 1, 3
          do 150 j = 1, 3
            r(i, j) = c(i, j)
150       continue
140     continue
      end if
c                                t
c    rotate the star points by dr  
c
      if (rotate) then
        xt = dr(2, 1)
        zt = dr(2, 3)
        if (xt .lt. 0.0) then
          sx = 1.0
        else
          sx =-1.0
        end if
        if (zt .lt. 0.0) then
          sz = 1.0
        else
          sz =-1.0
        end if
        rnorm = max (sqrt (xt**2 + zt**2), 1.0e-3)
        crit = abs(xt / rnorm)
        do 160 i = 1, 40
          xt = dr(1, 1) * stpnt(1, i) + dr(2, 1) * stpnt(2, i) + 
     &         dr(3, 1) * stpnt(3, i) 
          yt = dr(1, 2) * stpnt(1, i) + dr(2, 2) * stpnt(2, i) + 
     &         dr(3, 2) * stpnt(3, i) 
          zt = dr(1, 3) * stpnt(1, i) + dr(2, 3) * stpnt(2, i) + 
     &         dr(3, 3) * stpnt(3, i)             
          if (yt .gt. 5000) then
            chkx = abs (xt / yt)
            chkz = abs (zt / yt)
            if (chkx .gt. 1.4 .or. chkz .gt. 1.4) then
              if (rand(seed) .le. crit) then
                l = 1
                side = sx
              else
                l = 3
                side = sz
              end if
              stpnt(1, i) = 28000.0 * rand(seed) - 14000.0
              stpnt(2, i) = 12000.0
              stpnt(3, i) = 28000.0 * rand(seed) - 14000.0
              stpnt(l, i) = 14000.0 * side * (1.0 - 0.4 * rand(seed))
            else
              stpnt(1, i) = xt
              stpnt(2, i) = yt
              stpnt(3, i) = zt
            end if
          else
            if (rand(seed) .le. crit) then
              l = 1
              side = sx
            else
              l = 3
              side = sz
            end if
            stpnt(1, i) = 28000.0 * rand(seed) - 14000.0
            stpnt(2, i) = 12000.0 
            stpnt(3, i) = 28000.0 * rand(seed) - 14000.0
            stpnt(l, i) = 14000.0 * side * (1.0 - 0.2 * rand(seed))
          end if
160     continue
      end if
c
c    form the player rotation matrix P
c
      call stwar_matrix_multiply (r, b, p, 1)
c
c    check to see if death star is visible
c
      dx = y * p(2, 1)
      dy = y * p(2, 2)
      dz = y * p(2, 3)
      ds = .false.
      if (dy .gt. 0.001) then
        prox = dx / dy
        proz = dz / dy
        if (abs(prox) .lt. 1.5 .and. abs(proz) .lt. 1.5) then
          ds = .true.
        end if    
      end if
c
c    rotate the stars by the base rotation
c
      do 170 i = 1, 40
        stpnt(2, i) = stpnt(2, i) + yvel
        star(1, i) = b(1, 1) * stpnt(1, i) + b(2, 1) * stpnt(2, i) + 
     &               b(3, 1) * stpnt(3, i)
        star(2, i) = b(2, 2) * stpnt(2, i) + b(3, 2) * stpnt(3, i)
        star(3, i) = b(1, 3) * stpnt(1, i) + b(2, 3) * stpnt(2, i) + 
     &               b(3, 3) * stpnt(3, i)         
170   continue 
c
c    propagate the death star
c
      y = y + yvel
c
c    refresh the graphics
c
      call gpr_$set_clipping_active (.true., status)
      call stwar_draw_stars ()
      call stwar_draw_ds (x, y, z, p, ds)
      call stwar_draw_x_hairs (position)
      call stwar_draw_phasers (position, fire, inc, shoot)
      call gpr_$set_clipping_active (.false., status)
c
c    update the score
c
      call stwar_update_score (score, score_inc, scored)
c
c    if we have gone far enough then end
c
      if (counter .gt. 100) then
        if (in) then
          return
        else
          call stwar_ds_explosion (position, seed)
          return
        end if
      end if
c
c    repeat the sequence after timing the turn
c
180   continue
      call time_$clock (timer)
      call cal_$float_clock (timer, turn)
      duration = turn - elapsed
      if (duration .gt. 0.08) then
        elapsed = turn
        goto 110
      end if
      goto 180     
      end
        




      subroutine stwar_draw_ds (x, y, z, p, seen)
c
c     STWAR_DRAW_DS draws the full-blown death star centered
c     at (x, y, z) viewed from the origin with rotation matrix
c     P.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 hex_x(7), hex_y(7), hex_z(7), radius, center(2)
      integer*2 hem_x(21), hem_y(21), hem_z(21)
      integer*2 poly_x(21, 2), poly_y(21, 2), mult_x(14), mult_y(14)
      integer*2 dot_x(11, 4), dot_y(11, 4), dot_z(11, 4)
      integer*2 line_x(44), line_y(44)
      integer*4 status
      real x, y, z, p(3, 3), prx, pry, prz, dx, dy, dz
      logical last, seen
      save last, radius, center, poly_x, poly_y, mult_x, mult_y
      save line_x, line_y
      data hex_x / 47, 66, 60, 33, 14, 20, 36/
      data hex_y / -51, -55, -74, -89, -85, -66, -62/
      data hex_z / 69, 47, 24, 24, 47, 69, 42/
      data hem_x / 100, 99, 95, 89, 81, 71, 59,
     &             45, 31, 16, 0, -16, -31, -45, -59, -71, -81, 
     &            -89, -95, -99, -100/
      data hem_y / 0, -16, -31, -45, -59, -70, 
     &            -81, -89, -95, -98, -100, -98, -95, -89, -81, 
     &            -70, -59, -45, -31, -16, 0/
      data hem_z / 0, -1, -3, -4, -5, -6, -7, -8,
     &            -8, -9, -9, -9, -8, -8, -7, -6, -5, -4, -3, 
     &            -1, 0/
      data dot_x / 88, 88, 88, 88, 88, 0, -23, -45, -64, -78, -88,
     &             79, 71, 58, 41, 21, 0, -21, -41, -58, -71, -78,
     &              4, 9, 12, 12, 17, 17, 17, 15, 12, 9, 4,
     &            -20, -38, -54, -66, -74, -77, -74, -66, -54, -38, -20/
      data dot_y / 23, 23, 23, 23, 23, 91, 88, 78, 64, 45, 23,
     &             21, 41, 58, 71, 79, 82, 79, 71, 58, 41, 21,
     &             25, 49, 70, 70, 95, 98, 95, 85, 70, 49, 25,
     &             17, 32, 45, 56, 62, 64, 62, 56, 45, 32, 17/
      data dot_z / 11 * 42, 11 * -57, 97, 87, 70, 70, 26, 0, -26,
     &             -50, -71, -87, -97, 97, 87, 71, 50, 26, 0, -26,
     &             -50, -71, -87, -97/
      data last / .false./
c
c    erase if drawn last update
c
      if (last) then
        call gpr_$set_draw_value (15, status)
        call gpr_$circle (center, radius, status)
        call gpr_$move (poly_x(6, 1), poly_y(6, 1), status)
        call gpr_$polyline (poly_x(1, 1), poly_y(1, 1), int2(6), status)
        call gpr_$move (poly_x(1, 2), poly_y(1, 2), status)
        call gpr_$polyline (poly_x(1, 2), poly_y(1, 2), int2(21), 
     &                      status)
        call gpr_$multiline (mult_x, mult_y, int2(14), status)
        do 10 i = 1, 44
          call gpr_$move (line_x(i), line_y(i), status)
          call gpr_$line (line_x(i), line_y(i), status)
 10     continue
      end if
      if (seen) then
        do 20 i = 1, 7
          xoff = hex_x(i) + x
          yoff = hex_y(i) + y
          zoff = hex_z(i) + z
          prx = xoff * p(1, 1) + yoff * p(2, 1) + zoff * p(3, 1)
          pry = xoff * p(1, 2) + yoff * p(2, 2) + zoff * p(3, 2)
          prz = xoff * p(1, 3) + yoff * p(2, 3) + zoff * p(3, 3)
          if (pry .lt. 15.0) pry = 15.0
          poly_x(i, 1) = 400 + prx / pry * 350
          poly_y(i, 1) = 425 - prz / pry * 350            
 20     continue
        do 30 i = 1, 21
          xoff = hem_x(i) + x
          yoff = hem_y(i) + y
          zoff = hem_z(i) + z
          prx = xoff * p(1, 1) + yoff * p(2, 1) + zoff * p(3, 1)
          pry = xoff * p(1, 2) + yoff * p(2, 2) + zoff * p(3, 2)
          prz = xoff * p(1, 3) + yoff * p(2, 3) + zoff * p(3, 3)
          if (pry .lt. 15.0) pry = 15.0
          poly_x(i, 2) = 400 + prx / pry * 350
          poly_y(i, 2) = 425 - prz / pry * 350            
 30     continue      
        do 40 i = 1, 6
          j = i * 2
          k = j - 1
          mult_x(j) = poly_x(i, 1)
          mult_y(j) = poly_y(i, 1)
          mult_x(k) = poly_x(7, 1)
          mult_y(k) = poly_y(7, 1)
 40     continue
        do 50 i = 12, 20
          if (poly_x(i, 2) .lt. poly_x(i + 1, 2)) then
            poly_x(i + 1, 2) = poly_x(i, 2)
            poly_y(i + 1, 2) = poly_y(i, 2)
          end if
 50     continue
        do 60 i = 11, 2, -1
          if (poly_x(i, 2) .gt. poly_x(i - 1, 2)) then
            poly_x(i - 1, 2) = poly_x(i, 2)
            poly_y(i - 1, 2) = poly_y(i, 2)
          end if
 60     continue
        k = 1
        do 70 i = 1, 4
          do 80 j = 1, 11
            xoff =  dot_x(j, i) + x
            yoff = -dot_y(j, i) + y
            zoff =  dot_z(j, i) + z
            prx = xoff * p(1, 1) + yoff * p(2, 1) + zoff * p(3, 1)
            pry = xoff * p(1, 2) + yoff * p(2, 2) + zoff * p(3, 2)
            prz = xoff * p(1, 3) + yoff * p(2, 3) + zoff * p(3, 3)
            if (pry .lt. 15.0) pry = 15.0
            line_x(k) = 400 + prx / pry * 350
            line_y(k) = 425 - prz / pry * 350            
            k = k + 1
 80       continue
 70     continue
        prx = x * p(1, 1) + y * p(2, 1) + z * p(3, 1)
        pry = x * p(1, 2) + y * p(2, 2) + z * p(3, 2)
        prz = x * p(1, 3) + y * p(2, 3) + z * p(3, 3)
        if (pry .lt. 15.0) pry = 15.0
        origin_x = 400 + prx / pry * 350
        origin_y = 425 - prz / pry * 350            
        r1 = sqrt((poly_x(21, 2) - origin_x)**2 +
     &            (poly_y(21, 2) - origin_y)**2)               
        center(1) = origin_x
        center(2) = origin_y
        radius = r1
        call gpr_$set_draw_value (7, status)
        call gpr_$move (poly_x(6, 1), poly_y(6, 1), status)
        call gpr_$polyline (poly_x(1, 1), poly_y(1, 1), int2(6), status)
        call gpr_$multiline (mult_x, mult_y, int2(14), status)
        call gpr_$set_draw_value (5, status)
        call gpr_$move (poly_x(1, 2), poly_y(1, 2), status)
        call gpr_$polyline (poly_x(1, 2), poly_y(1, 2), int2(21), 
     &                      status)
        if (y .gt. 1000) then
          call gpr_$set_draw_value (4, status)
        else
          call gpr_$set_draw_value (5, status)
        end if
        do 90 i = 1, 44
          call gpr_$move (line_x(i), line_y(i), status)
          call gpr_$line (line_x(i), line_y(i), status)
 90     continue
        call gpr_$set_draw_value (8, status)
        call gpr_$circle (center, radius, status)
        last = .true.
      else
        last = .false.
      end if
      return
      end





      subroutine stwar_ds_explosion (position, seed)
c
c     STWAR_DS_EXPLOSION Depicts a death star in its death throes.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
c
      integer*2 position(2), line_x(150), line_y(150)
      integer*2 timer(3)
      integer*4 status, value, color, star(3, 40)
      real rand, seed, fract, stpnt(3, 40), x(150), y(150), z(150)
      real vel(3, 150)
      double precision turn, duration, elapsed
      external rand
      common /star$/ star, stpnt
c
c    clear the screen
c
      call gpr_$set_clipping_active (.true., status)
      call gpr_$clear (15, status)
c
c    draw the stars and x-hairs one last time
c
      call stwar_draw_stars () 
      call stwar_draw_x_hairs (position)     
c
c    get random velocity vectors for the death star chunks
c
      do 10 i = 1, 150
        do 20 j = 1, 3
          vel(j, i) = 35.0 * (rand(seed) - 0.5)
 20     continue                                
        x(i) = 0.0
        y(i) = 1600.0
        z(i) = 0.0
 10   continue
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    start a loop wherein we remap color 15 (grading from bright
c    white to black) and propagate chunks
c
      do 30 i = 1, 100
        fract = i * 2.5
        value = (255 - fract)
        color = (65536 * value) + (256 * value) + value
        call gpr_$set_color_map (15, int2(1), color, status)
        k = 0
        do 50 j = 1, 150
          x(j) = x(j) + vel(1, j)
          y(j) = y(j) + vel(2, j)
          z(j) = z(j) + vel(3, j) 
          if (y(j) .gt. 100.0 .and. y(j) .lt. 4000.0) then
            k = k + 1
            line_x(k) = 400 + x(j) / y(j) * 350
            line_y(k) = 425 - z(j) / y(j) * 350            
          end if
 50     continue
        if (i .gt. 25) then
          call gpr_$set_draw_value (6, status)
          do 60 j = 1, k
            call gpr_$move (line_x(j), line_y(j), status)
            call gpr_$line (line_x(j), line_y(j), status)
 60       continue   
        end if
        if (mod(i, 5) .eq. 0) then
          call stwar_draw_stars () 
          call stwar_draw_x_hairs (position)     
        end if
 70     continue
        call time_$clock (timer)
        call cal_$float_clock (timer, turn)
        duration = turn - elapsed
        if (duration .lt. 0.05) then
          goto 70
        end if
        elapsed = turn
 30   continue
      call gpr_$set_color_map (15, int2(1), 0, status)
      call gpr_$clear (15, status)
      return
      end 
        
        



      subroutine stwar_draw_ds_simple (x, y, type)
c
c     STWAR_DRAW_DS_SIMPLE draws a very simple, constant radius
c     death star for use with STWAR_PICK_WAVE.
c
      integer*2 center(2), radius, poly_x(12), poly_y(12)
      integer*2 x1(6), y1(6), x2(12), y2(12), x3(10), y3(10)
      integer*4 status, type
      real x, y
      save radius, x1, y1, x2, y2, x3, y3
      data radius / 70/
      data x1 / 55, 35, 15, 16, 37, 56/
      data y1 / -32, -49, -42, -21, -3, -11/
      data x2 / 55, 32, 35, 32, 15, 32, 16, 32, 37, 32, 56, 32/
      data y2 / 32, 24, 49, 24, 42, 24, 21, 24, 3, 24, 11, 24/
      data x3 / 30, -45, 3, -8, 16, 6, -47, 37, -59, -3/
      data y3 / -9, 14, -29, -48, -25, -36, 35, -45, -1, -39/
      call gpr_$set_draw_value (8, status)
      center(1) = x
      center(2) = y
      call gpr_$circle (center, radius, status)
      call gpr_$set_draw_value (7, status)
      if (type .ge. 2) then
        do 10 i = 1, 6
          poly_x(i) = x1(i) + x
          poly_y(i) = y1(i) + y
 10     continue
        call gpr_$move (poly_x(6), poly_y(6), status)
        call gpr_$polyline (poly_x, poly_y, int2(6), status)
      end if
      if (type .eq. 3) then
        do 20 i = 1, 12
          poly_x(i) = x2(i) + x
          poly_y(i) = y - y2(i)
 20     continue
        call gpr_$multiline (poly_x, poly_y, int2(12), status)
      end if
      call gpr_$set_draw_value (8, status)
      do 30 i = 1, 10
        poly_x(1) = x3(i) + x
        poly_y(1) = y - y3(i)
        call gpr_$move (poly_x(1), poly_y(1), status)
        call gpr_$line (poly_x(1), poly_y(1), status)
 30   continue
      return
      end
