      subroutine stwar_tfight (score, wave, shields, font, fire, seed)
c
c    *******************************************************************
c    *****                                                         *****
c    *****                 STAR WARS VERSION 1.1                   *****
c    *****                                                         *****
c    *****                      written by                         *****
c    *****                                                         *****
c    *****                 Justin S. Revenaugh                     *****
c    *****                                                         *****
c    *****                        8/87                             *****
c    *****                                                         *****
c    *****               Lunchtime Software Guild                  *****
c    *****        Massachussetts Institute of Technology           *****
c    *****  Department of Earth, Atmospheric and Planetary Science *****
c    *****                                                         *****
c    *******************************************************************
c                                                                             
c     STWAR_TFIGHT is the main subroutine for the tie-fighters phase.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 font(3), position(2), event_type, origin(2), cur_op(8)
      integer*2 timer(3)
      integer*4 status, score, shields, wave, passes, which
      integer*4 cursor_bitmap, score_inc, center(2, 10), radius(10)
      integer*4 tf_center(2, 2), tf_radius(2), num_col, col_obj(10)
      integer*4 counter, ix, iz, explode_counter(2), phase_counter
      integer*4 star(3, 40), index, explode_dr(2), rot_dr, rot_fix(4)
      integer*4 rot_counter, turn_counter, action_counter, add_delay
      integer*4 since(2), action_max, inc, whosht, shoot_inc
      integer*4 man(2), man_counter(2), man_max(2), rot_max
      real p(3, 3), a(3, 3, 3, 2), z, xvel, yvel, zvel, chkx, chkz
      real phox(10), phoy(10), phoz(10), phvel(3, 10), dt, dt3
      real seed, c(3, 3), dr(3, 3), heading(3, 2), rot(2), vel(2)
      real b(3, 3), xscale, zscale, rscale, r(3, 3), stpnt(3, 40)
      real exp_vel(3, 3, 2), exp_dr(3, 3, 3, 2), mhd(3, 2), bhd(3, 2)
      real drot(2), difclt, ang(2, 2), ang_inc(2, 2), ang_mm(2, 2)
      real q(3, 3)
      double precision elapsed, duration, turn
      logical photon(10), hit_photon, hit_pod, hit_wing, scored, hit
      logical fire, shoot, struck, moved, explode(2), event, inside
      logical refresh, flag, exit(2), entrance(2), first, new(2)
      logical add, backup(2), distal
      character key*1, path*80
      external rand, inside
      common / phot$/ phox, phoy, phoz, phvel, photon
      common / star$/ star, stpnt
      save xscale, zscale, rscale
      data xscale, zscale, rscale / 2 * 0.04, 4.0e-4/
c
c    Before proceeding perhaps a note on how this routine works is in
c    order.  The action here is largely a farce, i.e. the stars in
c    the background and the movement of the enemy ships are only
c    casually related.  The routine operates by moving tie-fighters
c    around in the player ship's reference frame, and moving the
c    stars in a global frame.  Thus while the stars move about madly,
c    making it appear that the tie-fighter is darting about, it really
c    isn't.  The only exception to this is when the game rotates
c    into a new action sequence, then, at least for a while, the 
c    reference frames are linked.
c
c    initialize player placement
c
      turn_counter       = 0
      action_counter     = 0
      action_max         = 100
      explode_counter(1) = 0
      explode_counter(2) = 0
      num_photons        = 0
      rot_counter        = 0
      rot_max            = 40
      inc                = 2
      whosht             = 1
      struck     = .false.
      fire       = .false.
      explode(1) = .false.
      explode(2) = .false.
      new(1)     = .false.
      new(2)     = .false.
      refresh    = .false.
      add        = .false.
      scored     = .false.
      distal     = .true.
      since(1)   = 0
      since(2)   = 0
      position(1) = 400
      position(2) = 425
      limit       = min (wave / 3 + 2, 6)
      call gpr_$set_cursor_position (position, status)         
      if (wave .lt. 12) then
        difclt = 1.0 + (wave - 1) * 0.1
        shoot_inc = 4
      else if (wave .lt. 16) then
        difclt = 2.1
        shoot_inc = 3
      else
        difclt = 2.3
        shoot_inc = 2
      end if
      xwvel = 15.0 * (1.0 + (difclt - 1.0) / 1.5)
c
c    initialize additional rotation matrix
c
      do 10 i = 1, 3
        do 20 j = 1, 3
          r(j, i) = 0.0
 20     continue
        r(i, i) = 1.0
 10   continue
c
c    zero out all object variables
c
      do 30 i = 1, 200
        object(i) = .false.
        seen(i) = .false.
        last(i) = .false.
        obx(i) = 0.0
        oby(i) = 0.0
        obz(i) = 0.0
 30   continue            
c
c    set up the initial tie-fighter run.  First we find a rotation, dr, 
c    to use to spin the tie-fighters into view.  
c           
      call stwar_view_dr (dr, seed)
c
c    rotate r through this rot_max times
c
      do 40 i = 1, rot_max
        call stwar_matrix_multiply (dr, r, c, 2)
        call stwar_matrix_sub (c, r)
 40   continue 
c
c    position the two tie-fighters
c
      entrance(1) = .true.
      first = .true.
      call stwar_start_man (1, man, man_max, ang, ang_inc, ang_mm, 
     &                      rot, drot, difclt, exit, entrance,
     &                      seed, bhd, mhd, man_counter, first,
     &                      backup)
      first = .false.
c
c    initialize stars
c
      do 50 i = 1, 40
        stpnt(1, i) = 28000.0 * rand(seed) - 14000.0
        stpnt(2, i) = 12000.0 
        stpnt(3, i) = 28000.0 * rand(seed) - 14000.0
 50   continue
c
c    start turn timer
c
      call time_$clock (timer)
      call cal_$float_clock (timer, elapsed)
c
c    Start of the move - shoot - update loop
c    Get the current cursor position and any key events
c
110   continue
      passes = 0
      call gpr_$inq_cursor (cursor_bitmap, cur_op, active, position,
     &                      origin , status)
120   continue
        if (passes .ge. 2) goto 130
          passes = passes + 1
          event = gpr_$cond_event_wait (event_type, key, position,
     &                                  status)
          if (event .and. event_type .eq. gpr_$buttons) then
            if (key .eq. 'a') then
              fire = .true.
            else if (key .eq. 'A') then
              fire = .false.
            else if (key .eq. 'b') then
              position(1) = 400
              position(2) = 425
              call gpr_$set_cursor_position (position, status)         
            else if (key .eq. 'c') then
              call pause (font)
            end if
          end if
        goto 120
130   continue
c
c    limit x and z positions and cursor location (no clipping)
c
      ix = position(1) - 400.0
      iz = position(2) - 425.0
      moved = .false.                               
      if (abs(ix) .gt. 305) then
        position(1) = 400 + sign(305, ix)
        moved = .true.
      end if
      if (abs(iz) .gt. 305) then
        position(2) = 425 + sign(305, iz)
        moved = .true.
      end if      
      if (moved) then
        call gpr_$set_cursor_position (position, status)
      end if                    
c
c    set up the base rotation matrix
c
      st = sin (rscale * (position(1) - 400))
      ct = cos (rscale * (position(1) - 400))
      sp = sin (0.25 * rscale * (position(2) - 425))
      cp = cos (0.25 * rscale * (position(2) - 425))
      b(1, 1) = ct
      b(2, 1) = -sp * st
      b(3, 1) = -cp * st
      b(1, 2) = 0.0
      b(2, 2) = cp
      b(3, 2) = -sp
      b(1, 3) = st
      b(2, 3) = sp * ct
      b(3, 3) = cp * ct
c
c    update the additional rotation matrix
c
      call stwar_matrix_multiply (dr, r, c, 1)
      call stwar_matrix_sub (c, r)
c                                t
c    rotate the star points by dr  
c
      xt = dr(2, 1)
      zt = dr(2, 3)
      if (xt .lt. 0.0) then
        sx = 1.0
      else
        sx =-1.0
      end if
      if (zt .lt. 0.0) then
        sz = 1.0
      else
        sz =-1.0
      end if
      rnorm = max (sqrt (xt**2 + zt**2), 1.0e-3)
      crit = abs(xt / rnorm)
      do 160 i = 1, 40
        xt = dr(1, 1) * stpnt(1, i) + dr(2, 1) * stpnt(2, i) + 
     &       dr(3, 1) * stpnt(3, i) 
        yt = dr(1, 2) * stpnt(1, i) + dr(2, 2) * stpnt(2, i) + 
     &       dr(3, 2) * stpnt(3, i) 
        zt = dr(1, 3) * stpnt(1, i) + dr(2, 3) * stpnt(2, i) + 
     &       dr(3, 3) * stpnt(3, i)             
        if (yt .gt. 5000) then
          chkx = abs (xt / yt)
          chkz = abs (zt / yt)
          if (chkx .gt. 1.4 .or. chkz .gt. 1.4) then
            if (rand(seed) .le. crit) then
              l = 1
              side = sx
            else
              l = 3
              side = sz
            end if
            stpnt(1, i) = 28000.0 * rand(seed) - 14000.0
            stpnt(2, i) = 12000.0
            stpnt(3, i) = 28000.0 * rand(seed) - 14000.0
            stpnt(l, i) = 14000.0 * side * (1.0 - 0.4 * rand(seed))
          else
            stpnt(1, i) = xt
            stpnt(2, i) = yt
            stpnt(3, i) = zt
          end if
        else
          if (rand(seed) .le. crit) then
            l = 1
            side = sx
          else
            l = 3
            side = sz
          end if
          stpnt(1, i) = 28000.0 * rand(seed) - 14000.0
          stpnt(2, i) = 12000.0 
          stpnt(3, i) = 28000.0 * rand(seed) - 14000.0
          stpnt(l, i) = 14000.0 * side * (1.0 - 0.2 * rand(seed))
        end if
160   continue
c
c    form the global player rotation matrix P
c
      call stwar_matrix_multiply (r, b, p, 1)
c
c    form the local player rotation matrix P
c
      if (rot_counter .lt. rot_max) then
        call stwar_matrix_sub  (p, q)
      else if (rot_counter .gt. rot_max) then
        call stwar_matrix_sub  (b, q)
      else
        call stwar_maintain_dr (dr, distal, seed)
        call stwar_matrix_sub  (b, q)
        distal = .false.
      end if
c
c    rotate the stars by the base rotation
c
      do 200 i = 1, 40
        star(1, i) = b(1, 1) * stpnt(1, i) + b(2, 1) * stpnt(2, i) + 
     &               b(3, 1) * stpnt(3, i)
        star(2, i) = b(2, 2) * stpnt(2, i) + b(3, 2) * stpnt(3, i)
        star(3, i) = b(1, 3) * stpnt(1, i) + b(2, 3) * stpnt(2, i) + 
     &               b(3, 3) * stpnt(3, i)         
200   continue
c
c    propagate tie-fighters
c
      do 210 i = 1, 2
        j = (i - 1) * 20 + 1
        if (entrance(i) .or. exit(i) .or. new(i)) then
          call stwar_start_man (i, man, man_max, ang, ang_inc, ang_mm, 
     &                          rot, drot, difclt, exit, entrance,
     &                          seed, bhd, mhd, man_counter, first,
     &                          backup)
          new(i) = .false.
        end if
        if (object(j)) then
          if (.not. explode(i)) then
            call stwar_move_tfight (i, man, man_counter, man_max,
     &                              ang, ang_inc, ang_mm, vel, rot, 
     &                              drot, bhd, heading, mhd, xwvel, 
     &                              new, difclt, backup)
            call stwar_calc_a (a, i, heading, rot)
            call stwar_matrix_sub (a(1, 1, 1, i), a(1, 1, 2, i))
            call stwar_matrix_sub (a(1, 1, 1, i), a(1, 1, 3, i))
            obx(j) = obx(j) + vel(i) * heading(1, i) * dt
            oby(j) = oby(j) + vel(i) * heading(2, i) * dt - xwvel * dt
            obz(j) = obz(j) + vel(i) * heading(3, i) * dt
            l = j + 1
            obx(l) = -30.0 * a(1, 1, 2, i) + obx(j)
            oby(l) = -30.0 * a(2, 1, 2, i) + oby(j)
            obz(l) = -30.0 * a(3, 1, 2, i) + obz(j)
            l = j + 2
            obx(l) =  30.0 * a(1, 1, 3, i) + obx(j)
            oby(l) =  30.0 * a(2, 1, 3, i) + oby(j)
            obz(l) =  30.0 * a(3, 1, 3, i) + obz(j)
            prx = obx(j) * q(1, 1) + oby(j) * q(2, 1) + obz(j) * q(3, 1) 
            pry = obx(j) * q(1, 2) + oby(j) * q(2, 2) + obz(j) * q(3, 2) 
            prz = obx(j) * q(1, 3) + oby(j) * q(2, 3) + obz(j) * q(3, 3) 
            if (pry .gt. 10.0) then
              chkx = abs(prx / pry)
              chkz = abs(prz / pry)
              if (chkx .lt. 1.5 .and. chkz .lt. 1.5) then
                seen(j)     = .true.
                seen(j + 1) = .true.
                seen(j + 2) = .true.
              else
                seen(j)     = .false.
                seen(j + 1) = .false.
                seen(j + 2) = .false.
              end if
            else
              seen(j)     = .false.
              seen(j + 1) = .false.
              seen(j + 2) = .false.
            end if
          else
            explode_counter(i) = explode_counter(i) + 1
            if (explode_counter(i) .gt. 20) then
              explode(i)     = .false.
              object(j)      = .false.
              object(j + 3)  = .false.
              seen(j)        = .false.
              seen(j + 1)    = .false.
              seen(j + 2)    = .false.
            else 
              do 220 k = 1, 3
                l = j + k - 1
                call stwar_matrix_multiply (exp_dr(1, 1, k, i), 
     &                                      a(1, 1, k, i), c, 1)
                call stwar_matrix_sub (c, a(1, 1, k, i))
                obx(l) = obx(l) + exp_vel(1, k, i) * dt
                oby(l) = oby(l) + exp_vel(2, k, i) * dt - xwvel * dt
                obz(l) = obz(l) + exp_vel(3, k, i) * dt
                prx = obx(l) * q(1, 1) + oby(l) * q(2, 1) + 
     &                obz(l) * q(3, 1) 
                pry = obx(l) * q(1, 2) + oby(l) * q(2, 2) + 
     &                obz(l) * q(3, 2) 
                prz = obx(l) * q(1, 3) + oby(l) * q(2, 3) + 
     &                obz(l) * q(3, 3) 
                if (pry .gt. 10.0) then
                  chkx = abs(prx / pry)
                  chkz = abs(prz / pry)
                  if (chkx .lt. 1.5 .and. chkz .lt. 1.5) then
                    seen(l) = .true.
                  else
                    seen(l) = .false.
                  end if
                else
                  seen(l) = .false.
                end if
220           continue
            end if          
          end if
        end if
210   continue
c
c    propagate photons and check for collisions
c
      num_col = 0
      do 250 i = 1, 10
        if (photon(i)) then
          hit = .false.
          pry = phox(i) * p(1, 2) + phoy(i) * p(2, 2) + 
     &          phoz(i) * p(3, 2) 
          if (pry .lt. 300.0) then
            dt3 = dt / 4.0
            l = 4
          else
            dt3 = dt
            l = 1
          end if
          do 260 j = 1, l
            phox(i) = phox(i) + phvel(1, i) * dt3
            phoy(i) = phoy(i) + phvel(2, i) * dt3
            phoz(i) = phoz(i) + phvel(3, i) * dt3
            prx = phox(i) * p(1, 1) + phoy(i) * p(2, 1) + 
     &            phoz(i) * p(3, 1) 
            pry = phox(i) * p(1, 2) + phoy(i) * p(2, 2) + 
     &            phoz(i) * p(3, 2) 
            prz = phox(i) * p(1, 3) + phoy(i) * p(2, 3) + 
     &            phoz(i) * p(3, 3) 
            if (pry .gt. 5.0) then
              chkx = abs(prx / pry)
              chkz = abs(prz / pry)
              if (chkx .gt. 1.0 .or. chkz .gt. 1.0) then
                photon(i) = .false.
              end if
            else
              photon(i) = .false.
            end if
            if (photon(i) .and. .not. hit) then
              if (pry .lt. 30.0) then
                num_col = num_col + 1
                col_obj(num_col) = i
                hit = .true.
              end if
            end if
260       continue
        end if
250   continue 
c
c    draw the new objects and x hairs
c
      call gpr_$set_clipping_active (.true., status)
      call stwar_draw_stars ()
      call stwar_draw_tfight (q, a, tf_center, tf_radius)
      call stwar_draw_photons (0.0, p, center, radius, refresh)      
      call stwar_draw_x_hairs (position)
      call stwar_draw_phasers (position, fire, inc, shoot)
      call gpr_$set_clipping_active (.false., status)
c
c    check to see if the player's fire hits anything
c
      dist = 9999999.0
      hit_photon = .false.
      hit_pod = .false.
      hit_wing = .false.
      which  = -1
      if (shoot) then
        do 300 i = 1, 10
          if (photon(i)) then
            range = (center(1, i) - position(1))**2 +
     &              (center(2, i) - position(2))**2
            if (range .le. radius(i)**2) then
              hit_photon = .true.
              if (phoy(i) .lt. dist) then
                dist = phoy(i)
                which = i
              end if          
            end if
          end if
300     continue
        do 310 i = 1, 2
          k = (i - 1) * 20 + 1
          if (seen(k)) then
            range = (tf_center(1, i) - position(1))**2 +
     &              (tf_center(2, i) - position(2))**2
            if (range .le. tf_radius(i)**2) then
              if (oby(k) .lt. dist) then
                hit_photon = .false.
                hit_pod = .true.
                hit_wing = .false.
                dist = oby(k)
                which = k
                index = i
              end if          
            end if
          end if
          do 320 j = 1, 2
            l = k + j
            if (seen(l)) then
              hit = inside (poly_x(1, l), poly_y(1, l), 6, 
     &                      position(1), position(2))
              if (hit .and. oby(l) .lt. dist) then
                hit_photon = .false.
                hit_pod = .false.
                hit_wing = .true.
                dist = oby(l)
                which = k               
                index = i
              end if
            end if
320       continue
310     continue  
      end if
      if (hit_photon) then
        k = num_col
        do 330 i = 1, k
          if (which .eq. col_obj(i)) then
            num_col = num_col - 1
          end if
330     continue
        score_inc = 35
        score     = score + score_inc
        scored    = .true.
        photon(which) = .false.
      else if (hit_pod .or. hit_wing) then
        if (.not. object(which + 3)) then
          object(which + 3) = .true.
          explode(index)    = .true.
          explode_counter(index) = 0
          call stwar_explosion_dr (exp_dr, heading, vel, exp_vel, 
     &                             which, seed)
          score_inc = 500
          score     = score + score_inc
          scored    = .true.
        end if
      end if
c
c    update the score
c
      call stwar_update_score (score, score_inc, scored)
c
c    evaluate collisions
c
      if (num_col .gt. 0 .and. (.not. struck)) then
        struck = .true.
        counter = 0
        shields = shields - 1
        if (shields .lt. 0) then
          call stwar_scores (score, font)
        end if
        call stwar_update_shields (shields, font)
        call gpr_$set_color_map (15, int2(1), 2763306, status)
      end if
      counter = counter + 1
      if (struck .and. counter .gt. 10) then
        struck = .false.
        call gpr_$set_color_map (15, int2(1), 0, status)
      end if
c
c    check to see if tf's have been gone too long from the screen
c
      if (rot_counter .gt. rot_max) then
        do 215 i = 1, 2
          index = (i - 1) * 20 + 1
          if (.not. seen(index) .and. .not. explode(i)) then
            since(i) = since(i) + 1
          else
            since(i) = 0
          end if                   
215     continue
c
c     if neither tf is doing anything, set up a new attack
c
        if (since(1) .gt. 15 .and. since(2) .gt. 15) then
          if (turn_counter .gt. 1000) then
            return
          end if
          if (num_photons .eq. 0) then
            object(1) = .false.
            object(21) = .false.
            action_counter = 0
            action_max = rand(seed) * 500 + 200
            entrance(1) = .true.
            if (rand(seed) .gt. 1.0 / (2.0 * difclt)) then
              add = .true.
              add_delay = rand(seed) * 100.0 / difclt
            else
              add = .false.
            end if
            rot_max = rand(seed) * 40 + 20
            rot_counter = 0
            call stwar_view_dr (dr, seed)
            do 217 i = 1, 3
              do 218 j = 1, 3
                r(i, j) = 0.0
218           continue
              r(i, i) = 1.0
217         continue
            do 216 i = 1, rot_max
              call stwar_matrix_multiply (dr, r, c, 2)
              call stwar_matrix_sub (c, r)
216         continue 
          end if
        end if
      else 
        since(1) = 0
        since(2) = 0
      end if
      if (add) then
        if (action_counter .gt. add_delay) then
          if (.not. object(21) .and. .not. explode(2)) then
            entrance(2) = .true.
          else if (since(2) .gt. 15) then
            entrance(2) = .true.
          end if
        end if
      end if
      if (action_counter .gt. action_max) then
        exit(1) = .true.
        exit(2) = .true.
        action_counter = -100
      end if                           
c
c    have tie-fighters shoot if possible
c
      num_photons = 0
      do 500 i = 1, 10
        if (photon(i)) then
          num_photons = num_photons + 1
        end if
500   continue
      if (num_photons .lt. limit .and. 
     &    mod(turn_counter, shoot_inc) .eq. 0 .and. 
     &    rot_counter .ge. rot_max / difclt) then
        whosht = whosht + 1
        if (whosht .gt. 2) whosht = 1
        i = whosht
        j = (i - 1) * 20 + 1
        if (seen(j) .and. .not. explode(i)) then
          rnorm = sqrt(obx(j)**2 + oby(j)**2 + obz(j)**2)
          d1 = obx(j) / rnorm
          d2 = oby(j) / rnorm
          d3 = obz(j) / rnorm
          dot = abs(d1 * heading(1, i) + d2 * heading(2, i) + 
     &              d3 * heading(3, i))
          if (dot .gt. 0.8 .and. oby(j) .lt. 3000.0) then
            call stwar_find_free (l)
            pv2 = -xwvel - 15.0
            rnum = -oby(j) / pv2 + 4.5 * (rand(seed) - 0.5)
            if (rnum .gt. 5.0) then
              pv1 = -obx(j) / rnum
              pv3 = -obz(j) / rnum    
              ph1 = obx(j)
              ph2 = oby(j)
              ph3 = obz(j)
              photon(l) = .true.
              num_photons = num_photons + 1
c
c    rotate into global coordinates.  this is complicated by the
c    fact that photons move in the reference frame of the stars,
c    which is generally not the same as the tie-fighters.  thus
c    we rotate the both the initial position and velocity
c    vectors.
c
              if (rot_counter .ge. rot_max) then
                phvel(1, l) = pv1 * r(1, 1) + pv2 * r(1, 2) + 
     &                        pv3 * r(1, 3) 
                phvel(2, l) = pv1 * r(2, 1) + pv2 * r(2, 2) + 
     &                        pv3 * r(2, 3) 
                phvel(3, l) = pv1 * r(3, 1) + pv2 * r(3, 2) + 
     &                        pv3 * r(3, 3) 
                phox(l) = ph1 * r(1, 1) + ph2 * r(1, 2) + 
     &                    ph3 * r(1, 3) 
                phoy(l) = ph1 * r(2, 1) + ph2 * r(2, 2) + 
     &                    ph3 * r(2, 3) 
                phoz(l) = ph1 * r(3, 1) + ph2 * r(3, 2) + 
     &                    ph3 * r(3, 3) 
              else
                phvel(1, l) = pv1
                phvel(2, l) = pv2
                phvel(3, l) = pv3
                phox(l) = ph1
                phoy(l) = ph2
                phoz(l) = ph3
              end if
            end if
          end if
        e nd if
      end if      
c
c    update all the stupid counters
c
      turn_counter   = turn_counter + 1
      action_counter = action_counter + 1
      man_counter(1) = man_counter(1) + 1
      man_counter(2) = man_counter(2) + 1
      rot_counter    = rot_counter + 1
c
c    repeat the sequence after timing the turn. the step size
c    dt can be greater than one, allowing the game to keep pace
c    when something slows the node down (such as writing to disk).
c
340   continue
      call time_$clock (timer)
      call cal_$float_clock (timer, turn)
      duration = turn - elapsed
      if (duration .gt. 0.06) then
        dt = duration / 0.06
        dt = min (dt, 1.50)
        elapsed = turn
        goto 110
      end if
      goto 340
      end






      subroutine stwar_draw_tfight (p, a, center, radius)
c
c     STWAR_DRAW_TFIGHT draws the empire's tie fighters.
c
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
% include 'stwar_info.ins.ftn'
c
      integer*2 hex_x(6, 8), hex_y(6, 8), hex_z(6, 8), connect(4, 6)
      integer*2 square_x(4, 6), square_y(4, 6), square_z(4, 6)
      integer*2 hlist(10, 3), slist(10, 3), snum(3)
      integer*2 wing_x, wing_y(6), wing_z(6), strut_x(8, 2), strut_y(8)
      integer*2 strut_z(8), opp(4)
      integer*4 status, pod_index, l_index, r_index, spoke(6)
      integer*4 i, j, k, l, m, index, h_index, s_index
      integer*4 center(2, 2), radius(2)
      real hnorm(3, 8), snorm(3, 6), pva(3), a(3, 3, 3, 2)
      real obn(3), dot, b(3, 3), x, y, z, prx, pry, prz, dx, dy, dz
      real wnorm(2), wx, p(3, 3)
      save hex_x, hex_y, hex_z, square_x, square_y, square_z, connect
      save hnorm, snorm, hlist, snum, slist, spoke, opp
      save wing_x, wing_y, wing_z, wnorm, strut_x, strut_y, strut_z
      data connect / 1, 2, 3, 4, 1, 3, 5, 7, 2, 4, 6, 8, 1, 2, 5, 6, 3, 
     &               4, 7, 8, 5, 6, 7, 8/
      data opp / 8, 7, 6, 5/
      data hex_x / 0, -8, -16, -16, -8, 0, 0, 8, 16, 16, 8, 0,
     &             0, -8, -16, -16, -8, 0, 0, 8, 16, 16, 8, 0,
     &             0, -8, -16, -16, -8, 0, 0, 8, 16, 16, 8, 0,
     &             0, -8, -16, -16, -8, 0, 0, 8, 16, 16, 8, 0/
      data hex_y / -8, 0, 0, -8, -16, -16, -8, 0, 0, -8, -16, -16, 
     &             -8, 0, 0, -8, -16, -16, -8, 0, 0, -8, -16, -16, 
     &              8, 0, 0, 8, 16, 16, 8, 0, 0, 8, 16, 16, 
     &              8, 0, 0, 8, 16, 16, 8, 0, 0, 8, 16, 16/
      data hex_z / 16, 16, 8, 0, 0, 8, 16, 16, 8, 0, 0, 8, 
     &            -16, -16, -8, 0, 0, -8, -16, -16, -8, 0, 0, -8,  
     &             16, 16, 8, 0, 0, 8, 16, 16, 8, 0, 0, 8, 
     &            -16, -16, -8, 0, 0, -8, -16, -16, -8, 0, 0, -8/
      data square_x / 0, -8, 0, 8, -16, -16, -16, -16, 16, 16, 16, 16,
     &                0, -8, 0, 8, 0, -8, 0, 8, 0, -8, 0, 8/
      data square_y / -16, -16, -16, -16, 0, 8, 0, -8, 0, 8, 0, -8,
     &                 8, 0, -8, 0, 8, 0, -8, 0, 16, 16, 16, 16/
      data square_z / 8, 0, -8, 0, 8, 0, -8, 0, 8, 0, -8, 0,
     &                16, 16, 16, 16, -16, -16, -16, -16, 8, 0, -8, 0/
      data wing_x  / 10/
      data wing_y  / 32, 19, -19, -32, -19, 19/
      data wing_z  /  0, 50, 50, 0, -50, -50/
      data spoke / 1, 4, 2, 5, 3, 6/
      data strut_x /-10, 14, -10, 14, -10, 14, -10, 14, 10, -14, 10, 
     &              -14, 10, -14, 10, -14/
      data strut_y / 0, 0, 2, 8, -2, -8, 0, 0/
      data strut_z / 2, 8, 0, 0, 0, 0, -2, -8/
      data hnorm / -0.5, -0.5, 0.707107, 0.5, -0.5, 0.707107, -0.5, 
     &             -0.5, -0.707107, 0.5, -0.5, -0.707107, -0.5, 0.5, 
     &              0.707107, 0.5, 0.5, 0.707107, -0.5, 0.5, -0.707107, 
     &              0.5, 0.5, -0.707107/                       
      data snorm / 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 
     &             0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0/
      data wnorm / -1.0, 1.0/
c
c    what the number system means. in an effort to conserve on 
c    memory, the tie fighter routines utilize the same commons
c    as the towers and tunnel routines.  The two tie-fighters are
c    numbered as:
c
c      obj           seen            type           poly          mult
c
c  1.  pod           seen            1, 2            -             -
c  2.  l. wing       seen             -             wing         strut
c  3.  r. wing       seen             -             wing         strut
c  4.  explode        -               -              -             -
c  5.  l. spoke       -               -              -           spoke
c  6.  r. spoke       -               -              -           spoke
c  7.                 -               -              -             -
c  |   squares        -               -            square          -
c 12.                 -               -              -             -   
c 13.                 -               -              -             -
c  |    hexes         -               -             hex            -
c 20.                                                               
c 
c    the second fighter starts at 21.
c
c
c    loop over tie fighters
c
      do 10 i = 1, 2
        index   = (i - 1) * 20 + 1
        s_index = index + 5
        h_index = index + 11
c
c    erase the tie fighter if seen last turn
c
        call gpr_$set_draw_value (15, status)
        if (last(index)) then
          do 20 j = 1, 4
            l = hlist(j, i)
            call gpr_$move (poly_x(6, l), poly_y(6, l), status)
            call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                          status)
 20       continue                                                   
          do 30 j = 1, snum(i)
            l = slist(j, i)
            call gpr_$move (poly_x(4, l), poly_y(4, l), status)
            call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(4), 
     &                          status)
 30       continue                                                   
        end if
        l = index + 1
        if (last(l)) then
          call gpr_$move (poly_x(6, l), poly_y(6, l), status)
          call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                        status)
          call gpr_$multiline (mult_x(1, l), mult_y(1, l), int2(8), 
     &                         status)
          j = index + 4
          if (object(j)) then
            call gpr_$multiline (mult_x(1, j), mult_y(1, j), 
     &                           int2(6), status)
          end if
        end if
        l = index + 2
        if (last(l)) then
          call gpr_$move (poly_x(6, l), poly_y(6, l), status)
          call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                        status)
          call gpr_$multiline (mult_x(1, l), mult_y(1, l), int2(8), 
     &                         status)
          j = index + 5
          if (object(j)) then
            call gpr_$multiline (mult_x(1, j), mult_y(1, j), 
     &                           int2(6), status)
          end if
        end if
c
c    if seen determine which faces of the main pod are observed
c    the pod rotation matrix is a(-, -, 1, i)
c                                                              
        if (seen(index)) then
          snum(i) = 0
c
c    calculate the player's view axis, i.e. a unit line segment 
c    oriented along the player's line of sight
c
          pva(1) = obx(index)
          pva(2) = oby(index)
          pva(3) = obz(index)
          obn(1) = a(1, 1, 1, i) * pva(1) + a(2, 1, 1, i) * pva(2) +
     &             a(3, 1, 1, i) * pva(3) 
          obn(2) = a(1, 2, 1, i) * pva(1) + a(2, 2, 1, i) * pva(2) +
     &             a(3, 2, 1, i) * pva(3) 
          obn(3) = a(1, 3, 1, i) * pva(1) + a(2, 3, 1, i) * pva(2) +
     &             a(3, 3, 1, i) * pva(3) 
c
c    perform an inner product over the play view axis and the normals
c    to the pod faces, if negative (implying the face is oriented
c    towards the player) then add the face to the list of those
c    needing to be drawn
c
          do 40 j = 1, 4
            dot = obn(1) * hnorm(1, j) + obn(2) * hnorm(2, j) + 
     &            obn(3) * hnorm(3, j)
            if (dot .lt. 0.0) then
              object(h_index + j) = .true.
              object(h_index + opp(j)) = .false.
              hlist(j, i) = h_index + j
            else 
              object(h_index + j) = .false.
              object(h_index + opp(j)) = .true.
              hlist(j, i) = h_index + opp(j)
            end if
 40       continue
          do 50 j = 1, 6
            dot = obn(1) * snorm(1, j) + obn(2) * snorm(2, j) + 
     &            obn(3) * snorm(3, j)
            if (dot .lt. 0.0) then
              l = 0
              m = h_index
              do 60 k = 1, 4
                if (object(m + connect(k, j))) l = l + 1
 60           continue
              if (l .ne. 4) then
                object(s_index + j) = .true.               
                snum(i) = snum(i) + 1
                slist(snum(i), i) = s_index + j
              end if 
            end if
 50       continue                         
c
c    we now know which pod faces must be drawn, we must project these
c    into screen coordinates, first we form the pod rotator.
c
c    perhaps a few words here might make this more obvious.
c    There are two ways of performing a rotation such as this.
c    The first, and slower (and the one I used in STREK) is to rotate
c    the viewed object to it's proper orientation, then rotate the
c    result into the player orientation (two sets of matrix 
c    multiplications).  The second way (used here and in BZONE) is
c    to rotate the player into the proper position to view the
c    object, simultaneously adjusting for his orientation.
c                                                        
          do 70 j = 1, 3
            do 80 k = 1, 3
              b(j, k) = 0.0
              do 90 l = 1, 3
                b(j, k) = b(j, k) + a(l, j, 1, i) * p(l, k)
 90           continue
 80         continue
 70       continue                              
c
c    we now rotate the observer so that he is in the correct position
c    to view the rotated pod
c
          x = -obx(index)
          y = -oby(index)
          z = -obz(index)
          dx = x * a(1, 1, 1, i) + y * a(2, 1, 1, i) + z * a(3, 1, 1, i)
          dy = x * a(1, 2, 1, i) + y * a(2, 2, 1, i) + z * a(3, 2, 1, i)
          dz = x * a(1, 3, 1, i) + y * a(2, 3, 1, i) + z * a(3, 3, 1, i)
c
c    now rotate into the observers frame and project to the screen
c    coordinates
c
          do 100 j = 1, 4
            m = hlist(j, i)
            l = m - h_index
            do 110 k = 1, 6
              x = hex_x(k, l) - dx
              y = hex_y(k, l) - dy
              z = hex_z(k, l) - dz
              prx = x * b(1, 1) + y * b(2, 1) + z * b(3, 1)
              pry = x * b(1, 2) + y * b(2, 2) + z * b(3, 2)
              prz = x * b(1, 3) + y * b(2, 3) + z * b(3, 3)
              pry = max(pry, 10.0)
              poly_x(k, m) = 400 + prx / pry * 350
              poly_y(k, m) = 425 - prz / pry * 350
110         continue               
100       continue          
          do 120 j = 1, snum(i)
            m = slist(j, i)
            l = m - s_index
            do 130 k = 1, 4
              x = square_x(k, l) - dx
              y = square_y(k, l) - dy
              z = square_z(k, l) - dz
              prx = x * b(1, 1) + y * b(2, 1) + z * b(3, 1)
              pry = x * b(1, 2) + y * b(2, 2) + z * b(3, 2)
              prz = x * b(1, 3) + y * b(2, 3) + z * b(3, 3)
              pry = max(pry, 10.0)
              poly_x(k, m) = 400 + prx / pry * 350
              poly_y(k, m) = 425 - prz / pry * 350
130         continue               
120       continue          
          prx = -dx * b(1, 1) - dy * b(2, 1) - dz * b(3, 1)
          pry = -dx * b(1, 2) - dy * b(2, 2) - dz * b(3, 2)
          prz = -dx * b(1, 3) - dy * b(2, 3) - dz * b(3, 3)
          pry = max(pry, 10.0)
          center(1, i) = 400 + prx / pry * 350
          center(2, i) = 425 - prz / pry * 350
          radius(i) = 16.0 / pry * 350
          last(index) = .true.
        else
          last(index) = .false. 
        end if                                                 
c
c    now work on the wings and struts, since this is similar to
c    the previous (a little more straightforward perhaps) I wont comment
c    as much. first check which side of the wings are facing the player
c                                                                      
        do 140 l = 1, 2
          if (seen(index + l)) then
            m = l + 1
            obn(1) = a(1, 1, m, i) * wnorm(l)
            obn(2) = a(2, 1, m, i) * wnorm(l)
            obn(3) = a(3, 1, m, i) * wnorm(l)
            j = index + l
            dot = obn(1) * obx(j) + obn(2) * oby(j) + obn(3) * obz(j) 
            if (dot .lt. 0.0) then
              object(index + l + 3) = .true.
            else
              object(index + l + 3) = .false.
            end if
            if (object(index + 3)) then
              do 150 j = 1, 3
                do 160 k = 1, 3
                  b(j, k) = 0.0
                  do 170 n = 1, 3
                    b(j, k) = b(j, k) + a(n, j, m, i) * p(n, k)
170               continue
160             continue
150           continue                              
            end if
c
c    we now rotate the observor so that he is in the correct position
c    to view the rotated wings
c
            x = -obx(index + l)
            y = -oby(index + l)
            z = -obz(index + l)
            dx = x * a(1, 1, m, i) + y * a(2, 1, m, i) + 
     &           z * a(3, 1, m, i)
            dy = x * a(1, 2, m, i) + y * a(2, 2, m, i) + 
     &           z * a(3, 2, m, i)
            dz = x * a(1, 3, m, i) + y * a(2, 3, m, i) + 
     &           z * a(3, 3, m, i)
c
c    now rotate into the observers frame and project to the screen
c    coordinates
c
            wx = wing_x
            if (l .eq. 1) wx = -wx
            m = index + l
            do 180 k = 1, 6
              x = wx - dx
              y = wing_y(k) - dy
              z = wing_z(k) - dz
              prx = x * b(1, 1) + y * b(2, 1) + z * b(3, 1)
              pry = x * b(1, 2) + y * b(2, 2) + z * b(3, 2)
              prz = x * b(1, 3) + y * b(2, 3) + z * b(3, 3)
              pry = max(pry, 10.0)
              poly_x(k, m) = 400 + prx / pry * 350
              poly_y(k, m) = 425 - prz / pry * 350
180         continue               
c
c    create the multiline array to draw spokes if seen
c
            k = l + 3 + index
            if (object(k)) then
              do 190 j = 1, 6
                mult_x(j, k) = poly_x(spoke(j), m)
                mult_y(j, k) = poly_y(spoke(j), m)
190           continue
            end if
c
c    now add the struts
c
            j = l + index
            do 200 k = 1, 8
              x = strut_x(k, l) - dx
              y = strut_y(k) - dy
              z = strut_z(k) - dz
              prx = x * b(1, 1) + y * b(2, 1) + z * b(3, 1)
              pry = x * b(1, 2) + y * b(2, 2) + z * b(3, 2)
              prz = x * b(1, 3) + y * b(2, 3) + z * b(3, 3)
              pry = max(pry, 10.0)
              mult_x(k, j) = 400 + prx / pry * 350
              mult_y(k, j) = 425 - prz / pry * 350
200         continue               
            last(index + l) = .true.
          else
            last(index + l) = .false. 
          end if                                                 
140     continue       
c
c    everything is rotated now, so display it
c
        if (object(index + 3)) then
          call gpr_$set_draw_value (14, status)
        else
          call gpr_$set_draw_value (8, status)
        end if
        if (last(index)) then
          do 210 j = 1, 4
            l = hlist(j, i)
            call gpr_$move (poly_x(6, l), poly_y(6, l), status)
            call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                          status)
210       continue                                                   
          do 220 j = 1, snum(i)
            l = slist(j, i)
            call gpr_$move (poly_x(4, l), poly_y(4, l), status)
            call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(4), 
     &                          status)
220       continue                                                   
        end if
        l = index + 1
        if (last(l)) then
          call gpr_$move (poly_x(6, l), poly_y(6, l), status)
          call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                        status)
          call gpr_$multiline (mult_x(1, l), mult_y(1, l), int2(8), 
     &                         status)
          j = l + 3
          if (object(j)) then
            call gpr_$multiline (mult_x(1, j), mult_y(1, j), 
     &                           int2(6), status)
          end if
        end if
        l = index + 2
        if (last(l)) then
          call gpr_$move (poly_x(6, l), poly_y(6, l), status)
          call gpr_$polyline (poly_x(1, l), poly_y(1, l), int2(6), 
     &                        status)
          call gpr_$multiline (mult_x(1, l), mult_y(1, l), int2(8), 
     &                         status)
          j = l + 3
          if (object(j)) then
            call gpr_$multiline (mult_x(1, j), mult_y(1, j), 
     &                           int2(6), status)
          end if
        end if
10    continue
      return
      end





      subroutine stwar_draw_stars ()
c
c     STWAR_DRAW_STARS refreshes the stars in the tie-fighter phase.
c                     
% include '/sys/ins/base.ins.ftn'
% include '/sys/ins/gpr.ins.ftn'
% include 'stwar_poly.ins.ftn'
c
      integer*4 star(3, 40), status
      real prx, pry, prz, stpnt(3, 40)
      common /star$/ star, stpnt
c
c    draw the new dots
c
      call gpr_$set_draw_value (15, status) 
      do 10 i = 1, 40
        k = i + 50
        call gpr_$move (poly_x(1, k), poly_y(1, k), status)
        call gpr_$line (poly_x(1, k), poly_y(1, k), status)
 10   continue
      call gpr_$set_draw_value (6, status)
      do 20 i = 1, 40
        k = i + 50
        prx = star(1, i)
        pry = star(2, i)
        prz = star(3, i)
        poly_x(1, k) = 400 + prx / pry * 350
        poly_y(1, k) = 425 - prz / pry * 350
        call gpr_$move (poly_x(1, k), poly_y(1, k), status)
        call gpr_$line (poly_x(1, k), poly_y(1, k), status)
 20   continue
      return
      end






      subroutine stwar_view_dr (dr, seed)
c
c     STWAR_VIEW_DR is yet another rotation, this is used to bring 
c     tie-fighters and death stars into view.
c
      real dr(3, 3), seed, rand
      external rand
      p1 = rand(seed) + 0.1
      p2 = rand(seed) + 0.1
      if (rand(seed) .lt. 0.5) p1 = -p1
      if (rand(seed) .lt. 0.5) p2 = -p2
      rnorm = sqrt((p1**2 + p2**2) / 0.0004)
      p1 = p1 / rnorm     
      p2 = p2 / rnorm     
      c1 = cos(p1)
      s1 = sin(p1)
      c2 = cos(p2)
      s2 = sin(p2)
      dr(1, 1) =  c1
      dr(2, 1) = -s1 * c2
      dr(3, 1) =  s1 * s2
      dr(1, 2) =  s1
      dr(2, 2) =  c1 * c2
      dr(3, 2) = -c1 * s2
      dr(1, 3) =  0.0
      dr(2, 3) =  s2
      dr(3, 3) =  c2
      return
      end





      subroutine stwar_explosion_dr (dr, heading, vel, exp_vel, index, 
     &                               seed)
c
c     STWAR_EXPLOSION_DR calculates an arbitrary differential rotation 
c     matrix using the rand function and the three Euler angle rotation 
c     matrix and sets up a inertia conserving explosion.
c
      integer*4 index
      real dr(3, 3, 3, 2), seed, rand, phi, theta, psi
      real heading(3, 2), vel(2), exp_vel(3, 3, 2)
      external rand
c
c    create random Euler angles (0-10 degrees)
c
      j = 1
      if (index .eq. 21) j = 2
      do 10 i = 1, 3
        phi = 0.33 * (rand(seed))
        if (rand(seed) .gt. 0.5) phi = -phi
        theta = 0.33 * (rand(seed))
        if (rand(seed) .gt. 0.5) theta = -theta
        psi = 0.33 * (rand(seed))
        if (rand(seed) .gt. 0.5) psi = -psi
        c1 = cos(phi)
        s1 = sin(phi)
        c2 = cos(theta)
        s2 = sin(theta)
        c3 = cos(psi) 
        s3 = sin(psi)
        dr(1, 1, i, j) =  c3 * c1 - c2 * s1 * s3
        dr(2, 1, i, j) = -s3 * c1 - c2 * s1 * c3
        dr(3, 1, i, j) =  s2 * s1
        dr(1, 2, i, j) =  c3 * s1 + c2 * c1 * s3
        dr(2, 2, i, j) = -s3 * s1 + c2 * c1 * c3
        dr(3, 2, i, j) = -s2 * c1
        dr(1, 3, i, j) =  s3 * s2
        dr(2, 3, i, j) =  c3 * s2
        dr(3, 3, i, j) =  c2
 10   continue
      do 20 i = 1, 3
        exp_vel(1, i, j) = heading(1, j) * vel(j) + 
     &                     10.0 * (rand(seed) - 0.5)
        exp_vel(2, i, j) = heading(2, j) * vel(j) + 
     &                     10.0 * (rand(seed) - 0.5)
        exp_vel(3, i, j) = heading(3, j) * vel(j) + 
     &                     10.0 * (rand(seed) - 0.5)
 20   continue
      return
      end






      subroutine stwar_maintain_dr (dr, distal, seed)
c
c     STWAR_MAINTAIN_DR is yet another rotation matrix generator, this 
c     one produces a dr matrix for the tfight phase.
c
      real dr(3, 3), seed, rand, theta, w1(3, 3), w2(3, 3)
      logical distal
c
c    generate a spin and a rotation matrix
c
      if (distal) then
        const1 = 0.000015
        const2 = 0.0012
      else
        const1 = 0.00009
        const2 = 0.0075
      end if
      p1 = rand(seed) + 0.01
      p2 = rand(seed) + 0.01
      if (rand(seed) .lt. 0.5) p1 = -p1
      if (rand(seed) .lt. 0.5) p2 = -p2
      rnorm = sqrt((p1**2 + p2**2) / const1)
      p1 = p1 / rnorm     
      p2 = p2 / rnorm     
      c1 = cos(p1)
      s1 = sin(p1)
      c2 = cos(p2)
      s2 = sin(p2)
      w1(1, 1) =  c1
      w1(2, 1) = -s1 * c2
      w1(3, 1) =  s1 * s2
      w1(1, 2) =  s1
      w1(2, 2) =  c1 * c2
      w1(3, 2) = -c1 * s2
      w1(1, 3) =  0.0
      w1(2, 3) =  s2
      w1(3, 3) =  c2
      theta = const2 * (rand(seed))
      if (rand(seed) .gt. 0.5) theta = -theta
      c4 = cos(theta)
      s4 = sin(theta)
      w2(1, 1) = c4
      w2(2, 1) = 0.0
      w2(3, 1) = -s4
      w2(1, 2) = 0.0
      w2(2, 2) = 1.0
      w2(3, 2) = 0.0
      w2(1, 3) = s4
      w2(2, 3) = 0.0
      w2(3, 3) = c4
      call stwar_matrix_multiply (w2, w1, dr, 1)
      return
      end






      subroutine stwar_calc_a (a, i, h, rot)
c
c     STWAR_TFIGHT_CALC_A calculates and stuffs the tie-fighter rotation
c     matrix A, given a heading and rotation about the spin axis.
c
      integer*4 i
      real a(3, 3, 3, 2), h(3, 2), rot(2), b(3, 3), r(3, 3), h1
c
c    calculate a rotation to orient tf along heading
c
      h1 = sqrt(h(1, i)**2 + h(2, i)**2)
      if (h1 .gt. 0.0003) then
        b(1, 1) =  h(2, i) / h1
        b(2, 1) = -h(1, i) / h1
        b(3, 1) =  0.0
        b(1, 2) =  h(1, i)
        b(2, 2) =  h(2, i)
        b(3, 2) =  h(3, i)
        b(1, 3) = -h(1, i) * h(3, i) / h1
        b(2, 3) = -h(2, i) * h(3, i) / h1
        b(3, 3) =  h1
      else
        b(1, 1) = 1.0
        b(2, 1) = 0.0
        b(3, 1) = 0.0
        b(1, 2) = 0.0
        b(2, 2) = 0.0
        b(3, 2) = h(3, i)
        b(1, 3) = 0.0
        b(2, 3) = -h(3, i)
        b(3, 3) = 0.0
      end if
c
c    calculate rotation along propagation axis
c
      phi = rot(i)
      cp = cos(phi)
      sp = sin(phi)
      r(1, 1) = cp
      r(2, 1) = 0.0
      r(3, 1) = -sp
      r(1, 2) = 0.0
      r(2, 2) = 1.0
      r(3, 2) = 0.0
      r(1, 3) = sp
      r(2, 3) = 0.0
      r(3, 3) = cp
c
c    combine the two rotations into a
c
      call stwar_matrix_multiply (r, b, a(1, 1, 1, i), 1)
      return
      end






      subroutine stwar_start_man (i, man, man_max, ang, ang_inc, ang_mm,
     &                            rot, drot, difclt, exit, entrance, 
     &                            seed, hd, mhd, man_counter, first, 
     &                            backup)
c
c     STWAR_START_MAN initiates a new manuever for a new or prexisting 
c     tie-fighter.
c
% include 'stwar_poly.ins.ftn'
c
      integer i, man(2), man_max(2), man_counter(2)
      real ang(2, 2), ang_inc(2, 2), ang_mm(2, 2)
      real seed, rot(2), drot(2), difclt, mhd(3, 2)
      real hd(3, 2), rnorm
      logical exit(2), entrance(2), first, backup(2)
c
c    initialize a manuever for a new tie-fighter
c
      if (entrance(i)) then
        if (first) then
          do 10 j = 1, 2
            index = (j - 1) * 20 + 1
            obx(index) = -150.0
            oby(index) = 5000.0
            obz(index) = 0.0   
            man(j)         = 1
            man_counter(j) = 0
            man_max(j)     = 100
            ang(1, j)      = 0.0
            ang(2, j)      = 0.0
            ang_inc(1, j)  = 0.0
            ang_inc(2, j)  = 0.0
            ang_mm(1, j)   = 0.0
            ang_mm(2, j)   = 0.0
            mhd(1, j)      =-150.0
            mhd(2, j)      = 0.0
            mhd(3, j)      = 0.0
            hd(1, j)       = 0.0
            hd(2, j)       =-1.0
            hd(3, j)       = 0.0
            rot(j)         = 0.58
            drot(j)        = 0.0
            object(index)  = .true.
            exit(j)        = .false.
            entrance(j)    = .false.
            backup(j)      = .false.
 10       continue
          mhd(1, 2) = 150.0
          obx(21)   = 150.0
          rot(2)    = -rot(2)
        else 
          index = (i - 1) * 20 + 1
          entrance(i) = .false.
          exit(i)     = .false.
          object(index)  = .true.
          theta = 2.0 * 3.14159265 * rand(seed)
          r     = 500.0 + 500.0 * rand(seed)
          oby(index)  =-500.0
          obx(index)  = r * cos(theta)
          obz(index)  = r * sin(theta)
          man(i) = 1
          man_max(i) = 40 + 40 * rand(seed) / difclt
          man_counter(i) = 0
          theta = 2.0 * 3.14159265 * rand(seed)
          mhd(2, i) = 300.0 + 2700.0 * rand(seed)
          mhd(2, i) = abs(mhd(2, i))
          rnorm = sqrt(mhd(2, i))
          r = rnorm * rand(seed)
          r = r * r * 0.66
          mhd(1, i) = r * cos(theta)
          mhd(3, i) = r * sin(theta)
          theta = 2.0 * 3.14159265 * rand(seed)
          hd(2, i) = 300.0 + 2700.0 * rand(seed)
          hd(2, i) = abs(hd(2, i))
          rnorm = sqrt(hd(2, i))
          r = rnorm * rand(seed)
          r = r * r
          hd(1, i) = r * cos(theta)
          hd(3, i) = r * sin(theta)
          rnorm = sqrt(hd(1, i)**2 + hd(2, i)**2 + hd(3, i)**2)
          hd(1, i) = hd(1, i) / rnorm
          hd(2, i) = hd(2, i) / rnorm
          hd(3, i) = hd(3, i) / rnorm
          rot(i) = 0.0
          drot(i) = 0.3 * (rand(seed) - 0.5)
          ang(1, i) = 0.0
          ang(2, i) = 0.0
          ang_mm(1, i)  = 0.0
          ang_inc(1, i) = 0.0
          ang_mm(2, i)  = 0.0
          ang_inc(2, i) = 0.0
          if (rand(seed) .lt. 0.8) then
            backup(i) = .true.
          else
            backup(i) = .true.
          end if
        end if
c
c    initialize an exit sequence
c
      else if (exit(i)) then
        index = (i - 1) * 20 + 1
        man(i)     = 1
        ang_mm(1, i)  = 0.0
        rnorm         =-ang(1, i)
        ang_inc(1, i) = sign(1.0, rnorm) * difclt / 30.0
        ang_mm(2, i)  = 0.0
        ang_inc(2, i) = 0.0
        man_max(i)    = 1500
        man_counter(i) = 0
        mhd(2, i) = oby(index) * rand(seed)
        r = 2.0 * mhd(2, i)
        theta = 2.0 * 3.14152965 * rand(seed)
        mhd(1, i) = r * cos(theta)
        mhd(3, i) = r * sin(theta)
        drot(i) = 0.3 * (rand(seed) - 0.5)
        exit(i)     = .false.
        entrance(i) = .false.
        backup(i) = .false.
c
c    create a new manuever for an old tf
c
      else
        entrance(i) = .false.
        exit(i)     = .false.
        man(i) = rand(seed) * 3 + 1
        man(i) = min(man(i), 3)
        man_max(i) = 40 + 50 * rand (seed) / difclt
        man_counter(i) = 0
        theta = 2.0 * 3.14159265 * rand(seed)
        mhd(2, i) = 300.0 + 2000.0 * rand(seed)
        mhd(2, i) = abs(mhd(2, i))
        rnorm = sqrt(mhd(2, i))
        r = rnorm * rand(seed)
        r = r * r * 0.66
        mhd(1, i) = r * cos(theta)
        mhd(3, i) = r * sin(theta)
        drot(i) = 0.3 * (rand(seed) - 0.5)
        if (rand(seed) .lt. 0.8) then
          backup(i) = .true.
        else
          backup(i) = .true.
         end if
        if (man(i) .eq. 1) then
          ang_mm(1, i)  = 0.2 + 0.15 * rand(seed)
          rnorm         = ang_mm(1, i) - ang(1, i)
          ang_inc(1, i) = sign(1.0, rnorm) * difclt / 30.0
          ang_mm(2, i)  = 0.0
          ang_inc(2, i) = 0.15 * (rand(seed) - 0.5) * difclt
        else if (man(i) .eq. 2) then
          ang_mm(1, i)  = 0.3 + 0.3 * rand(seed)
          rnorm         = ang_mm(1, i) - ang(1, i)
          ang_inc(1, i) = sign(1.0, rnorm) * difclt / 30.0
          ang_mm(2, i)  = 3.14159265 * rand(seed)
          rnorm         = ang_mm(2, i) - ang(2, i)
          ang_inc(2, i) = sign(1.0, rnorm) * difclt / 30.0
        else
          ang_mm(1, i)  = 0.3 + 0.15 * rand(seed)
          rnorm         = ang_mm(1, i) - ang(1, i)
          ang_inc(1, i) = sign(1.0, rnorm) * difclt / 40.0
          ang_mm(2, i)  = 0.0
          ang_inc(2, i) = 0.15 * (rand(seed) - 0.5) * difclt
        end if
      end if
      return
      end





      subroutine stwar_move_tfight (i, man, man_counter, man_max,
     &                              ang, ang_inc, ang_mm, vel, rot, 
     &                              drot, bh, h, mhd, xvel, new, 
     &                              difclt, backup)
c
c     STWAR_MOVE_TFIGHT does just what the name implies, to say any
c     thing else would be to give away my secrets.
c
% include 'stwar_poly.ins.ftn'      
c
      integer i, man(2), man_counter(2), man_max(2)
      real h(3, 2), mhd(3, 2), rot(2), drot(2), ang(2, 2)
      real ang_mm(2, 2), ang_inc(2, 2), vel(2), difclt, xvel
      real bh(3, 2)
      logical new(2), backup(2), flag
c
c    re-adjust heading and velocity
c
      index = (i - 1) * 20 + 1
      chd1 = mhd(1, i) - obx(index)
      chd2 = mhd(2, i) - oby(index) + xvel
      chd3 = mhd(3, i) - obz(index)
      rnorm = sqrt(chd1**2 + chd2**2 + chd3**2)
      if (rnorm .lt. 20.0) then
        chd1 = 0.0
        chd2 = sign(1.0, h(2, i))
        chd3 = 0.0
        new(i) = .true.
      else
        chd1 = chd1 / rnorm     
        chd2 = chd2 / rnorm     
        chd3 = chd3 / rnorm
      end if
      flag = .false.
      if (backup(i) .and. chd2 .lt. 0.0) then
        diff1 = chd1 - bh(1, i)
        diff2 =-chd2 - bh(2, i)
        diff3 = chd3 - bh(3, i)
        flag = .true.
      else
        diff1 = chd1 - bh(1, i)
        diff2 = chd2 - bh(2, i)
        diff3 = chd3 - bh(3, i)
      end if
      rnorm = sqrt(diff1**2 + diff2**2 + diff3**2)
      rnorm = rnorm * 10.0 / difclt
      if (rnorm .lt. 1.0e-4) then
        diff1 = 0.0
        diff2 = 0.0
        diff3 = 0.0
      else
        diff1 = diff1 / rnorm     
        diff2 = diff2 / rnorm     
        diff3 = diff3 / rnorm
      end if
      bh(1, i) = bh(1, i) + diff1
      bh(2, i) = bh(2, i) + diff2
      bh(3, i) = bh(3, i) + diff3
      rnorm = sqrt(bh(1, i)**2 + bh(2, i)**2 + bh(3, i)**2)
      bh(1, i) = bh(1, i) / rnorm
      bh(2, i) = bh(2, i) / rnorm
      bh(3, i) = bh(3, i) / rnorm
      if (chd2 .gt. 0.0) then
        vel(i) = xvel + 25.0
      else 
        vel(i) = 10.0
      end if
      if (flag) then
        vel(i) = 10.0
      end if
      rot(i) = rot(i) + drot(i)
c
c    continue to execute a manuever
c
      if (man(i) .eq. 1) then
        ang(1, i) = ang(1, i) + ang_inc(1, i)
        ang(2, i) = ang(2, i) + ang_inc(2, i)
        if (ang_inc(1, i) .lt. 0.0) then
          if (ang(1, i) .lt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = 0.0
          end if
        else
          if (ang(1, i) .gt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = 0.0
          end if
        end if            
      else if (man(i) .eq. 2) then
        ang(1, i) = ang(1, i) + ang_inc(1, i)
        ang(2, i) = ang(2, i) + ang_inc(2, i)
        if (ang_inc(1, i) .lt. 0.0) then
          if (ang(1, i) .lt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = -ang_inc(1, i)
          end if
        else
          if (ang(1, i) .gt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = -ang_inc(1, i)
          end if
        end if            
        if (ang_inc(2, i) .lt. 0.0) then
          if (ang(2, i) .lt. ang_mm(2, i)) then
            ang(2, i) = ang_mm(2, i)
            ang_inc(2, i) = 0.0
          end if
        else
          if (ang(2, i) .gt. ang_mm(2, i)) then
            ang(2, i) = ang_mm(2, i)
            ang_inc(2, i) = 0.0
          end if
        end if                  
      else
        ang(1, i) = ang(1, i) + ang_inc(1, i)
        ang(2, i) = ang(2, i) + ang_inc(2, i)
        if (ang_inc(1, i) .lt. 0.0) then
          if (ang(1, i) .lt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = -ang_inc(1, i)
          end if
        else
          if (ang(1, i) .gt. ang_mm(1, i)) then
            ang(1, i) = ang_mm(1, i)
            ang_inc(1, i) = -ang_inc(1, i)
          end if
        end if            
      end if
c
c    combine manuever and base heading to form true heading
c
      c1 = cos(ang(1, i))
      s1 = sin(ang(1, i))
      c2 = cos(ang(2, i))
      s2 = sin(ang(2, i))
      h(1, i) = c2 * bh(1, i) - s2 * s1 * bh(2, i) + s2 * c1 * bh(3, i)
      h(2, i) =               +      c1 * bh(2, i) +      s1 * bh(3, i)
      h(3, i) =-s2 * bh(1, i) - c2 * s1 * bh(2, i) + c2 * c1 * bh(3, i)
      if (man_counter(i) .gt. man_max(i)) then
        new(i) = .true.
      end if
      return      
      end 
