#include <apollo/base.h>
#include <apollo/loader.h>
#include <apollo/strl.h>
#include <apollo/unwind.h>
#include <apollo/vfmt.h>

#define string(x) (x),(sizeof(x)-1)

typedef struct
{
    time_$clock_t   cpu_total;
    unsigned short  priority;
}
    proc1_$acct_t;

typedef unsigned short proc1_$state_t;

#define proc1_$state_waiting        0x0001
#define proc1_$state_suspended      0x0002
#define proc1_$state_susp_pending   0x0004
#define proc1_$state_bound          0x0008

typedef struct
{
    proc1_$state_t  state;
    pinteger        usr;
    linteger        upc;
    linteger        usp;
    linteger        usb;
    proc1_$acct_t   acct;
}
    proc1_$info_t;

typedef linteger node_t;

typedef struct
{
    uid_$t  pers;
    uid_$t  proj;
    uid_$t  org;
    uid_$t  subs;
    node_t  node
}
    acl_$sid;

#define proc2_$aname_len    32
typedef char proc2_$aname_t[ proc2_$aname_len ];

typedef struct
{
    time_$clock_t   cpu_time;
    short           pad;
    linteger        user_ticks;
    linteger        system_ticks;
    linteger        tick_size;
}
    proc2_$cpu_usage_t;

typedef struct
{
    uid_$t              cr_rec_uid;
    linteger            stack_base;
    proc1_$info_t       p1info;
    acl_$sid            sid;
    uid_$t              pgroup;
    boolean             is_server;
    boolean             pad;
    pinteger            min_pri;
    pinteger            max_pri;
    linteger            execute_pages   __attribute((aligned(1)));
    linteger            data_pages      __attribute((aligned(1)));
    linteger            disk_page_io    __attribute((aligned(1)));
    linteger            net_page_io     __attribute((aligned(1)));
    uid_$t              orig_pgroup     __attribute((aligned(1)));
    short               orig_upgid;
    short               upid;
    short               uppid;
    short               upgid;
    short               udpid;
    short               asid;
    uid_$t              acct_uid        __attribute((aligned(1)));
    short               acct_len;
    proc2_$aname_t      acct_name;
    short               proc_len;
    proc2_$aname_t      proc_name;
    uid_$t              tty_uid         __attribute((aligned(1)));
    short               pad2;
    proc2_$cpu_usage_t  cpu_usage;
}
    proc2_$info_t;

void proc2_$get_info(
        uid_$t          &p2_uid,
        proc2_$info_t   *info,
        pinteger        &info_buf_len,  /* size of info buffer (bytes) */
        status_$t       *sts
);

void proc2_$who_am_i(
        uid_$t *puid
);

#define KG_SYMBOL_LENGTH_MAX 64

typedef struct
{
    unsigned short jsr;
    void **trap_addr;
    unsigned short ret;

    char name[ KG_SYMBOL_LENGTH_MAX ];
    unsigned short name_len;
    void *real_addr;

    /* later we put in info regarding number+format of args, etc. */
}
    trap_t __attribute((aligned(2)));

boolean 
loader_$cond_loadu
(
    uid_$t           &uid,
    loader_$opts     &opts,
    loader_$handle_t *handle,
    status_$t        *status
);

void *
tgc_trap
(
    void *a00,
    void *a01,
    void *a02,
    void *a03,
    void *a04,
    void *a05,
    void *a06,
    void *a07,
    void *a08,
    void *a09,
    void *a10,
    void *a11,
    void *a12,
    void *a13,
    void *a14,
    void *a15,
    void *a16,
    void *a17,
    void *a18,
    void *a19,
    void *a20
)
{
    void **r = ((void **)&a00 - 1);
    char *name = (char *)*r + sizeof(unsigned short);
    short *name_len = (short *)(name + KG_SYMBOL_LENGTH_MAX );
    typedef void *(*call_t)(void *, void *, void *, void *, void *,
        void *, void *, void *, void *, void *, void *, void *, void *,
        void *, void *, void *, void *, void *, void *, void *);
    call_t *call = (call_t *)(((char *)name_len) + sizeof(short));

    static unwind_$descriptor_t *unwind_ptr = 0;
    static unsigned unwind_len;

    char *x;
    long displacement = 0;
    unsigned short nregs;
    char *sbl;
    char *before_args;
    unsigned short nargs;

/*    vfmt_$write("Return address is 0x%8zluh%.", r);*/
/*vfmt_$write("Name at 0x%8zluh, length at 0x%8zluh%.", &name, &name_len);*/
    vfmt_$ws(ios_$errout, "Call to \"%a\" trapped%.", name, name_len);
/*vfmt_$write("Real address is 0x%8zluh%.", call);*/
/*sleep(30);*/

    if( unwind_ptr == 0 )
    {
        uid_$t me;
        proc2_$info_t p2info;
        status_$t status;
        loader_$handle_t h;
        loader_$image image;
        loader_$section section;
        unsigned long i;

        proc2_$who_am_i(&me);
        proc2_$get_info(me, &p2info, sizeof p2info, &status);
        if( status.all != status_$ok && status.all != 0x00190004 )
        {
            goto punt;
        }

        loader_$cond_loadu(p2info.acct_uid, 0, &h, &status);
        if( status.all != status_$ok ) goto punt;

        loader_$inquire_image(h, &image, &status);
        if( status.all != status_$ok ) goto punt;

        for( i = 1; i <= image.nsects; i++ )
        {
            loader_$inquire_section(h, i, &section, &status);
            if( status.all != status_$ok ) goto punt;

            if( strl_$eq((char *)section.name, (unsigned short)section.name_len, string(".unwind")) == true )
            {
                break;
            }
        }

        if( i == image.nsects ) goto punt;

        unwind_ptr = (unwind_$descriptor_t *)section.addr;
        unwind_len = section.len;
    }

    for( x = (char *)unwind_ptr; x < &((char *)(unwind_ptr))[ unwind_len ]; )
    {
        unwind_$descriptor_t *d = (unwind_$descriptor_t *)x;

        if( a00 >= (void *)d->start_pc && a00 < (void *)(d->start_pc + d->length) )
        {
            unsigned short ax, dx, fp;

            switch( d->kind )
            {
                case udk$a88k_compressed:
                case udk$a88k_full:
                default:
                    goto punt;
                case udk$m68k_compressed:
/*
                    ax = d->m68k.saved_a_regs;
                    dx = d->m68k.saved_d_regs;
                    fp = d->m68k.saved_fp_regs;

                    nregs = ((ax & 0x80) ? 4 : 0)
                          + ((ax & 0x40) ? 4 : 0)
                          + ((ax & 0x20) ? 4 : 0)
                          + ((ax & 0x10) ? 4 : 0)
                          + ((ax & 0x08) ? 4 : 0)
                          + ((ax & 0x04) ? 4 : 0)
                          + ((ax & 0x02) ? 4 : 0)
                          + ((ax & 0x01) ? 4 : 0)
                          + ((dx & 0x80) ? 4 : 0)
                          + ((dx & 0x40) ? 4 : 0)
                          + ((dx & 0x20) ? 4 : 0)
                          + ((dx & 0x10) ? 4 : 0)
                          + ((dx & 0x08) ? 4 : 0)
                          + ((dx & 0x04) ? 4 : 0)
                          + ((dx & 0x02) ? 4 : 0)
                          + ((dx & 0x01) ? 4 : 0)
                          + ((fp & 0x8000) ? 8 : 0)
                          + ((fp & 0x4000) ? 8 : 0)
                          + ((fp & 0x2000) ? 8 : 0)
                          + ((fp & 0x1000) ? 8 : 0)
                          + ((fp & 0x0800) ? 8 : 0)
                          + ((fp & 0x0400) ? 8 : 0)
                          + ((fp & 0x0200) ? 8 : 0)
                          + ((fp & 0x0100) ? 8 : 0)
                          + ((fp & 0x0080) ? 8 : 0)
                          + ((fp & 0x0040) ? 8 : 0)
                          + ((fp & 0x0020) ? 8 : 0)
                          + ((fp & 0x0010) ? 8 : 0)
                          + ((fp & 0x0008) ? 8 : 0)
                          + ((fp & 0x0004) ? 8 : 0)
                          + ((fp & 0x0002) ? 8 : 0)
                          + ((fp & 0x0001) ? 8 : 0)
                            ;
*/

                    displacement = d->m68k.saved_reg_off;
                    x += unwind_$m68k_compressed_size;
                    break;
                case udk$m68k_full:
                    vfmt_$write("Full m68k frame found.%.");

                    if( d->m68k.no_stack )
                    {
/*                        nregs = 0;*/
                        break;
                    }

                    if( d->m68k.non_std )
                    {
                        goto punt;
                    }

                    {
/*
                        ax = d->m68k.saved_a_regs;
                        dx = d->m68k.saved_d_regs;
                        fp = d->m68k.saved_fp_regs;

                        nregs = ((ax & 0x80) ? 4 : 0)
                              + ((ax & 0x40) ? 4 : 0)
                              + ((ax & 0x20) ? 4 : 0)
                              + ((ax & 0x10) ? 4 : 0)
                              + ((ax & 0x08) ? 4 : 0)
                              + ((ax & 0x04) ? 4 : 0)
                              + ((ax & 0x02) ? 4 : 0)
                              + ((ax & 0x01) ? 4 : 0)
                              + ((dx & 0x80) ? 4 : 0)
                              + ((dx & 0x40) ? 4 : 0)
                              + ((dx & 0x20) ? 4 : 0)
                              + ((dx & 0x10) ? 4 : 0)
                              + ((dx & 0x08) ? 4 : 0)
                              + ((dx & 0x04) ? 4 : 0)
                              + ((dx & 0x02) ? 4 : 0)
                              + ((dx & 0x01) ? 4 : 0)
                              + ((fp & 0x8000) ? 8 : 0)
                              + ((fp & 0x4000) ? 8 : 0)
                              + ((fp & 0x2000) ? 8 : 0)
                              + ((fp & 0x1000) ? 8 : 0)
                              + ((fp & 0x0800) ? 8 : 0)
                              + ((fp & 0x0400) ? 8 : 0)
                              + ((fp & 0x0200) ? 8 : 0)
                              + ((fp & 0x0100) ? 8 : 0)
                              + ((fp & 0x0080) ? 8 : 0)
                              + ((fp & 0x0040) ? 8 : 0)
                              + ((fp & 0x0020) ? 8 : 0)
                              + ((fp & 0x0010) ? 8 : 0)
                              + ((fp & 0x0008) ? 8 : 0)
                              + ((fp & 0x0004) ? 8 : 0)
                              + ((fp & 0x0002) ? 8 : 0)
                              + ((fp & 0x0001) ? 8 : 0)
                                ;
*/

                        if( d->m68k.sp_rel ) 
                        {
                            goto punt;
                        }
                        else
                        {
                            displacement = d->m68k.saved_reg_off;
                        }
                    }
          
                    x += unwind_$m68k_full_size;
                    break;
                case udk$skip:
                    x += unwind_$skip_size;
                    break;
                case udk$abs_range:
                    goto punt;
            }

            if( displacement != 0 )
            {
                break;
            }
        }
        else
        {
            switch( d->kind )
            {
                case udk$a88k_compressed:
                    x += unwind_$a88k_compressed_size;
                    break;
                case udk$a88k_full:
                    x += unwind_$a88k_full_size;
                    break;
                case udk$m68k_compressed:
                    x += unwind_$m68k_compressed_size;
                    break;
                case udk$m68k_full:
                    x += unwind_$m68k_full_size;
                    break;
                case udk$skip:
                    x += ( unwind_$skip_size + d->skip_displacement );
                    break;
                case udk$abs_range:
                    x += ( unwind_$abs_range_size + d->skip_displacement );
                    break;
                default:
                    goto punt;
            }
        }

        if( displacement != 0 )
        {
            break;
        }

    }

    /* #bytes for auto var's == displacement, #bytes for regs = nregs */
    sbl = ((char **)&a00)[ -2 ];
    if( (unsigned long)sbl & 1 ) sbl = ((char **)&a00)[ -3 ];

/*vfmt_$ws(ios_$errout, "----> SB of calling routine is 0x%8zluh%.", &sbl);*/
sbl += displacement;
/*vfmt_$ws(ios_$errout, "----> regs at 0x%8zluh%.", &sbl);*/
    before_args = sbl; /* hmm.. don't need nregs? *?
    /* first arg is &a01 */
/* vfmt_$ws(ios_$errout, "Nregs: %wud, displacement: %ld%.", &nregs, &displacement); */
    nargs = ((unsigned int)before_args - (unsigned int)&a01) / 4;

    vfmt_$ws(ios_$errout, "There seem to be %wud args!%.", &nargs);

  punt:;
    return (**call)(a01, a02, a03, a04, a05, a06, a07, a08, a09, a10,
        a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
}
