/*
 * strl
 *
 *  Version 1.2 : Frederick Roeber : 23 February 1993
 *
 * This file contains the prototypes for the Domain/OS string handling routines.
 *
 * The calls are:
 *
 *      strl_$append
 *      strl_$compare
 *      strl_$concat
 *      strl_$copy
 *      strl_$eq
 *      strl_$gettok
 *      strl_$index
 *      strl_$lower
 *      strl_$match
 *      strl_$s2dec
 *      strl_$substr
 *
 */

/*
 * strl_$append
 *
 * This appends the "after" string to the "before" string.  The "before"
 * string's length is updated appropriately.
 */

void
strl_$append
(
    char *after,
    short &after_length,
    char *before,
    short *before_length_p,
    short &string_length
);

/*
 * strl_$compare
 *
 * This compares two strings for equality, and returns a value the sign of 
 * which reflects the sorting order of the two strings (like strcmp).
 */

short
strl_$compare
(
    char *first,
    short &first_length,
    char *second,
    short &second_length
);

/*
 * strl_$concat
 *
 * This concatenates two strings to form a third.
 */

void
strl_$concat
(
    char *first,
    short &first_length,
    char *second,
    short &second_length,
    char *result,
    short *result_length_p,
    short &string_length
);

/*
 * strl_$copy
 *
 * This copies the source string to the destination buffer.
 */

void
strl_$copy
(
    char *source,
    short &source_length,
    char *destination,
    short *destination_length_p,
    short &string_length
);

/*
 * strl_$eq
 *
 * This compares two strings for equality, and returns true or false.
 */

boolean
strl_$eq
(
    char *first,
    short &first_length,
    char *second,
    short &second_length
);

/*
 * strl_$gettok
 *
 * This gets a blank-delimited token from a string.  A zero length token is
 * returned upon end-of-string.
 */

void
strl_$gettok
(
    char *full,
    short &full_length,
    short *sxp,
    char *token,
    short *token_length_p,
    short &string_length
);

/*
 * strl_$index
 *
 * This find the index of one string in another, like index(3).
 */

short
strl_$index
(
    char *first,
    short &first_length,
    char *second,
    short &second_length
);

/*
 * strl_$lower
 *
 * This converts a string to lower case in place.
 */

void
strl_$lower
(
    char *string,
    short &length
);

/*
 * strl_$match
 *
 * This compares a string with a keyword specification, which is of the form
 *     <char>* '[' <char>* ']'
 * Where first <char>s are the abbreviation; rest are full name.
 */

boolean
strl_$match
(
    char *pattern,
    char *token,
    short &token_length
);
/*
 * strl_$s2dec
 *
 * This gets an integer token from a string.
 */

long
strl_$s2dec
(
    char *string,
    short &length,
    short *ip
);

/*
 * strl_$substr
 *
 * This takes a substring from a string.
 */

void
strl_$substr
(
    char *full,
    short &full_length,
    short &start,
    short &substring_length,
    char *result,
    short *result_length_p,
    short &string_length
);
