/*
 * cc trap.c -info 4 -idir ~/include -ndb -systype any -runtype any
 * bind trap.bin -entry main -b trap
 */

#include <apollo/base.h>
#include <apollo/error.h>
#include <apollo/ios.h>
#include <apollo/loader.h>
#include <apollo/pgm.h>
#include <apollo/vfmt.h>

#include "apollo2/cl.h"
#include "apollo2/help.h"
#include "apollo2/strl.h"

#define string(x) (x),(sizeof(x)-1)
#define program string("trap")
#define version string("1.0")

typedef void *
(*trap_$init_t)
(
    void        *routine,       /* the actual routine to call */
    short       &nargs,         /* the number of args; default = 20 */
    short       *arglens,       /* array of argument lengths; def = 16 */
    short       &retvlen,       /* return value length */
    char        *name,          /* routine name */
    short       &namelen,       /* routine name length */
    ios_$id_t   &id,            /* stream to use */
    boolean     &tb,            /* whether or not to traceback */
    status_$t   *status         /* result */
);

void
pgm_$exec
(
    char *name,              
    short &namelen,          
    short &arg_count,        
    pgm_$arg_ptr *arg_vector,
    char *env_vector[],      
    status_$t *status        
);

void main(void)
{
    status_$t status;
    short i, j;
    long l;
    boolean verbose;
    ios_$id_t id;
    name_$long_pname_t path;
    short path_len;
    short argc;
    pgm_$arg args[128];
    pgm_$argv argv;
    pgm_$connv connv;
    pgm_$proc p_handle;
    char *env = 0;

    help_$args(program, version);
    error_$init_std_format(ios_$errout, '?', version);
    cl_$init(cl_$std_options, program);

    verbose = cl_$get_flag("-l[ist]", &i);

    if( cl_$check_flag("-o[utput]", 1) == true )
    {
        name_$long_pname_t path;
        short path_len;

        (void)cl_$get_name(cl_$next, path, &path_len, sizeof path);
        id = ios_$open(path, path_len, ios_$write_opt, &status);
        if( status.all != status_$ok )
        {
            error_$std_format(status, "Cannot open \"%a\"%$", path, &path_len);
            pgm_$set_severity(pgm_$error);
            pgm_$exit();
        }
    }
    else
    {
        id = ios_$errout;
    }

    if( verbose )
    {
        vfmt_$ws(id, "Trap report:%.");
    }

    while( cl_$check_flag("-n[ame]", 1) == true )
    {
        loader_$string name;
        short namelen;
        short retval_len;
        short nargs;
        short arglens[ 20 ];
        void *global, *g2;
        loader_$handle_t handle;
        trap_$init_t start;
        void *trap; 
        boolean tb;

        (void)cl_$get_arg(cl_$next, name, &namelen, sizeof name);

        if( verbose )
        {
            vfmt_$ws(id, "Trapping \"%a\":%.", name, &namelen);
        }

        tb = cl_$check_flag("-t[raceback]", 0);

        if( verbose )
        {
            if( tb == true )
            {
                vfmt_$ws(id, "%5TCall will be traced back.%.");
            }
        }

        if( cl_$check_flag("-r[etval_len]", 1) == true )
        {
            (boolean)cl_$get_num(&l);
            retval_len = (short)l;
        }
        else
        {
            retval_len = 4;
        }

        if( verbose )
        {
            vfmt_$ws(id, "%5TReturn value is expected to be %wd bytes.%.", &retval_len);
        }

        if( cl_$get_flag("-a[rgs]", &i) == true )
        {
            nargs = (short)i;

            if( verbose )
            {
                vfmt_$ws(id, "%5T%wd args expected:%.", &nargs);
            }

            for( j = 0; j < i; j++ )
            {
                if( cl_$get_num(&l) == true )
                {
                    arglens[j] = (short)l;
                }
                else
                {
                    arglens[j] = 0;
                }

                if( verbose )
                {
                    short k = j + 1;
                    vfmt_$ws(id, "%9T%2wd: expected length of %wd bytes.%.", &k, &arglens[j]);
                }
            }
        }
        else
        {
            nargs = 0;
        }

        loader_$kg_lookup(name, namelen, loader_$kg_symbol, loader_$kg_function_only, &global);
        if( global == 0 )
        {
            status.all = loader_$undef_glbl;
            error_$std_format(status, "Cannot find \"%a\"%$", name, &namelen);
            pgm_$set_severity(pgm_$warning);
            continue;
        }

        if( verbose )
        {
            vfmt_$ws(id, "%5TFunction \"%a\" is at %8zlh%.", name, &namelen, &global);
        }

        loader_$load(string("/lib/trap_lib"), loader_$keep_on_exec, &handle, &status);
        if( status.all != status_$ok )
        {
            error_$std_format(status, "Cannot load trap_lib%$");
            pgm_$set_severity(pgm_$internal_fatal);
            pgm_$exit();
        }

        start = (trap_$init_t)loader_$lookup_start_addr(handle, &status);
        if( status.all != status_$ok )
        {
            error_$std_format(status, "Cannot find trap_$init%$");
            pgm_$set_severity(pgm_$internal_fatal);
            pgm_$exit();
        }

        trap = (*start)(global, nargs, arglens, retval_len, name, namelen, id, tb, &status);
        if( status.all != status_$ok )
        {
            error_$std_format(status, "Cannot initialize trap for %a%$", name, &namelen);
            pgm_$set_severity(pgm_$warning);
            continue;
        }

        loader_$kg_define(name, namelen, trap, loader_$kg_symbol, loader_$kg_keep_on_exec|loader_$kg_function, &status);
        if( status.all != status_$ok )
        {
            error_$std_format(status, "Cannot redefine %a to trap address%$", name, &namelen);
            pgm_$set_severity(pgm_$internal_fatal);
            pgm_$exit();
        }

        if( verbose )
        {
            loader_$kg_lookup(name, namelen, loader_$kg_symbol, loader_$kg_function_only, &g2);
            if( g2 == 0 )
            {
                status.all = loader_$undef_glbl;
                error_$std_format(status, "Cannot find \"%a\"%$", name, &namelen);
                pgm_$set_severity(pgm_$warning);
                continue;
            }

            vfmt_$ws(id, "%9TTrapped: it is now %8zlh (verified: %8zlh).%.", &trap, &g2);
        }
    }

    if( cl_$check_flag("-p[rocess]", -1) == true )
    {
/*        (void)cl_$get_name(cl_$next, path, &path_len, sizeof path);*/
        (void)cl_$get_arg(cl_$next, path, &path_len, sizeof path);
        argc = cl_$get_arg_count();

        for( i = 1; i <= argc; i++ )
        {
            cl_$get_arg(cl_$next, args[i].chars, &args[i].len, 128);
if( args[i].chars[0] == '+' ) args[i].chars[0] = '-';
            argv[i] = &args[i];
        }
    }
    else
    {
        strl_$copy(string("/com/sh"), path, &path_len, sizeof path);
        argc = 0;
    }

    strl_$copy(path, path_len, args[0].chars, &args[0].len, 128);
    argv[0] = &args[0];
    argc++;
/*
    connv[ ios_$stdout ] = ios_$stdout;
    connv[ ios_$stdin  ] = ios_$stdin;
    connv[ ios_$errout ] = ios_$errout;
#if defined(ios_$errin)
    connv[ ios_$errin  ] = ios_$errin;
#endif
    connv[ id          ] = id;
*/
    if( verbose )
    {
/*
        vfmt_$ws(id, "Invoking \"%a%$", path, &path_len);
*/
        vfmt_$ws(id, "Execing \"%a%$", path, &path_len);

        for( i = 1 ; i < argc; i++ )
        {
            vfmt_$ws(id, " %a%$", argv[i]->chars, &argv[i]->len);
        }

        vfmt_$ws(id, "\"%.");
    }

    pgm_$exec(path, path_len, argc, &argv[0], &env, &status);
    error_$std_format(status, "Execing \"%a\" return %8zlh%$", path, &path_len, &status.all);
    pgm_$exit();

/*
    pgm_$invoke(path, path_len, argc, argv, id, connv, pgm_$wait, &p_handle, &status);
    error_$std_format(status, "Invoking \"%a\" returns %8zlh%$", path, &path_len, &status.all);
    pgm_$exit();
*/

}
