/*
 * help.h
 *
 * Version 1.0 : Frederick Roeber : 7 April 1995
 *
 */

typedef short enum
{
    help_$help,
    help_$usage,
    help_$version
}
help_$help_t;

#define help_$help_opt      0x01
#define help_$usage_opt     0x02
#define help_$version_opt   0x04

typedef short help_$help_opt_t;

/*
 * help_$args
 *
 * This routine checks the command line arguments for any of the 
 * standard help commands -version, -help, or -usage, and handles
 * them appropriately.
 */

void
help_$args
(
    char  *name,        /* program name */
    short &namlen,      /* name length */
    char  *version,     /* program (OS?) version */
    short &versionlen   /* version length */
);

/*
 * help_$print
 *
 * This routine prints out the help text to ios_$errout.
 */

void
help_$print
(
    char  *name,        /* program name */
    short &namlen,      /* name length */
    char  *version,     /* program (OS?) version */
    short &versionlen   /* version length */
);

/*
 * help_$print_ok
 *
 * This routine prints out the help text to ios_$errout; it returns
 * a success status.
 */

void
help_$print_ok
(
    char      *name,        /* program name */
    short     &namlen,      /* name length */
    char      *version,     /* program (OS?) version */
    short     &versionlen,  /* version length */
    status_$t *status       /* result status */
);

/*
 * help_$print_opts
 *
 * This routine prints out the selected help information to the
 * indicated stream.
 */

void
help_$print_opts
(
    ios_$id_t        &s,            /* output stream */
    help_$help_opt_t &opts,         /* which help information to print */
    char             *name,         /* program name */
    short            &namelen,      /* name length */
    char             *version,      /* program (OS?) version */
    short            &versionlen    /* program version length */
);

/*
 * help_$print_opts_ok
 *
 * This routine prints out the selected help information to the
 * indicated stream; it returns a success status.
 */

void
help_$print_opts_ok
(
    ios_$id_t        &s,            /* output stream */
    help_$help_opt_t &opts,         /* which help information to print */
    char             *name,         /* program name */
    short            &namelen,      /* name length */
    char             *version,      /* program (OS?) version */
    short            &versionlen,   /* program version length */
    status_$t        *status        /* result stauts */
);

/*
 * help_$print_stream
 *
 * This routine prints out the help file to the indicated stream.
 */

void
help_$print_stream
(
    ios_$id_t &s,            /* output stream */
    char      *name,         /* program name */
    short     &namelen,      /* name length */
    char      *version,      /* program (OS?) version */
    short     &versionlen    /* program version length */
);
