/*
 * cc trap_lib.c -info 4 -pic -idir ~/include -ndb -systype any -runtype any
 * bind trap_lib.bin -entry trap_$init -b trap_lib
 */

#include <apollo/base.h>
#include <apollo/errlog.h>
#include <apollo/loader.h>
#include <apollo/vfmt.h>

#include "apollo2/strl.h"

static void *(*trap_$routine_pt)(...);
static short trap_$arglens[ 21 ];
static loader_$string trap_$name;
static short trap_$namelen;
static ios_$id_t trap_$id;
static boolean trap_$tb;

typedef void *(*trap_$normal_routine_pt)(...);

void 
mst_$get_uid
(
    void *&addr, 
    uid_$t *uid, 
    unsigned long *offset, 
    status_$t *status
);

static void
argdump
(
    ios_$id_t   id,
    short       len,
    void       *argp
)
{
    uid_$t uid;
    unsigned long offset;
    status_$t status;

    char *a = (char *)argp;
    if( len <= 0 ) len = 0;

    mst_$get_uid(argp, &uid, &offset, &status);
    if( status.all != status_$ok )
    {
        vfmt_$ws(id, " <invalid pointer>%.");
        return;
    }

    while( len >= 4 )
    {
        vfmt_$ws(id, " %8zlh%$", a);
        len -= 4;
        a += 4;
    }

    switch( len )
    {
        short b;
        case 3:
            b  = ((short *)a)[1];
            vfmt_$ws(id, " %4zwh %2zwh%.", a, &b);
            break;
        case 2:
            vfmt_$ws(id, " %4zwh%.", a);
            break;
        case 1:
            b = (short)*a;
            vfmt_$ws(id, " %2zwh%.", &b);
            break;
        case 0:
            vfmt_$ws(id, "%.");
            break;
    }

    return;
}

void *
trap_$trap
(
    void   *a01,
    void   *a02,
    void   *a03,
    void   *a04,
    void   *a05,
    void   *a06,
    void   *a07,
    void   *a08,
    void   *a09,
    void   *a10,
    void   *a11,
    void   *a12,
    void   *a13,
    void   *a14,
    void   *a15,
    void   *a16,
    void   *a17,
    void   *a18,
    void   *a19,
    void   *a20
)
{
    short i;
    trap_$normal_routine_pt rt;
    void *r;

    /* I hate some of C's shortcomings */
    void *args[ 21 ];

    args[  1 ] = a01;
    args[  2 ] = a02;
    args[  3 ] = a03;
    args[  4 ] = a04;
    args[  5 ] = a05;
    args[  6 ] = a06;
    args[  7 ] = a07;
    args[  8 ] = a08;
    args[  9 ] = a09;
    args[ 10 ] = a10;
    args[ 11 ] = a11;
    args[ 12 ] = a12;
    args[ 13 ] = a13;
    args[ 14 ] = a14;
    args[ 15 ] = a15;
    args[ 16 ] = a16;
    args[ 17 ] = a17;
    args[ 18 ] = a18;
    args[ 19 ] = a19;
    args[ 20 ] = a20;

    vfmt_$ws(trap_$id, "Call to %a trapped:%.", trap_$name, &trap_$namelen);

    if( trap_$tb )
    {
        vfmt_$ws(trap_$id, "Traceback:%.");
        errlog_$traceback(trap_$id, 0, 0);
    }

    for( i = 1; i <= 20; i++ )
    {
        if( trap_$arglens[i] == 0 ) continue;
        vfmt_$ws(trap_$id, "%5TArgument %2wd: %8zlh -->%$", &i, &args[i]);
        argdump(trap_$id, trap_$arglens[i], args[i]);
    }

    rt = (trap_$normal_routine_pt)trap_$routine_pt;

    vfmt_$ws(trap_$id, "  Making actual call to %a...%.", trap_$name, &trap_$namelen);
    r = (*rt)(a01, a02, a03, a04, a05, a06, a07, a08, a09, a10,
              a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
    vfmt_$ws(trap_$id, "Call to %a returned%$", trap_$name, &trap_$namelen);
    argdump(trap_$id, trap_$arglens[0], &r);

    for( i = 1; i <= 20; i++ )
    {
        if( trap_$arglens[i] == 0 ) continue;
        vfmt_$ws(trap_$id, "%5TArgument %2wd: %8zlh -->%$", &i, &args[i]);
        argdump(trap_$id, trap_$arglens[i], args[i]);
    }

    return r;
}

void *
trap_$init
(
    void        *routine,       /* the actual routine to call */
    short       &nargs,         /* the number of args; default = 20 */
    short       *arglens,       /* array of argument lengths; def = 16 */
    short       &retvlen,       /* return value length */
    char        *name,          /* routine name */
    short       &namelen,       /* routine name length */
    ios_$id_t   &id,            /* stream to use */
    boolean     &tb,            /* whether or not to traceback */
    status_$t   *status         /* result */
)
{
    short i;

    trap_$routine_pt = routine;

    trap_$arglens[0] = retvlen;

    if( nargs == 0 )
    {
        for( i = 1; i <= 20; i++ )
        {
            trap_$arglens[i] = 16;
        }
    }
    else
    {
        if( nargs > 20 )
        {
            nargs = 20;
        }

        for( i = 1; i <= nargs; i++ )
        {
            trap_$arglens[i] = arglens[i-1];
        }

        for( ; i <= 20; i++ )
        {
            trap_$arglens[i] = 0;
        }
    }

    strl_$copy(name, namelen, trap_$name, &trap_$namelen, loader_$string_maxlen);

    trap_$id = id;
    trap_$tb = tb;

    status->all = status_$ok;
    return trap_$trap;
}

