{  PUTGLYPH.PAS, /us/com/trint, Jim Rees, 12 April 1984
   Typesetter interpreter

   Changes:
      04/12/84 rees original coding.


     --------------------------------------------------------------------------
    |   THE FOLLOWING PROGRAMS ARE THE SOLE PROPERTY OF APOLLO COMPUTER INC.   |
    |         AND CONTAIN ITS PROPRIETARY AND CONFIDENTIAL INFORMATION.        |
     --------------------------------------------------------------------------

}

Module Putglyph;

%include '/us/ins/ubase.ins.pas' ;
%include '/us/ins/error.ins.pas' ;
%include '/us/ins/gpr.ins.pas' ;

Const
    max_fonts = 40;

Var
    font_ids:   array [1..max_fonts] of integer;
    have_font:  boolean;

Procedure InitScreen;

Var
    size:       gpr_$offset_t;
    status:     status_$t;
    bitmap:     gpr_$bitmap_desc_t;
    i:          integer;

Begin
    size.x_size := 800;
    size.y_size := 800;
    gpr_$init(gpr_$direct, stream_$errout, size, 0, bitmap, status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t initialize GPR%$');

    for i := 1 to max_fonts do
        font_ids[i] := -1;

    have_font := false;

    gpr_$enable_input(gpr_$keystroke, [' '..'~'], status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t enable keystroke input%$');

    gpr_$set_auto_refresh(true, status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t set auto refresh%$');

    gpr_$set_raster_op(0, 7, status);   { OR }
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t set raster op%$')
End;

Procedure EndScreen;

Var
    status:     status_$t;
    count:      integer;

Begin
    gpr_$force_release(count, status);
    gpr_$terminate(false, status)
End;

Procedure PutGlyph(
    IN  glyph:      integer;
    IN  x:          integer32;
    IN  y:          integer32
);

Var
    text:       gpr_$string_t;
    status:     status_$t;

Begin
    if not have_font then return;
    gpr_$move(x, y, status);

    if status.all <> status_$ok then begin
        error_$std_format(status, 'Can''t move%$');
        return
        end;

    text[1] := chr(glyph);
    gpr_$text(text, 1, status);
    if status.all = gpr_$display_not_acq then begin
        if gpr_$acquire_display(status) then;
        if status.all <> status_$ok then
            error_$std_format(status, 'Can''t acquire display%$');
        gpr_$text(text, 1, status)
        end;
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t write text to screen%$')
End;

Procedure NewPage(OUT data: char);

Var
    status:     status_$t;
    etype:      gpr_$event_t;
    pos:        gpr_$position_t;

Begin
    gpr_$set_cursor_active(true, status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t activate cursor%$');

    if gpr_$event_wait(etype, data, pos, status) then;
    if status.all = gpr_$display_not_acq then begin
        if gpr_$acquire_display(status) then;
        if status.all <> status_$ok then
            error_$std_format(status, 'Can''t acquire display%$');
        if gpr_$event_wait(etype, data, pos, status) then
        end;

    if status.all <> status_$ok then
        error_$std_format(status, 'Event wait failed%$');

    gpr_$set_cursor_active(false, status);
    gpr_$clear(gpr_$background, status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t clear screen%$')
End;

Procedure UseFont(
    IN  fontno:     integer;
    IN  name:       name_$pname_t;
    IN  namelen:    integer
);

Var
    status:     status_$t;
    fontid:     integer;

Begin
    have_font := false;
    if font_ids[fontno] = -1 then begin
        gpr_$load_font_file(name, namelen, fontid, status);
        if status.all <> status_$ok then begin
            error_$std_format(status, 'Can''t load font %a%$', name, namelen);
            return
            end;
        font_ids[fontno] := fontid
        end;

    gpr_$set_text_font(font_ids[fontno], status);
    if status.all <> status_$ok then
        error_$std_format(status, 'Can''t set font %wd%$', fontno)
    else have_font := true
End;
