{  TRPRV.PAS, /us/com/trprv, Jim Rees, 12 April 1984
   Typesetter interpreter

   Changes:
      04/12/84 rees original coding.


     --------------------------------------------------------------------------
    |   THE FOLLOWING PROGRAMS ARE THE SOLE PROPERTY OF APOLLO COMPUTER INC.   |
    |         AND CONTAIN ITS PROPRIETARY AND CONFIDENTIAL INFORMATION.        |
     --------------------------------------------------------------------------

}


PROGRAM troff_interpreter;


%nolist ;
%include '/us/ins/ubase.ins.pas' ;
%include '/us/ins/name.ins.pas' ;
%include '/us/ins/vfmt.ins.pas' ;
%include '/us/ins/error.ins.pas' ;
%include '/us/ins/streams.ins.pas' ;
%include '/us/ins/pgm.ins.pas' ;
%include '/us/ins/cl.ins.pas' ;
%include '/us/ins/helplib.ins.pas' ;
%list ;


CONST   help_name     = 'trprv' ;
        help_name_len = 5 ;
        help_ver      = '1.0' ;
        help_ver_len  = 3 ;


VAR     status:         status_t;
        i:              integer;
        name:           name_$pname_t ;
        namelen:        integer ;
        strid:          stream_$id_t;
        std_fonts:      boolean;

Procedure pass2(
    IN  in_stream:      stream_$id_t;
    IN  std_fonts:      boolean;
    OUT status:         status_$t
); extern;

%eject ;
{  Main program starts here.  }

BEGIN
    help_$args (help_name, help_name_len, help_ver, help_ver_len) ;

    error_$init_std_format(errout, '?', help_name, help_name_len);
    cl_$init ([], help_name, help_name_len) ;

    std_fonts := cl_$get_flag ('-std[fonts]', i);

    cl_$check_unclaimed ;

    if cl_$get_name(cl_$first, name, namelen, name_$pnamlen_max) then begin
        stream_$open(name, namelen, stream_$read, stream_$unregulated, strid, status);
        if status.all <> status_$ok then begin
            error_$std_format(status, 'Can''t open %a%$', name, namelen);
            pgm_$exit
            end;
        end
    else
        strid := stdin;

    pass2(strid, std_fonts, status);
    if status.all <> status_$ok then
        error_$print(status);

    pgm_$exit

END.
