/* pass1.c, /us/com/trprv, Jim Rees, 12 April 1984
   Typesetter interpreter

   Changes:
      04/12/84 rees original coding.


     --------------------------------------------------------------------------
    |   THE FOLLOWING PROGRAMS ARE THE SOLE PROPERTY OF APOLLO COMPUTER INC.   |
    |         AND CONTAIN ITS PROPRIETARY AND CONFIDENTIAL INFORMATION.        |
     --------------------------------------------------------------------------

*/

#include <stdio.h>
#include <sgtty.h>

#include "chartab.h"
#include "pass.h"

#define MAXPAGE	200		/* how many pages we can seek */

#define UPI	432		/* CAT units per inch */
#define UPP	(UPI * 11)	/* CAT units per page */
#define SPFONT  03
#define RAILMAG 03
#define MCASE   0100
#define PSIZE   017

#define PPI	72.		/* Pixels per inch */

#define TopMargin	(UPI / 2.)
#define LeftMargin	(UPI / 2.)

struct {
	int scode;
	int rcode;
} ptsizes[] = {
		010, 6,
		0,   7,
		01,  8,
		07,  9,
		02,  10,
		03,  11,
		04,  12,
		05,  14,
		011, 16,
		06,  18,
		012, 20,
		013, 22,
		014, 24,
		015, 28,
		016, 36,
		0,   0
};

struct {
	long key;
	int col, row;
	int psize, mcase, railmag;
	int doublesize;
} pages[MAXPAGE];

int col, row;
int psize, mcase, railmag;
int doublesize;
int pageno, pagewanted;
FILE *infile;

main(ac, av)
int ac;
char *av[];
{
	int infd;
	int x, y;

	if (ac != 2)
		exit(1);
	infd = atoi(av[1]);
	infile = fdopen(infd, "r");

	asctab[18] = '-';    /* 3/4 em dash */
	spectab[32] = '_';   /* underrule */
	spectab[102] = '|';     /* box rule */

	pageno = 1;
	pages[pageno].key = 1;
	getPageWanted();
	ofile(infile);
	exit(0);
}

/*
 * Read the next page wanted by pass2.  If it is in the page table,
 * seek to it.
 */
getPageWanted()
{
	struct ilr ilr;
	int p;
	long ln;

	if (read(0, &ilr, sizeof ilr) <= 0)
		exit(0);
	if (ilr.type == I_PAGE)
		pagewanted = ilr.c;

	/* If we're already at the correct page, just return.  */
	if (pageno == pagewanted)
		return;

	/* If we know where the page is, seek to it.  */
	p = pagewanted % MAXPAGE;
	if ((ln = pages[p].key) > 0 || pagewanted == 1) {
		fseek(infile, ln, 0);
		pageno = pagewanted;
	}

	/* If we've passed it, but don't know the seek key,
	 * seek to page 1.  Shouldn't happen.  */
	if (pagewanted < pageno) {
		p = 1;
		fseek(infile, pages[1].key, 0);
		pageno = 1;
	}

	row = pages[p].row;
	col = pages[p].col;
	mcase = pages[p].mcase;
	psize = pages[p].psize;
	railmag = pages[p].railmag;
}

/* ofile() -- Reads troff codes from FILE *inbuf until EOF.  Calls on
 *      force(c) to display each character after determining row and col.
 */

ofile(inbuf)
FILE *inbuf;
{
	register int c;
	static int initialized;
	int esc, lead, back, verd;
	int oback, olead;

	while((c = getc(inbuf)) != EOF) {

		if(!c)
			continue;
		if(c & 0200)
			{
			esc += (~c) & 0177;
			continue;
			}
		if(esc)
			{
			if(back)
				esc = -esc;
			col += esc;
			esc = 0;
			}
		if((c & 0377) < 0100)	/*  Purely for efficiency  */
			goto normal_char;
		switch(c)
			{
			case 0100:
				if(!initialized++) {
					row = col = lead = esc = lead = 0;
					verd = back = mcase = railmag = 0;
				}
				else
					goto out;
				break;
			case 0101:	/* lower rail */
				railmag &= ~01;
				break;
			case 0102:	/* upper rail */
				railmag |= 01;
				break;
			case 0103:	/* upper mag */
				railmag |= 02;
				break;
			case 0104:	/* lower mag */
				railmag &= ~02;
				break;
			case 0105:	/* lower case */
				mcase = 0;
				break;
			case 0106:	/* upper case */
				mcase = MCASE;
				break;
			case 0107:	/* escape forward */
				back = 0;
				break;
			case 0110:	/* escape backwards */
				back = 1;
				break;
			case 0111:	/* stop */
				force(c);
				break;
			case 0112:	/* lead forward */
				verd = 0;
				break;
			case 0113:	/* undefined */
				break;
			case 0114:	/* lead backward */
				verd = 1;
				break;
			case 0115:	/* undefined */
			case 0116:
			case 0117:
				break;
			default:
				if((c & 0340) == 0140)	/* leading */
					{
					lead = (~c) & 037;
					if(verd)
						lead = -lead;
					row += lead * 3;
					continue;
					}
				if((c & 0360) == 0120)	/* size change */
					{
					psize = c & PSIZE;
					/* apologies, but this is a patch
					 to simulate real typesetter hardware*/
					if (psize <= 010)
						doublesize = 0;
					else
						doublesize = 55;
					continue;
					}
				if(c & 0300)
					continue;
			normal_char:
				force(c);
			}
		}
	out:
		force(0);
}

/* force(c) -- Displays troff code "c" at "row" and "col" in size "psize"
 *      and font "railmag."
 */

force(c)
char c;
{
	struct ilr ilr;
	int i, rsize, x, y;
	int lastpage;
	static int osize, ormag;
	long key;

	if (row >= UPP || c==0) {       /* End of page */
		row -= UPP;
		lastpage = pageno++;
		key = ftell(infile);
		if (c == 0)
			key++;
		i = pageno % MAXPAGE;
		pages[i].key = key;
		pages[i].row = row;
		pages[i].col = col;
		pages[i].mcase = mcase;
		pages[i].psize = psize;
		pages[i].railmag = railmag;

		if (lastpage == pagewanted) {
			ilr.type = I_PAGE;
			ilr.c = lastpage;
			ilr.x = key;
			write(1, &ilr, sizeof ilr);
			getPageWanted();
		}
		if (c == 0)
			return;
	}
	if (pageno != pagewanted)
		return;
	c |= mcase;
	if (railmag == SPFONT)
		c = spectab[c];
	else
		c = asctab[c];
	for (i=0; ptsizes[i].rcode != 0; i++)
		if (ptsizes[i].scode == psize)
			break;
	rsize = ptsizes[i].rcode;

	if (railmag != ormag) {
		ilr.type = I_FONT;
		ilr.c = ormag = railmag;
		write(1, &ilr, sizeof ilr);
	}

	if (rsize != osize) {
		ilr.type = I_SIZE;
		ilr.c = osize = rsize;
		write(1, &ilr, sizeof ilr);
	}

	x = (col - doublesize - LeftMargin) / (float) UPI * PPI;
	y = (row - TopMargin) / (float) UPI * PPI;

	ilr.type = I_GLYPH;
	ilr.c = c;
	ilr.x = x;
	ilr.y = y;
	write(1, &ilr, sizeof ilr);
}

putdebug(c, x, y)
int c, x, y;
{
	struct ilr ilr;

	ilr.type = I_DEBUG;
	ilr.c = c;
	ilr.x = x;
	ilr.y = y;
	write(1, &ilr, sizeof ilr);
}
