/* pass2.c, /us/com/trprv, Jim Rees, 12 April 1984
   Typesetter interpreter

   Changes:
      04/12/84 rees original coding.


     --------------------------------------------------------------------------
    |   THE FOLLOWING PROGRAMS ARE THE SOLE PROPERTY OF APOLLO COMPUTER INC.   |
    |         AND CONTAIN ITS PROPRIETARY AND CONFIDENTIAL INFORMATION.        |
     --------------------------------------------------------------------------

*/

#include "/sys/ins/base.ins.c"
#include "/sys/ins/error.ins.c"

#include <stdio.h>
#include <signal.h>

#include "pass.h"

#define FONTSTYLE	"memp"

#define APS(s)	*s, (short) strlen(s)	/* Pascal style string */

int cfd, dfd;
int std_fonts, pass1_died;

struct {
	char size;
	char w, iw, h;
} fontab[] = {
	6,  3, 5,  7,
	7,  3, 5,  7,
	8,  3, 5,  7,
	9,  3, 5,  7,
	10, 3, 5,  8,
	11, 3, 5,  9,
	12, 3, 5, 10,
	14, 3, 5, 11,
	16, 4, 5, 12,
	18, 4, 5, 14,
	20, 4, 5, 14,
	22, 4, 5, 18,
	0,  0, 0,  0
};

char *fontnames[] = {
	"r.l",
	"i.r",
	"r.b",
};

char *std19l = "/sys/dm/fonts/std.19l";

extern std_$call initscreen(), endscreen(), newpage(), putglyph(),
	usefont();

extern status_$t unix_proc_$status;

pass2(infdp, std_f, statp)
stream_$id_t *infdp;
char *std_f;
status_$t *statp;
{
	char buf[256];
	int i, pid;
	int pipe_sig();
	int cpfd[2], dpfd[2], child_dfd;
	struct ilr ilr;

	pipe(cpfd);	/* command pipe, to child */
	pipe(dpfd);	/* data pipe, from child */
	child_dfd = dup(*infdp);
	close(*infdp);
	sprintf(buf, "%d", child_dfd);
	pid = vfork();
	if (pid < 0)
		errexit(unix_proc_$status, "Can't vfork");
	if (pid == 0) {
		/* child */
		/* We have to close stdin, stdout, and stderr.  If the
		   child has any streams open on the pad, the DM gets
		   totally confused. */
		dup2(cpfd[0], 0);
		close(cpfd[1]);
		dup2(dpfd[1], 1);
		close(dpfd[0]);
		close(2);
		execl(PASS1, "pass1", buf, NULL);
		_exit(1);
	}
	close(cpfd[0]);
	close(dpfd[1]);
	close(child_dfd);
	cfd = cpfd[1];
	dfd = dpfd[0];
	initscreen();
	if (*std_f) {
		std_fonts = 1;
		usefont((short) 1, APS(std19l));
	}
	signal(SIGPIPE, pipe_sig);
	ilr.type = I_PAGE;
	ilr.c = 1;
	write(cfd, &ilr, sizeof ilr);

	for (;;) {
		if ((i = read(dfd, &ilr, sizeof ilr)) <= 0)
			pass1_died = 1;
		if (pass1_died)
			break;
		if (DoCmd(&ilr) < 0)
			break;
	}

	endscreen();
	statp->all = status_$ok;
}

DoCmd(ilp)
struct ilr *ilp;
{
	int i;
	char c;
	struct ilr ilr;
	static int pageno = 1;
	static int font, size, ofont, osize;

	switch (ilp->type) {
	case I_PAGE:
		newpage(c);
		pageno = DoOpt(pageno, c);
/*		fprintf(stderr, "page %d key %d next %d\n", ilp->c, ilp->x, pageno);*/
		ilr.type = I_PAGE;
		ilr.c = pageno;
		write(cfd, &ilr, sizeof ilr);
		break;
	case I_GLYPH:
		if (font != ofont || size != osize) {
			findfont(font, size);
			ofont = font;
			osize = size;
		}
		putglyph((short) ilp->c, (long) ilp->x, (long) ilp->y);
		break;
	case I_FONT:
		font = ilp->c;
		break;
	case I_SIZE:
		size = ilp->c;
		break;
	case I_DEBUG:
		fprintf(stderr, "debug info %d %d %d\n", ilp->c, ilp->x, ilp->y);
		break;
	}
	return(pageno);
}

findfont(font, size)
int font, size;
{
	int i, w, h;
	static int oh, ofont;
	char name[80];

	if (std_fonts)
		return;

	for (i = 0; fontab[i].size != 0; i++)
		if (fontab[i].size == size)
			break;

	if (fontab[i].size == 0)
		/* Too big; use the biggest we have */
		i--;

	h = fontab[i].h;

	if (font == 3)
		/* math font; have to do this better */
		font = 0;

	if (h == oh && font == ofont)
		return;

	if (font == 1)
		/* italic */
		w = fontab[i].iw;
	else
		w = fontab[i].w;

	oh = h;
	ofont = font;
	sprintf(name, "%s/%s%dx%d.%s",
	    FONTDIR, FONTSTYLE, w, h, fontnames[font]);
	usefont((short) ((3 * (h - 7) + font) + 1), APS(name));
}

/*
 * Given the current page number and the character the user typed,
 * return the next page no. to display, or -1 to quit.
 */
DoOpt(p, c)
int p;
char c;
{
	if (c >= '1' && c <= '9')
		p = c - '0';
	else {
		switch (c) {
		case 'q':	/* quit */
			p = -1;
			break;
		case '-':	/* previous page */
			p--;
			if (p <= 0)
				p = 1;
			break;
		case '$':	/* last page */
			p = 0;
			break;
		default:	/* next page */
			p++;
			break;
		}
	}
	return p;
}

pipe_sig()
{
	pass1_died = 1;
}

errexit(stat, s)
status_$t stat;
char *s;
{
	char text[256];

	sprintf(text, "%s%%$", s);
	error_$std_format(stat, text);
	pgm_$exit();
}
