/* pass2.c, /us/com/trprv, Jim Rees, 12 April 1984
   Typesetter interpreter

   Changes:
      04/12/84 rees original coding.


     --------------------------------------------------------------------------
    |   THE FOLLOWING PROGRAMS ARE THE SOLE PROPERTY OF APOLLO COMPUTER INC.   |
    |         AND CONTAIN ITS PROPRIETARY AND CONFIDENTIAL INFORMATION.        |
     --------------------------------------------------------------------------

*/

#include <stdio.h>
#include <signal.h>

#include "pass.h"

int cfd, dfd;
int std_fonts, pass1_died;

main(ac, av)
int ac;
char *av[];
{
	char buf[256];
	int i, pid;
	int pipe_sig();
	int cpfd[2], dpfd[2], child_dfd;
	struct ilr ilr;

	pipe(cpfd);	/* command pipe, to child */
	pipe(dpfd);	/* data pipe, from child */
	child_dfd = open(av[1], 0);
	if (child_dfd < 0) {
		perror(av[1]);
		exit(1);
	}
	sprintf(buf, "%d", child_dfd);
	pid = vfork();
	if (pid < 0) {
		perror("vfork");
		exit(1);
	}
	if (pid == 0) {
		/* child */
		/* We have to close stdin, stdout, and stderr.  If the
		   child has any streams open on the pad, the DM gets
		   totally confused. */
		dup2(cpfd[0], 0);
		close(cpfd[1]);
		dup2(dpfd[1], 1);
		close(dpfd[0]);
/*		close(2);*/
		execl(PASS1, "pass1", buf, NULL);
		_exit(1);
	}
	close(cpfd[0]);
	close(dpfd[1]);
	close(child_dfd);
	cfd = cpfd[1];
	dfd = dpfd[0];
	signal(SIGPIPE, pipe_sig);
	ilr.type = I_PAGE;
	ilr.c = 1;
	write(cfd, &ilr, sizeof ilr);

	for (;;) {
		if ((i = read(dfd, &ilr, sizeof ilr)) <= 0)
			pass1_died = 1;
		if (pass1_died)
			break;
		if (DoCmd(&ilr) < 0)
			break;
	}
	exit(0);
}

DoCmd(ilp)
struct ilr *ilp;
{
	int i;
	char c;
	struct ilr ilr;
	static int pageno = 1;

	switch (ilp->type) {
	case I_PAGE:
		newpage(&c);
		pageno = DoOpt(pageno, c);
		fprintf(stderr, "page %d key %d next %d\n", ilp->c, ilp->x, pageno);
		ilr.type = I_PAGE;
		ilr.c = pageno;
		write(cfd, &ilr, sizeof ilr);
		break;
	case I_GLYPH:
		putglyph(ilp->c, ilp->x, ilp->y);
		break;
	case I_FONT:
		fprintf(stderr, "font %d\n", ilp->c);
		break;
	case I_SIZE:
		fprintf(stderr, "size %d\n", ilp->c);
		break;
	default:
		fprintf(stderr, "debug info %d %d %d %d\n",
		    ilp->type, ilp->c, ilp->x, ilp->y);
		break;
	}
	return(pageno);
}

putglyph(c, x, y)
int c, x, y;
{
	fprintf(stderr, "%4d %4d ", x, y);
	if (c < ' ' || c > '~')
		fprintf(stderr, "%2x\n", c);
	else
		fprintf(stderr, " %c\n", c);
}

newpage(cp)
char *cp;
{
	char buf[4];

	fprintf(stderr, "page: ");
	fgets(buf, sizeof buf, stdin);
	*cp = buf[0];
}

/*
 * Given the current page number and the character the user typed,
 * return the next page no. to display, or -1 to quit.
 */
DoOpt(p, c)
int p;
char c;
{
	if (c >= '1' && c <= '9')
		p = c - '0';
	else {
		switch (c) {
		case 'q':	/* quit */
			p = -1;
			break;
		case '-':	/* previous page */
			p--;
			if (p <= 0)
				p = 1;
			break;
		case '$':	/* last page */
			p = 0;
			break;
		default:	/* next page */
			p++;
			break;
		}
	}
	return p;
}

pipe_sig()
{
	pass1_died = 1;
}
