PROGRAM test;


%nolist ;
%include '/us/ins/ubase.ins.pas' ;
%include '/us/ins/error.ins.pas' ;
%include '/us/ins/gpr.ins.pas' ;
%include '/us/ins/vfmt.ins.pas' ;
%include '/us/ins/error.ins.pas' ;
%include '/us/ins/streams.ins.pas' ;
%list ;


VAR
    i:          integer;
    size:       gpr_$offset_t;
    status:     status_$t;
    bitmap:     gpr_$bitmap_desc_t;
    fontid:     integer;
    etype:      gpr_$event_t;
    pos:        gpr_$position_t;
    count:      integer;
    data:       char;

{  Main program starts here.  }

BEGIN
    size.x_size := 800;
    size.y_size := 800;
    gpr_$init(gpr_$direct, stream_$errout, size, 0, bitmap, status);
    if status.all <> status_$ok then error_$print(status);

    gpr_$load_font_file('std.19l', 7, fontid, status);
    if status.all <> status_$ok then error_$print(status);
    gpr_$set_text_font(fontid, status);
    if status.all <> status_$ok then error_$print(status);

    gpr_$enable_input(gpr_$keystroke, [' '..'~'], status);
    if status.all <> status_$ok then error_$print(status);

    gpr_$set_auto_refresh(true, status);
    if status.all <> status_$ok then error_$print(status);

    if gpr_$acquire_display(status) then;
    if status.all <> status_$ok then error_$print(status);

    for i := 1 to 6 do begin
        gpr_$move(1000, 1000, status);
        gpr_$text('x', 1, status);
        if gpr_$event_wait(etype, data, pos, status) then;
        if status.all <> status_$ok then error_$print(status);

        gpr_$clear(0, status);
        if status.all <> status_$ok then error_$print(status);

        vfmt_$ws2(stream_$errout, 'etype %ld data %ld%.', etype, ord(data))
    end;

    gpr_$force_release(count, status);
    gpr_$terminate(false, status)
END.
