#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/ios_dir.ins.c"
#include "/sys/ins/io_traits.ins.c"

#include "v2.h"
#include "v2d.h"

extern io_$epv v2_$io_epv;

ios_$id_t
v2_dir_$open(hpp, resid, resid_lenp, ooptsp, stp)
v2_handle_t **hpp;
char *resid;
short *resid_lenp;
ios_$open_options_t *ooptsp;
status_$t *stp;
{
	v2_handle_t *dhp, *hp;
	name_$long_pname_t name;
	short namelen;
	uid_$t tuid;

	dhp = *hpp;
	sprintf(name, "%s/%.*s", dhp->name, *resid_lenp, resid);
	namelen = strlen(name);

	v2_open(&(dhp->xoid), name, namelen, ios_$preserve_mode,
	        *ooptsp, &uid_$nil, &hp, &tuid, stp);

	if (stp->all != status_$ok)
		return;

	return ios_$connect_xoid(hp->xoid, name, namelen, true, tuid, hp, &v2_$io_epv, *stp);
}

v2_dir_$add(hpp, leaf, leaflenp, stridp, stp)
v2_handle_t **hpp;
char *leaf;
short *leaflenp;
ios_$id_t *stridp;
status_$t *stp;
{
	v2_handle_t *hp, *fhp;
	name_$long_pname_t name;
	int n;

	hp = *hpp;
	sprintf(name, "%s/%.*s", hp->name, *leaflenp, leaf);
	fhp = (v2_handle_t *) ios_$get_handle(*stridp, v2f_$uid, *stp);
	if (stp->all != status_$ok)
		return;

	putlong(C_LINK);

	n = strlen(fhp->name);
	putlong(n);
	putbytes(fhp->name, n);

	n = strlen(name);
	putlong(n);
	putbytes(name, n);

	stp->all = v2_tr_errno(getlong());
}

v2_dir_$drop(hpp, leaf, leaflenp, stp)
v2_handle_t **hpp;
char *leaf;
short *leaflenp;
status_$t *stp;
{
	v2_handle_t *hp;
	name_$long_pname_t name;
	int n;

	hp = *hpp;
	sprintf(name, "%s/%.*s", hp->name, *leaflenp, leaf);

	putlong(C_UNLINK);
	n = strlen(name);
	putlong(n);
	putbytes(name, n);

	stp->all = v2_tr_errno(getlong());
}

v2_dir_$add_symlink(hpp, leaf, leaflenp, lt, ltlenp, stp)
v2_handle_t **hpp;
char *leaf, *lt;
short *leaflenp, *ltlenp;
status_$t *stp;
{
	v2_handle_t *hp;
	name_$long_pname_t name;
	int n;

	hp = *hpp;
	sprintf(name, "%s/%.*s", hp->name, *leaflenp, leaf);

	putlong(C_SLINK);
	putlong(*ltlenp);
	putbytes(lt, *ltlenp);
	n = strlen(name);
	putlong(n);
	putbytes(name, n);

	stp->all = v2_tr_errno(getlong());
}

v2_dir_$inq_symlink(hpp, leaf, leaflenp, lt, ltlenp, stp)
v2_handle_t **hpp;
char *leaf, *lt;
short *leaflenp, *ltlenp;
status_$t *stp;
{
	v2_handle_t *hp;
	name_$long_pname_t name;
	int n;

	hp = *hpp;
	sprintf(name, "%s/%.*s", hp->name, *leaflenp, leaf);

	putlong(C_READLINK);
	n = strlen(name);
	putlong(n);
	putbytes(name, n);

	if ((n = getlong()) < 0) {
		stp->all = v2_tr_errno(n);
		/* Domain/OS returns ENXIO for "not a link" */
		if (stp->all == 0x90c0006)
			stp->all = ios_$illegal_operation;
		return;
	}
	if (read(hp->sock_fd, lt, n) != n) {
		stp->all = ios_$end_of_file;	/* That'll confuse 'em */
		return;
	}
	*ltlenp = n;
	stp->all = status_$ok;
}

boolean
v2_dir_$read(hpp, maxcntp, bufsizep, bp, readcntp, stp)
v2_handle_t **hpp;
long *maxcntp, *bufsizep, *readcntp;
char *bp;
status_$t *stp;
{
	v2_handle_t *hp = *hpp;
	int n, i;

	putlong(C_READDIR);
	putlong(*maxcntp);
	putlong(*bufsizep);

	*readcntp = 0;

	/* No conversion to host order here.  This assumes that host order
	   is the same as net order, currently true for Apollo/TCP */

	for (;;) {
		n = getlong();
		if (n < 0) {
			stp->all = v2_tr_errno(n);
			return false;
		}
		if (n <= 1)
			break;
		if ((i = getbytes(bp, n)) < 0) {
			stp->all = v2_tr_errno(i);
			return false;
		}
		bp += i;
		(*readcntp)++;
	}

	stp->all = (*readcntp > 0) ? status_$ok : ios_$end_of_file;
	return ((n != 1) ? true : false);
}

static long
dseek(hp, key, how, stp)
v2_handle_t *hp;
long key;
int how;
status_$t *stp;
{
	stp->all = status_$ok;
	putlong(C_SEEK);
	putlong(key);
	putlong(how);
	return getlong();
}

long
v2_dir_$telldir(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	return dseek(*hpp, 0L, 1, stp);
}

v2_dir_$seekdir(hpp, keyp, stp)
v2_handle_t **hpp;
long *keyp;
status_$t *stp;
{
	dseek(*hpp, *keyp, 0, stp);
}

v2_dir_$rewinddir(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	dseek(*hpp, 0L, 0, stp);
}
