#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/ec2.ins.c"
#include "/sys/ins/cal.ins.c"

#include "v2.h"
#include "v2d.h"

#define decade_1970 (3652 * 24 * 3600)

v2_$stat(hp, atp)
v2_handle_t *hp;
struct attr *atp;
{
	if (!(hp->a_cache_valid)) {
		putlong(C_FSTAT);
		if (read(hp->sock_fd, &(hp->a_cache), sizeof (struct attr)) < 0)
			return -1;
		hp->a_cache_valid = true;
	}
	*atp = hp->a_cache;
	return 0;
}

v2_$get_ec(hpp, keyp, ecpp, stp)
v2_handle_t **hpp;
ios_$ec_key_t *keyp;
ec2_$ptr_t *ecpp;
status_$t *stp;
{
	*ecpp = (ec2_$ptr_t) ec2_$always_ready_ec;
	stp->all = status_$ok;
}

ios_$rtype_t
v2_$inq_rec_type(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	stp->all = status_$ok;
	return ios_$undef;
}

v2_$set_rec_type(hpp, rtp, rlp, stp)
v2_handle_t **hpp;
ios_$rtype_t *rtp;
long *rlp;
status_$t *stp;
{
	if (*rtp == ios_$undef)
		stp->all = status_$ok;
	else
		stp->all = ios_$illegal_operation;
}

v2_$inq_file_attr(hpp, dtcp, dtmp, dtup, blksp, stp)
v2_handle_t **hpp;
time_$clockh_t *dtcp, *dtmp, *dtup;
long *blksp;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr atb;
	time_$clock_t clock;

	stp->all = status_$ok;
	hp = *hpp;

	if (v2_$stat(hp, &atb) < 0) {
		stp->all = ios_$illegal_operation;
		return;
	}
	cal_$sec_to_clock(atb.atime - decade_1970, clock);
	*dtup = clock.high;
	cal_$sec_to_clock(atb.mtime - decade_1970, clock);
	*dtcp = *dtmp = clock.high;
	*blksp = atb.blocks;
}
