#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "prot.ins.c"

#include "v2.h"
#include "v2d.h"

#define ALL_USERS	(prot_$user_owner_mask | prot_$user_project_mask | prot_$user_world_mask)

extern unsigned short unix_fio_$rts_vec_to_mode();
extern prot_$user_class_set_t unix_fio_$mode_to_rts_vec();
extern std_$call boolean unix_uid_$unix_id_to_uid();
extern std_$call long unix_uid_$uid_to_unix_id();

v2_$set_rights(hpp, rts_vec, u_classp, stp)
v2_handle_t **hpp;
prot_$rights_vec_t rts_vec;
prot_$user_class_set_t *u_classp;
status_$t *stp;
{
	v2_handle_t *hp = *hpp;
	struct attr at;
	int mode;
	prot_$rights_vec_t old_rts_vec, new_rts_vec;

	if ((*u_classp & ALL_USERS) != ALL_USERS) {
		if (v2_$stat(hp, &at) < 0) {
			stp->all = v2_tr_errno(-1);
			return;
		}
		mode = at.mode;
	} else
		mode = 0;
	unix_fio_$mode_to_rts_vec(mode, old_rts_vec);

	new_rts_vec[(int) prot_$user_owner] = (*u_classp & prot_$user_owner_mask) ?
	    rts_vec[(int) prot_$user_owner] : old_rts_vec[(int) prot_$user_owner];

	new_rts_vec[(int) prot_$user_project] = (*u_classp & prot_$user_project_mask) ?
	    rts_vec[(int) prot_$user_project] : old_rts_vec[(int) prot_$user_project];

	new_rts_vec[(int) prot_$user_world] = (*u_classp & prot_$user_world_mask) ?
	    rts_vec[(int) prot_$user_world] : old_rts_vec[(int) prot_$user_world];

	mode = unix_fio_$rts_vec_to_mode(new_rts_vec, ALL_USERS);

	hp->a_cache_valid = false;
	putlong(C_CHMOD);
	putlong(mode);
	stp->all = v2_tr_errno(getlong());
}

v2_$inq_rights(hpp, rts_vec, u_classp, stp)
v2_handle_t **hpp;
prot_$rights_vec_t rts_vec;
prot_$user_class_set_t *u_classp;
status_$t *stp;
{
	v2_handle_t *hp = *hpp;
	struct attr at;

	if (v2_$stat(hp, &at) < 0) {
		stp->all = v2_tr_errno(-1);
		return;
	}

	*u_classp = unix_fio_$mode_to_rts_vec(at.mode, rts_vec);
	stp->all = status_$ok;
}

v2_$set_user_class_ids(hpp, u_classp, id_vec, stp)
v2_handle_t **hpp;
prot_$user_class_set_t *u_classp;
prot_$user_class_id_vec_t id_vec;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr at;
	int uid, gid;

	hp = *hpp;

	if (*u_classp & prot_$user_owner_mask)
		uid = unix_uid_$uid_to_unix_id(id_vec[(int) prot_$user_owner], false);
	else
		uid = -1;
	if (*u_classp & prot_$user_project_mask)
		gid = unix_uid_$uid_to_unix_id(id_vec[(int) prot_$user_project], true);
	else
		gid = -1;
	if ((uid < 0 || gid < 0) && v2_$stat(hp, &at) < 0) {
		stp->all = v2_tr_errno(-1);
		return;
	}
	if (uid < 0)
		uid = at.uid;
	if (gid < 0)
		gid = at.gid;

	hp->a_cache_valid = false;
	putlong(C_CHOWN);
	putlong(uid);
	putlong(gid);
	stp->all = v2_tr_errno(getlong());
}

v2_$inq_user_class_ids(hpp, u_classp, id_vec, stp)
v2_handle_t **hpp;
prot_$user_class_set_t *u_classp;
prot_$user_class_id_vec_t id_vec;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr at;

	hp = *hpp;

	if (v2_$stat(hp, &at) < 0) {
		stp->all = v2_tr_errno(-1);
		return;
	}
	*u_classp = 0;
	if (unix_uid_$unix_id_to_uid(at.uid, false, id_vec[(int) prot_$user_owner]))
		*u_classp |= prot_$user_owner_mask;
	if (unix_uid_$unix_id_to_uid(at.gid, true, id_vec[(int) prot_$user_project]))
		*u_classp |= prot_$user_project_mask;
	stp->all = status_$ok;
}
