/* Commands */
#define C_OPEN		1
#define C_CLOSE		2
#define C_READ		3
#define C_WRITE		4
#define C_OSTAT		5
#define C_OFSTAT	6
#define C_SEEK		7
#define C_CHN		8
#define C_UNLINK	9
#define C_RDLN		10
#define C_MKDIR		11
#define C_TRUNC		12
#define C_CHMOD		13
#define C_CHOWN		14
#define C_LINK		15
#define C_SLINK		16
#define C_READLINK	17
#define C_STAT		18
#define C_FSTAT		19
#define C_UTIME		20
#define C_READDIR	21

/* File types */
#define T_TYPE		0xf
#define T_FILE		0x1
#define T_DIR		0x2

#define T_RW		0xf0
#define T_RO		0x10

/* substitutes for O_ flags (they may be different on the remote machine) */
#define XO_CREAT	0x100
#define XO_TRUNC	0x200
#define XO_APPEND	0x8
#define XO_EXCL		0x400

#define ODNL 32
#define ODIRSIZE (sizeof (struct odirect))

struct odirect {
	short	d_type;		/* 1=file, 3=link */
	short	d_len;		/* non-blank chars in name */
	char	d_name[ODNL];	/* name text */
	long	d_ino;		/* "i-node" # */
	long	d_key;		/* seek key */
};

/* This must match ios_dir_$canonical_dir_entry_t in /sys/ins/ios_dir.ins.c */

struct cdirect {
	short	cd_next;
	short	cd_type;
	long	cd_rfu1, cd_rfu2, cd_rfu3;
	long	cd_handle;
	short	cd_namelen;
	char	cd_name[2];
};
