#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/cal.ins.c"
#include "attr.ins.c"

#include "v2.h"
#include "v2d.h"

extern std_$call boolean unix_time_$timeval_to_clock();
extern std_$call boolean unix_time_$clock_to_timeval();

v2_$inq_ref_count(hpp, countp, stp)
v2_handle_t **hpp;
long *countp;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr atb;

	stp->all = status_$ok;
	hp = *hpp;

	if (v2_$stat(hp, &atb) < 0) {
		stp->all = ios_$illegal_operation;
		return;
	}
	*countp = atb.nlink;
}

v2_$inq_blocks(hpp, blk_countp, blk_sizep, stp)
v2_handle_t **hpp;
long *blk_sizep;
long *blk_countp;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr atb;

	stp->all = status_$ok;
	hp = *hpp;

	if (v2_$stat(hp, &atb) < 0) {
		stp->all = ios_$illegal_operation;
		return;
	}
	*blk_sizep = atb.blksize;
	*blk_countp = atb.blocks;
}

v2_$inq_time(hpp, time_typep, timep, stp)
v2_handle_t **hpp;
attr_$time_type_t *time_typep;
time_$clock_t *timep;
status_$t *stp;
{
	v2_handle_t *hp;
	struct attr atb;
	struct timeval tv;

	stp->all = status_$ok;
	hp = *hpp;

	if (v2_$stat(hp, &atb) < 0) {
		stp->all = ios_$illegal_operation;
		return;
	}
	switch (*time_typep) {
	case attr_$time_create:
	case attr_$time_modify:
		tv.tv_sec = atb.mtime;
		break;
	case attr_$time_access:
		tv.tv_sec = atb.atime;
		break;
	case attr_$time_attr_modify:
		tv.tv_sec = atb.ctime;
		break;
	default:
		stp->all = ios_$illegal_param_comb;
		return;
	}
	tv.tv_usec = 0;
	unix_time_$timeval_to_clock(time_$absolute, tv, *timep);
}

/*
   set_time cheats a bit.  I happen to know that utimes() always sets atime
   first, then immediately sets mtime.  So when atime gets set, I just remember
   it in a_cache, and don't actually remote the operation until the mtime
   gets set.
*/

v2_$set_time(hpp, time_typep, timep, stp)
v2_handle_t **hpp;
attr_$time_type_t *time_typep;
time_$clock_t *timep;
status_$t *stp;
{
	v2_handle_t *hp;
	struct timeval tv;
	int n, e;

	stp->all = status_$ok;
	hp = *hpp;

	unix_time_$clock_to_timeval(time_$absolute, *timep, tv);

	switch (*time_typep) {
	case attr_$time_modify:
		hp->a_cache.mtime = tv.tv_sec;
		putlong(C_UTIME);
		n = strlen(hp->name);
		putlong(n);
		putbytes(hp->name, n);
		putlong(hp->a_cache.atime);
		putlong(hp->a_cache.mtime);
		if ((e = getlong()) < 0)
			stp->all = v2_tr_errno(e);
		break;

	case attr_$time_access:
		hp->a_cache.atime = tv.tv_sec;
		break;

	case attr_$time_attr_modify:
	case attr_$time_create:
	default:
		stp->all = ios_$illegal_operation;
		return;
	}
}
