/*
 * Copyright Jim Rees, September 2004
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "as-is" and without warranty.
 */

#include <sys/types.h>
#include <stdio.h>

struct {
    unsigned int keysym;
    char *keydef;
} keydefs[] = {
    {0x0ff08, "ee"},		/* BackSpace */
    {0x0ff09, "es' ';al;so/ /@t/ar"}, /* Tab */
    {0x1fe20, "ts 5 -r; th; ts 9 -r;"}, /* shift-Tab */
    {0x4ff09, "ts 5 -r; thl; ts 9 -r;"}, /* ctl-Tab */
    {0x0ff0d, "en"},		/* Return */
    {0x0ff1b, ""},		/* Escape */
    {0x0ff63, "ei"},		/* Insert */
    {0x0ffff, "cms;tl;xd line_del"}, /* Delete */
    {0x1ffff, "xp line_del"},	/* shift-Delete */
    {0x0ff50, "tl"},		/* Home */
    {0x1ff50, "ph -16"},	/* shift-Home */
    {0x0ff57, "tr"},		/* End */
    {0x1ff57, "ph 16"},		/* shift-End */
    {0x0ff55, "pp -.45"},	/* Page Up */
    {0x1ff55, "tt"},		/* shift-Page Up */
    {0x0ff56, "pp .45"},	/* Page Down */
    {0x1ff56, "tb"},		/* shift-Page Down */
    {0x0ff51, "al"},		/* Left */
    {0x1ff51, "ph -1"},		/* shift-Left */
    {0x0ff52, "au"},		/* Up */
    {0x1ff52, "pv -1"},		/* shift-Up */
    {0x0ff53, "ar"},		/* Right */
    {0x1ff53, "ph 1"},		/* shift-Right */
    {0x0ff54, "ad"},		/* Down */
    {0x0ff61, "tn"},		/* SysRq/PrintScreen */
    {0x1ff61, "&'Command: '"},
    {0x0ffbe, "tr;en;tl"},	/* F1 */
    {0x0ffc1, "/&'Search for: '/"},	/* F4 */
    {0x0ffc3, "/[~a-zA-Z._@-$0-9@/@\\~]/dr;\\[~a-zA-Z._@-$0-9@/@\\~`]\\;/?/xc again;ti;tb;tr;xp again;tr;es ' '"}, /* F6 */
    {0x1ffc3, "/[~a-zA-Z._@-$0-9@/@\\@[@]~]/dr;\\[~a-zA-Z._@-$0-9@/@\\@[@]~`]\\;/?/xc"}, /* F6S */
    {0x0ffc4, "es ' ';ee;dr;tr;xd;tl;tr"}, /* F7 */
    {0x0ffc5, "dr;tr;xc;tl;ti;tb;tr;xp;tr"}, /* F8 */
    {0x0ff8d, "wp;ti;tb;tr"},	/* KP_Enter (pop) */
    {0x0ff8d, "wp"},		/* shift-KP_Enter (pop) */
    {0x0ff95, "dr;tr;xc again;tl;ti;tb;tr;xp again;tr"},
    {0x0ffaf, "cv '&'Read file: ''"},
    {0x1ffaf, "/[~a-zA-Z._@-$0-9@/@\\@[@]~]/dr;\\[~a-zA-Z._@-$0-9@/@\\@[@]~`]\\;/?/xc cv_file;tdm;tl;xd junk;es 'cv @'';xp cv_file;tr;ph 1;es '@'';en"},
    {0x0ffaa, "ce '&'Edit file: ''"},
    {0x1ffaa, "/[~a-zA-Z._@-$0-9@/@\\~]/dr;\\[~a-zA-Z._@-$0-9@/@\\~`]\\;/?/xc cv_file;tdm;tl;xd junk;es 'ce @'';xp cv_file;tr;ph 1;es '@'';en"},
    {0x0ffad, "pw;wc -q"},
    {0x1ffad, "wc -q"},
    {0x0ffab, "wh"},
    {0x1ffab, "cv /sys/help/&'Help on: '.hlp"},
    {0x40061, "wa;ws"},
    {0x40062, "pb;tb;tr"},
    {0x40063, "dq -i"},
    {0x40064, "eef"},
    {0x40065, "xd"},
    {0x40066, "rs"},
    {0x40067, "abrt"},
    {0x4006b, "ad;tl"},
    {0x4006c, "rs"},
    {0x4006d, "ro"},
    {0x4006e, "wc -q"},
    {0x4006f, "xp"},
    {0x40070, "wp"},
    {0x40071, "dq"},
    {0x40072, "//"},
    {0x40073, "ws"},
    {0x40074, "pt;tt;tl"},
    {0x40075, "\\\\"},
    {0x40076, "au;au;pb;ti"},
    {0x40077, "pw"},
    {0x40078, "abrt"},
    {0x40079, "pw;wc -q"},
    {0x4007a, "dq -c 120028"},
    {0x4005c, "dq -c 9010003"},
    {0, NULL}
};

u_char monotab[256][8] = {
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
};

u_char stipple[] = {
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
    0xdd, 0xdd, 0x77, 0x77,
};
