/* which_font.c */
#include <apollo/base.h>
#include <apollo/pad.h>
#include <stdio.h>
#include <strings.h>
#define  errmsg( text, parm ) fprintf( stderr, "?(which_font) %s%s\n", text, parm )
#define BUFF_LEN name_$long_pnamlen_max

main(){
    status_$t status;
    short font_width, font_height, pname_len;
    char font_pathname[BUFF_LEN+1];
    char *here;

    /* check in case stdin was redirected
     */
    pad_$isa( ios_$stdin, &status );
    if( status.all == pad_$stream_not_pad ){
        errmsg( "Standard input is not a pad.", "" );
        exit( 1 );
    }

    /* inquire about the font
     */
    pad_$inq_font( ios_$stdin,
                   &font_width, &font_height, font_pathname, BUFF_LEN, &pname_len,
                   &status );
                if( status.all ) pfm_$error_trap( status );
    font_pathname[pname_len] = 0;

    /* format the output
     */
    if( here = rindex( font_pathname, '/' ) ){
        puts( here + 1 );
        exit( 0 );
    }
    else{
        errmsg( "Incomprehensible font: ", font_pathname );
        exit( 2 );
    }
}
