#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include "DrawP.h"

static void expose(), resize(), jackson(), destroy();
static void Initialize();
static Boolean SetValues();

static char defaultTranslations[] = "\
    <KeyDown>:		keydown() \n\
    <KeyUp>:		keyup() \n\
    <ButtonPress>:	buttonpress() \n\
    <ButtonRelease>:	buttonrelease() \n\
    <MotionNotify>:	motion() \n\
";

static XtActionsRec actionsList[] = {
    { "keydown",	(XtActionProc) jackson	},
    { "keyup",		(XtActionProc) jackson	},
    { "buttonpress",	(XtActionProc) jackson	},
    { "buttonrelease",	(XtActionProc) jackson	},
    { "motion",		(XtActionProc) jackson	},
};

static XtResource resources[] = {
    {XtNexpose, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.expose), XtRPointer, NULL},
    {XtNresize, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.resize), XtRPointer, NULL},
    {XtNcallback, XtCCallback, XtRCallback, sizeof (caddr_t),
	XtOffset(DrawWidget, draw.jackson), XtRPointer, NULL},
};

DrawClassRec drawClassRec = {
    {
    /* superclass	  	*/	(WidgetClass) &simpleClassRec,
    /* class_name	  	*/	"Draw",
    /* widget_size	  	*/	sizeof(DrawRec),
    /* class_initialize   	*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	XtInheritRealize,
    /* actions		  	*/	actionsList,
    /* num_actions	  	*/	XtNumber(actionsList),
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	FALSE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	(XtWidgetProc) destroy,
    /* resize		  	*/	(XtWidgetProc) resize,
    /* expose		  	*/	(XtExposeProc) expose,
    /* set_values	  	*/	(XtSetValuesFunc) SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	defaultTranslations,
    /* query_geometry		*/	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  }
};

WidgetClass drawWidgetClass = (WidgetClass) &drawClassRec;

static void Initialize(request, new)
Widget request, new;
{
    if (new->core.width == 0)
	new->core.width = 100;
    if (new->core.height == 0)
	new->core.height = 100;
    (*XtClass(new)->core_class.resize) (new);
}

static void
expose(w)
Widget w;
{
    XtCallCallbacks (w, XtNexpose, NULL);
}

static void
resize(w)
Widget w;
{
    XtCallCallbacks (w, XtNresize, NULL);
}

static void
jackson(w, ev, parms, nparms)
Widget w;
XEvent *ev;
String *parms;
Cardinal *nparms;
{
    XtCallCallbacks (w, XtNcallback, ev);
}

static Boolean
SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
    return False;
}

static void
destroy(w)
Widget w;
{
    XtRemoveAllCallbacks (w, XtNexpose);
    XtRemoveAllCallbacks (w, XtNresize);
    XtRemoveAllCallbacks (w, XtNcallback);
}
