#!/bin/sh
PATH="/bin:/usr/bin:/usr/etc"
export PATH

# @(#)4.1.1secure.sh 1.8 patchid 100103-12  93/04/27
#
#	Name:		4.1.1secure.sh
#
DESCRIPTION=" 4.1secure.sh:
 Tune attributes on file system objects."
#
#			Tune attributes on file system objects
#		This script is intended to set file system object permissions
#		to the values generated during the build process. And in
#               many cases a more secure mode.
#

set -eu

echo "$DESCRIPTION"


#
# Figure out what type of system we are running on.
#
if [ -f /etc/install/sys_info ] ; then
	sys_type=`sed -n 's/^sys_type=\(.*\)$/\1/p' /etc/install/sys_info`
else
	usr=`mount | sed -n 's/^\(.\).* on \/usr .*$/\1/p'`
	[ "$usr" != "/" ] && sys_type=dataless	# /usr is R/O
	root=`mount | sed -n 's/^\(.\).* on \/ .*$/\1/p'`
	[ "$root" != "/" ] && sys_type=diskless	# /usr is R/O
fi

echo
echo "Running on a $sys_type system."
if [ "$sys_type" = server ] ; then
	clients=`cat /etc/install/client_list.*`
	echo "Serving the following clients:"
	i=0
	for client in $clients; do
		i=`expr $i + 1`
		echo "$i: $client"
	done
	[ $i = 0 ] && echo "(none installed)"
fi
echo




echo "Setting attributes on the following file system objects:"

set_attr() {
	while read file mode user group type x; do
		#
		# If the object does not exist on this system or
		# is not writable then skip it.
		#
		[ ! -d "$file" -a ! -f "$file" ] && continue

		echo -n "	$file"

		[ ! -w "$file" ] && { echo " <======== not writable"; continue;}

		#
		# If the object is a symbolic link then do not chmod(1) it.
		#
		if [ "$type" != "symlink" ]; then
			chmod "$mode" "$file"
			#
			#	If the mode has the setgid bit set, then use
			#	symbolic mode to set it.
			#
			if [ "`echo $mode | cut -c2`" = "2" ]; then
				chmod g+s "$file"
			fi

			echo -n " (mode)"
		fi
		chown "$user.$group" "$file"
		echo " (ownership)"
	done
}




###
### Place only files residing in the / (root) filesystem in the list below.
### Do NOT place files residing in /usr, /usr/kvm, or /usr/share here.
### Place those files in one of the other lists.
###
client_dirs=""		# Root filesystem(s)
[ -d /export/root ] && client_dirs=`ls -d /export/root/*`
while read file mode user group type x; do
	echo $file $mode $user $group $type | set_attr
	for client_dir in $client_dirs; do
		echo $client_dir$file $mode $user $group $type | set_attr
	done
done << EOF_ROOT
/ 02755 root staff directory
/bin 00777 root staff symlink
/dev 02755 root staff directory
/dev/fd0 00600 root staff file
/dev/fd0a 00600 root staff file
/dev/fd0b 00600 root staff file
/dev/fd0c 00600 root staff file
/dev/rfd0 00600 root staff file
/dev/rfd0a 00600 root staff file
/dev/rfd0b 00600 root staff file
/dev/rfd0c 00600 root staff file
/etc 02755 root staff directory
/etc/adm 00777 root staff symlink
/etc/aliases.dir 00644 root staff file
/etc/aliases.pag 00644 root staff file
/etc/arp 00777 root staff symlink
/etc/chown 00777 root staff symlink
/etc/chroot 00777 root staff symlink
/etc/clri 00777 root staff symlink
/etc/config 00777 root staff symlink
/etc/crash 00777 root staff symlink
/etc/cron 00777 root staff symlink
/etc/dkinfo 00777 root staff symlink
/etc/dmesg 00777 root staff symlink
/etc/dump 00777 root staff symlink
/etc/fastboot 00777 root staff symlink
/etc/fasthalt 00777 root staff symlink
/etc/fsck 00777 root staff symlink
/etc/fuser 00777 root staff symlink
/etc/halt 00777 root staff symlink
/etc/ifconfig 00777 root staff symlink
/etc/install/EXCLUDELIST 00644 root staff file
/etc/install/category.standalone 00644 root staff file
/etc/install/default_client_info 00644 root staff file
/etc/install/default_sys_info 00644 root staff file
/etc/link 00777 root staff symlink
/etc/mkfs 00777 root staff symlink
/etc/mknod 00777 root staff symlink
/etc/motd 00644 root staff file
/etc/mount 00777 root staff symlink
/etc/mount_rfs 00777 root staff symlink
/etc/mtab 00644 root staff file
/etc/ncheck 00777 root staff symlink
/etc/newfs 00777 root staff symlink
/etc/pstat 00777 root staff symlink
/etc/rdump 00777 root staff symlink
/etc/reboot 00777 root staff symlink
/etc/remote 00644 root staff file
/etc/renice 00777 root staff symlink
/etc/restore 00777 root staff symlink
/etc/rmt 00777 root staff symlink
/etc/rrestore 00777 root staff symlink
/etc/shutdown 00777 root staff symlink
/etc/sm 00755 root staff directory
/etc/sm.bak 00755 root staff directory
/etc/spool 00777 root staff symlink
/etc/state 00644 root staff file
/etc/termcap 00777 root staff symlink
/etc/tmp 00777 root staff symlink
/etc/umount 00777 root staff symlink
/etc/unlink 00777 root staff symlink
/etc/update 00777 root staff symlink
/etc/vipw 00777 root staff symlink
/home 02755 bin staff directory
/lib 00777 root staff symlink
/mnt 02755 root staff directory
/sbin 02755 root staff directory
/sys 00777 root staff symlink
/tmp 03777 root staff directory
/var 02755 root staff directory
/var/adm 02755 root staff directory
/var/adm/acct/fiscal 02755 root staff directory
/var/adm/acct/nite 02755 root staff directory
/var/adm/acct/sum 02755 root staff directory
/var/log 02755 root staff directory
/var/spool 02755 root staff directory
/var/tmp 03777 root staff directory
/var/yp 02755 root staff directory
/var/yp/binding 02755 root staff directory
/var/yp/`domainname`/mail.aliases.dir 00644 root staff file
/var/yp/`domainname`/mail.aliases.pag 00644 root staff file
EOF_ROOT




#
# The rest is for server and standalone systems only.
#
[ "$sys_type" != diskless -a "$sys_type" != dataless ] || exit 0


###
### Place only files residing in the /usr filesystem in the list below.
### Do NOT place files residing in / (root), /usr/kvm, or /usr/share here.
### Place those files in one of the other lists.
###
client_dirs=""		# /usr filesystem(s)
if [ -d /export/exec ] ; then
	dirs=`ls -d /export/exec/sun*.sunos.4.*`
	for dir in $dirs ; do
		x=`file $dir | sed -n 's/^.* \(.*\)$/\1/p'`
		[ "$x" != /usr ] && client_dirs="$client_dirs $dir"
	done
fi
while read file mode user group type x; do
	echo $file $mode $user $group $type | set_attr
	client_file=`echo $file | sed -n 's/^\/usr\(.*\)$/\1/p'`
	for client_dir in $client_dirs; do
		echo $client_dir$client_file $mode $user $group $type | set_attr
	done
done << EOF_USR
/usr/ 02755 root staff directory
/usr/5bin 02755 root staff directory
/usr/5include 02755 root staff directory
/usr/5include/sys 02755 root staff directory
/usr/5lib 02755 root staff directory
/usr/5lib/lint 02755 root staff directory
/usr/5lib/lint/llib-lansic 00644 root staff file
/usr/5lib/lint/llib-lansic.ln 00644 root staff file
/usr/5lib/lint/llib-lc 00644 root staff file
/usr/5lib/lint/llib-lc.ln 00644 root staff file
/usr/5lib/lint/llib-lcurses 00644 root staff file
/usr/5lib/lint/llib-lcurses.ln 00644 root staff file
/usr/5lib/lint/llib-lposix 00644 root staff file
/usr/5lib/lint/llib-lposix.ln 00644 root staff file
/usr/5lib/lint/llib-lsvid89 00644 root staff file
/usr/5lib/lint/llib-lsvid89.ln 00644 root staff file
/usr/5lib/lint/llib-lsvidii 00644 root staff file
/usr/5lib/lint/llib-lsvidii-3 00644 root staff file
/usr/5lib/lint/llib-lsvidii-3.ln 00644 root staff file
/usr/5lib/lint/llib-lsvidii.ln 00644 root staff file
/usr/5lib/lint/llib-ltermcap 00644 root staff file
/usr/5lib/lint/llib-ltermcap.ln 00644 root staff file
/usr/5lib/lint/llib-lxopen 00644 root staff file
/usr/5lib/lint/llib-lxopen.ln 00644 root staff file
/usr/5lib/lint/llib-lxpg2 00644 root staff file
/usr/5lib/lint/llib-lxpg2.ln 00644 root staff file
/usr/adm 00777 root staff symlink
/usr/bin 02755 root staff directory
/usr/bin/sunview1 02755 root staff directory
/usr/bin/uudecode 00755 root staff file
/usr/bin/uuencode 00755 root staff file
/usr/boot 00777 root staff symlink
/usr/demo 02755 root staff directory
/usr/diag 02755 root staff directory
/usr/diag/sundiag 02755 root staff directory
/usr/dict 02755 root staff directory
/usr/dict/papers 02755 root staff directory
/usr/etc 02755 root staff directory
/usr/etc/restore 00750 root staff file
/usr/etc/yp 02755 root staff directory
/usr/games 02755 root staff directory
/usr/games/chesstool 00755 bin staff file
/usr/hosts 02755 root staff directory
/usr/include 02755 root staff directory
/usr/include/arpa 02755 root staff directory
/usr/include/debug 02755 root staff directory
/usr/include/hsfs 02755 root staff directory
/usr/include/images 02755 root staff directory
/usr/include/lofs 02755 root staff directory
/usr/include/lwp 02755 root staff directory
/usr/include/m68k 02755 root staff directory
/usr/include/mon 02755 root staff directory
/usr/include/net 02755 root staff directory
/usr/include/netinet 02755 root staff directory
/usr/include/nfs 02755 root staff directory
/usr/include/pascal 02755 root staff directory
/usr/include/pcfs 02755 root staff directory
/usr/include/pixrect 02755 root staff directory
/usr/include/protocols 02755 root staff directory
/usr/include/rpc 02755 root staff directory
/usr/include/rpcsvc 02755 root staff directory
/usr/include/sbusdev 02755 root staff directory
/usr/include/sparc 02755 root staff directory
/usr/include/specfs 02755 root staff directory
/usr/include/stand 02755 root staff directory
/usr/include/sun 02755 root staff directory
/usr/include/sun3 02755 root staff directory
/usr/include/sun3x 02755 root staff directory
/usr/include/sun4 02755 root staff directory
/usr/include/sun4c 02755 root staff directory
/usr/include/sundev 02755 root staff directory
/usr/include/sunif 02755 root staff directory
/usr/include/suntool 02755 root staff directory
/usr/include/sunwindow 02755 root staff directory
/usr/include/sunwindowdev 02755 root staff directory
/usr/include/sys 02755 root staff directory
/usr/include/tfs 02755 root staff directory
/usr/include/tmpfs 02755 root staff directory
/usr/include/ufs 02755 root staff directory
/usr/include/vm 02755 root staff directory
/usr/include/xgl 02755 root staff directory
/usr/lib 02755 root bin directory
/usr/lib/.sunview 00777 root bin symlink
/usr/lib/acct 02755 root bin directory
/usr/lib/adb 02755 root bin directory
/usr/lib/ctrace 02755 root bin directory
/usr/lib/defaults 02755 root bin directory
/usr/lib/find 02755 root staff directory
/usr/lib/font 02755 root staff directory
/usr/lib/fontinfo 02755 root staff directory
/usr/lib/fonts 02755 root staff directory
/usr/lib/fonts/fixedwidthfonts 02755 root staff directory
/usr/lib/fonts/tekfonts 02755 root staff directory
/usr/lib/lex 00777 root bin symlink
/usr/lib/lint 02755 root staff directory
/usr/lib/lint/llib-l4.3bsd 00644 root staff file
/usr/lib/lint/llib-l4.3bsd.ln 00644 root staff file
/usr/lib/lint/llib-lbsd 00644 root staff file
/usr/lib/lint/llib-lbsd.ln 00644 root staff file
/usr/lib/lint/llib-lc 00644 root staff file
/usr/lib/lint/llib-lc.ln 00644 root staff file
/usr/lib/lint/llib-lcore 00644 root staff file
/usr/lib/lint/llib-lcore.ln 00644 root staff file
/usr/lib/lint/llib-lcurses 00644 root staff file
/usr/lib/lint/llib-lcurses.ln 00644 root staff file
/usr/lib/lint/llib-lkvm 00644 root staff file
/usr/lib/lint/llib-lkvm.ln 00644 root staff file
/usr/lib/lint/llib-llwp 00644 root staff file
/usr/lib/lint/llib-llwp.ln 00644 root staff file
/usr/lib/lint/llib-lm 00644 root staff file
/usr/lib/lint/llib-lm.ln 00644 root staff file
/usr/lib/lint/llib-lmp 00644 root staff file
/usr/lib/lint/llib-lmp.ln 00644 root staff file
/usr/lib/lint/llib-lpixrect 00644 root staff file
/usr/lib/lint/llib-lpixrect.ln 00644 root staff file
/usr/lib/lint/llib-lplot 00644 root staff file
/usr/lib/lint/llib-lplot.ln 00644 root staff file
/usr/lib/lint/llib-lsuntool 00644 root staff file
/usr/lib/lint/llib-lsuntool.ln 00644 root staff file
/usr/lib/lint/llib-lsunwindow 00644 root staff file
/usr/lib/lint/llib-lsunwindow.ln 00644 root staff file
/usr/lib/lint/llib-ltermcap 00644 root staff file
/usr/lib/lint/llib-ltermcap.ln 00644 root staff file
/usr/lib/lint/llib-port 00644 root staff file
/usr/lib/lint/llib-port.ln 00644 root staff file
/usr/lib/refer 02755 root bin directory
/usr/lib/rootmenu 00777 root bin symlink
/usr/lib/rootmenu.old 00777 root bin symlink
/usr/lib/shlib.etc 02755 root staff directory
/usr/lib/spell 02755 root staff directory
/usr/lib/suntools 00777 root bin symlink
/usr/lib/tabset 00777 root bin symlink
/usr/lib/text_extras_menu 00777 root bin symlink
/usr/lib/textswrc 00777 root bin symlink
/usr/lib/xglfonts 02755 root staff directory
/usr/lib/xglfonts/stroke 02755 root staff directory
/usr/lib/zoneinfo 00777 root bin symlink
/usr/local 02755 root staff directory
/usr/man 00777 root staff symlink
/usr/mdec 00777 root staff symlink
/usr/net 00777 root staff symlink
/usr/nserve 00777 root staff symlink
/usr/old 02755 root staff directory
/usr/pub 00777 root staff symlink
/usr/sccs 02755 root staff directory
/usr/sccs/helpdir 02755 root staff directory
/usr/spool 00777 root staff symlink
/usr/src 00777 root staff symlink
/usr/stand 00777 root staff symlink
/usr/sys 00777 root staff symlink
/usr/tmp 00777 root staff symlink
/usr/ucb 02755 root staff directory
/usr/ucbinclude 00777 root staff symlink
/usr/ucblib 00777 root staff symlink
/usr/xpg2bin 02755 root staff directory
/usr/xpg2include 02755 root staff directory
/usr/xpg2include/sys 02755 root staff directory
/usr/xpg2lib 02755 root staff directory
EOF_USR


###
### Place only files residing in the /usr/kvm filesystem in the list below.
### Do NOT place files residing in / (root), /usr, or /usr/share here.
### Place those files in one of the other lists.
###
client_dirs=""		# /usr/kvm filesystem(s)
if [ -d /export/exec/kvm ] ; then
	dirs=`ls -d /export/exec/kvm/sun*.sunos.4.*`
	for dir in $dirs ; do
		x=`file $dir | sed -n 's/^.* \(.*\)$/\1/p'`
		[ "$x" != /usr/kvm ] && client_dirs="$client_dirs $dir"
	done
fi
while read file mode user group type x; do
	echo $file $mode $user $group $type | set_attr
	client_file=`echo $file | sed -n 's/^\/usr\/kvm\(.*\)$/\1/p'`
	for client_dir in $client_dirs; do
		echo $client_dir$client_file $mode $user $group $type | set_attr
	done
done << EOF_USR_KVM
/usr/kvm/ 02755 root staff directory
/usr/kvm/boot 02755 root staff directory
/usr/kvm/crash 02700 root staff file
/usr/kvm/i386 00777 root staff symlink
/usr/kvm/iAPX286 00777 root staff symlink
/usr/kvm/m68k 00777 root staff symlink
/usr/kvm/machine 00777 root staff symlink
/usr/kvm/mc68010 00777 root staff symlink
/usr/kvm/mc68020 00777 root staff symlink
/usr/kvm/mdec 02755 root staff directory
/usr/kvm/pdp11 00777 root staff symlink
/usr/kvm/sparc 00777 root staff symlink
/usr/kvm/stand 02755 root staff directory
/usr/kvm/sun 00777 root staff symlink
/usr/kvm/sun2 00777 root staff symlink
/usr/kvm/sun4 00777 root staff symlink
/usr/kvm/sun4c 00777 root staff symlink
/usr/kvm/sys 02755 root staff directory
/usr/kvm/sys/conf.common 02755 root staff directory
/usr/kvm/sys/debug 02755 root staff directory
/usr/kvm/sys/krpc 02755 root staff directory
/usr/kvm/sys/lofs 02755 root staff directory
/usr/kvm/sys/m68k 02755 root staff directory
/usr/kvm/sys/mon 02755 root staff directory
/usr/kvm/sys/net 02755 root staff directory
/usr/kvm/sys/netinet 02755 root staff directory
/usr/kvm/sys/nfs 02755 root staff directory
/usr/kvm/sys/os 02755 root staff directory
/usr/kvm/sys/rpc 02755 root staff directory
/usr/kvm/sys/sbusdev 02755 root staff directory
/usr/kvm/sys/scsi 02755 root staff directory
/usr/kvm/sys/scsi/adapters 02755 root staff directory
/usr/kvm/sys/scsi/conf 02755 root staff directory
/usr/kvm/sys/scsi/generic 02755 root staff directory
/usr/kvm/sys/scsi/impl 02755 root staff directory
/usr/kvm/sys/scsi/targets 02755 root staff directory
/usr/kvm/sys/sparc 02755 root staff directory
/usr/kvm/sys/specfs 02755 root staff directory
/usr/kvm/sys/sun 02755 root staff directory
/usr/kvm/sys/sun/symbols.sort 0644 root staff file
/usr/kvm/sys/sun3 02755 root staff directory
/usr/kvm/sys/sun3/OBJ 02755 root staff directory
/usr/kvm/sys/sun3/conf 02755 root staff directory
/usr/kvm/sys/sun3x 02755 root staff directory
/usr/kvm/sys/sun3x/OBJ 02755 root staff directory
/usr/kvm/sys/sun3x/conf 02755 root staff directory
/usr/kvm/sys/sun4 02755 root staff directory
/usr/kvm/sys/sun4/OBJ 02755 root staff directory
/usr/kvm/sys/sun4/conf 02755 root staff directory
/usr/kvm/sys/sun4c 02755 root staff directory
/usr/kvm/sys/sun4c/OBJ 02755 root staff directory
/usr/kvm/sys/sun4c/conf 02755 root staff directory
/usr/kvm/sys/sundev 02755 root staff directory
/usr/kvm/sys/sunif 02755 root staff directory
/usr/kvm/sys/sunwindow 02755 root staff directory
/usr/kvm/sys/sunwindowdev 02755 root staff directory
/usr/kvm/sys/sys 02755 root staff directory
/usr/kvm/sys/ufs 02755 root staff directory
/usr/kvm/sys/vm 02755 root staff directory
/usr/kvm/u370 00777 root staff symlink
/usr/kvm/u3b 00777 root staff symlink
/usr/kvm/u3b15 00777 root staff symlink
/usr/kvm/u3b2 00777 root staff symlink
/usr/kvm/u3b5 00777 root staff symlink
/usr/kvm/vax 00777 root staff symlink
EOF_USR_KVM


###
### Place only files residing in the /usr/share filesystem in the list below.
### Do NOT place files residing in / (root), /usr, or /usr/kvm here.
### Place those files in one of the other lists.
###
client_dirs=""		# /usr/share filesystem(s)
if [ -d /export/share ] ; then
	dirs=`ls -d /export/share/sunos.4.*`
	for dir in $dirs ; do
		x=`file $dir | sed -n 's/^.* \(.*\)$/\1/p'`
		[ "$x" != /usr/share ] && client_dirs="$client_dirs $dir"
	done
fi
while read file mode user group type x; do
	echo $file $mode $user $group $type | set_attr
	client_file=`echo $file | sed -n 's/^\/usr\/share\(.*\)$/\1/p'`
	for client_dir in $client_dirs; do
		echo $client_dir$client_file $mode $user $group $type | set_attr
	done
done << EOF_USR_SHARE
/usr/share/ 02755 root staff directory
/usr/share/lib 02755 root staff directory
/usr/share/lib/aliases 00644 root staff file
/usr/share/lib/aliases.dir 00644 root staff file
/usr/share/lib/aliases.old 00644 root staff file
/usr/share/lib/aliases.pag 00644 root staff file
/usr/share/lib/lex 02755 root staff directory
/usr/share/lib/me 02755 root staff directory
/usr/share/lib/ms 02755 root staff directory
/usr/share/lib/pub 02755 root staff directory
/usr/share/lib/tabset 02755 root staff directory
/usr/share/lib/tmac 02755 root staff directory
/usr/share/lib/zoneinfo 02755 root staff directory
/usr/share/src 02755 root staff directory
/usr/share/src/sun 02755 root staff directory
/usr/share/src/sun/sunview1 02755 root staff directory
/usr/share/src/sun/sunview1/examples 02755 root staff directory
/usr/share/src/sun/sunview1/iconedit 02755 root staff directory
EOF_USR_SHARE

