/*	@(#)ttyflow.h 1.1 89/05/19 SMI	*/

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

#ifndef	_TTYFLOW_
#define	_TTYFLOW_

#include <sys/types.h>
#include <sys/termios.h>
#include <sys/termio.h>

typedef struct {
	u_int		fl_flags;
	u_char		fl_stopc;
	u_char		fl_startc;
	u_char		fl_lnextc;
	u_char		fl_flushc;
}		flow_t;

#define	FL_STRIPF	0x0001
#define	FL_LITF		0x0002
#define	FL_STOPF	0x0004
#define	FL_FLUSHF	0x0008

#define	FR_CHMASK	0x00FF
#define	FR_START	0x0100
#define	FR_STOP		0x0200
#define	FR_FLUSH	0x0400
#define	FR_EATME	0x0800

#define	FL_IFLAGS	(FL_STRIPF)
#define	FL_ISTOPC	(31&'S')
#define	FL_ISTARTC	(31&'Q')
#define	FL_ILNEXTC	(31&'V')
#define	FL_IFLUSHC	(31&'O')

#define	FL_OFF		('\0')		/* value for "function turned off" */

#define	flow_stopf(fs)	((fs).fl_flags & FL_STOPF)
#define	flow_flushf(fs)	((fs).fl_flags & FL_FLUSHF)

extern char	flow_flbits[];
extern char	flow_fcbits[];
extern flow_t	flow_init_v;
extern flow_t	flow_end_v;

extern int	flow_from_termios(/*flow_t *fp, struct termios *tp*/);
extern int	flow_from_termio(/*flow_t *fp, struct termios *tp, tty_common_t *tc*/);
extern int	flow_char(/*flow_t *fp, int ch*/);
extern int	flow_start(/*flow_t *fp*/);
extern int	flow_stop(/*flow_t *fp*/);

#endif	_TTYFLOW_
