#ifndef lint
static char sccsid[] = "@(#)x29main.c 1.28 91/05/02";
#endif
/*
 * X29 main module
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/socket.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/socketvar.h>
#include <sys/errno.h>
#include <sys/signal.h>
#include <sundev/syncstat.h>
#include <net/if.h>
#include <netx25/x25_pk.h>
#include <netx25/x25_ctl.h>
#include <netx25/x25_ioctl.h>
#include "x29pad.h"

/* ICNCFIX by -WFP- and -AL- for bug 1117662 */

#include <sys/time.h>
#include <sys/resource.h>

/* end of part of fix */

extern int	errno;

FILE		*debugon;
char		callingdte[15], calleddte[15];
FACILITY_DB	facility;
int		news, s, traceon = 0;
CONN_DB		host;
int		linkid = -1;
int		lcn;
char		subaddress[MAXHOSTADR + 1] = '\0';
char		address[MAXHOSTADR + 1] = '\0';
int		address_found = 0;
int		subaddress_found = 0;
int		Argc;
int		security_flag; /* ICNCFIX by -TH-, Bug1050333 */
int		select_pty; /* ICNCFIX by -TH-  for Bug107230 (Software 
				Alliance) part of fix */
char		**Argv, **Envp;

/* The following are new facilities supported by 1984 X.25 and later.
 */
u_int		facts;
FACILITY	fact;
char		cg_aef[MAX_AEF+1];
char		cd_aef[MAX_AEF+1];

char		calling_adr[MAX_AEF+1];
char		called_adr[MAX_AEF+1];

mother()
{
	union wait status;

	signal(SIGCHLD, mother);
	while (wait3(&status, WNOHANG, 0) > 0);
}


usage ()
{
/* ICNCFIX by -TH- for bug 1050333 and Bug1072300 (Software Alliance) */
	printf("Usage:	x29 [-rlsaSp]\n");
	printf("	-r	permit reverse charging\n");
	printf("	-llink	specify a link to listen on\n");
	printf("	-sxyz	specify a subaddress to listen on\n");
	printf("	-axyz	specify an address to listen on\n");
/*ICNCFIX by -TH- for bug 1050333 */
	printf("	-S	specify extra security features\n");
/*ICNCFIX by -TH- for Bug1072300 (Software Alliance */
	printf("	-p	allow pty's to be individually specified\n");
}


int
pack(s, d)
	char	*s;
	u_char	*d;
{
	int	odd = 0;
	char	c;

	while (c = *s++) {
		if (c >= '0' && c <= '9')
			c -= '0';
		else
			return(1);
		if (odd) {
			*d++ |= c;
			odd = 0;
		} else {
			*d = c << 4;
			odd = 1;
		}
	}
	return(0);
}


unpack(src, dst, len)
	u_char	*src;
	char	*dst;
	int	len;
{
	int	i;

	for (i = 0; i < len; i++, dst++) {
		if (i & 1)
			*dst = *src++ & 0xf;
		else
			*dst = (*src >> 4) & 0xf;
		if (0 <= *dst && *dst <= 9)
			*dst += '0';
		else
			*dst = 'a' + (*dst - 10);
	}
	*dst = '\0';
}


main(argc, argv, envp)
	int	argc;
	char	**argv;
	char	**envp;
{
	int		oob_type;
	register int	error;
	CONN_DB		src;
	int		srclen = sizeof(CONN_DB), i;
	CONN_ADR	dst;
	char		*p, allow_rev_chg = 0;

/* ICNCFIX by -WFP- and -AL- for bug 1117662 */

	struct rlimit r;

/* end of part of fix */

	/* Before changing argc, argv, and envp save their values.
	 */
	Argc = argc;
	Argv = argv;
	Envp = envp;

	argc--; argv++;
	while (argc) {
		long	temp;

		if (argv[0][0] != '-') {
			usage();
			exit(1);
		}
		switch (argv[0][1]) {
			case 'd':
				traceon = 1;
				break;

			case 'r':
				allow_rev_chg = 1;
				break;

			case 'l':
				sscanf(&argv[0][2], "%d", &linkid);
				break;

			case 's':
				if (strlen(&argv[0][2]) > MAXHOSTADR) {
					printf("subaddress too long\n");
					exit(1);
				}
				sscanf(&argv[0][2], "%s", subaddress);
				subaddress_found = 1;
				break;

/* ICNCFIX by -TH- for Bug1050333.  Addition of a security option which will
   prevent incoming calls if the x29-auth file is missing. Changes made
   elsewhere in this file and in x29.c */

			case 'S':
				security_flag = 1 ;
				break ;

/* End of fix */

/* ICNCFIX by -TH- for Bug1072300 (Software Alliance) - changes made elsewhere 
	in this file and in x29.c */
			case 'p':
				if (check_auth("/etc/sunlink/x25/x29-auth")) {
					printf("Error: x29-auth file missing\n"
								);
					exit(1);
				}
				select_pty = 1;
				break;
/* End of fix */

			case 'a':
				if (strlen(&argv[0][2]) > MAXHOSTADR) {
					printf("address too long\n");
					exit(1);
				}
				sscanf(&argv[0][2], "%s", address);
				address_found = 1;
				break;

			default:
				usage();
				exit(1);
		}
		argc--; argv++;
	}

/* ICNCFIX by -WFP- and -AL- for bug 1117662 */

	if (getrlimit(RLIMIT_NOFILE, &r) < 0) {
		log("cannot get RLIMIT_NOFILE\n");
		exit(1);	
	}

	/* I use 256 instead of NOFILE,
	 * to be coherent with the fix to have 256 pty's.
	 */
	r.rlim_cur = 256;

	if (setrlimit(RLIMIT_NOFILE, &r) < 0) {
		log("cannot set RLIMIT_NOFILE\n");
		exit(1); 
	}

/* end of part of fix */

	signal(SIGCHLD, mother);

	/* Disconnect from controlling terminal - become a daemon.
	 * Also direct stdin, stdout, and stderr to /dev/null.
	 */
	if (!traceon) {
		int	tt, max, i;

		if (fork())
			exit(0);
		max = getdtablesize();
		for (i = 0; i < max; i++)
			close(i);
		tt = open("/dev/tty", 0);
		ioctl(tt, TIOCNOTTY, (char *) 0);
		close(tt);
		tt = open("/dev/null", O_RDWR, 0);
		if (tt != 0) (void) dup2(tt, 0);
		if (tt != 1) (void) dup2(tt, 1);
		if (tt != 2) (void) dup2(tt, 2);
		if ((tt != 0) && (tt != 1) && (tt != 2))
			close(tt);
	}
	if (traceon)
		debugon = stderr;
	else if (!(debugon = fopen("/var/adm/x29debug", "a+")))
		exit(1);
	if ((s = socket(AF_X25, SOCK_STREAM, 0)) < 0) {
		fprintf(debugon, "*** Error %d: socket\n",
			errno);
		exit(1);
	}
	if (linkid >= 0) {
		if (ioctl(s, X25_SET_LINK, &linkid)) {
			fprintf(debugon, "*** Error %d: can't set link %d\n",
				errno, linkid);
			exit(1);
		}
	}
	if (address_found) {
		host.hostlen = strlen(address);
		if (pack(address, host.host)) {
			fprintf(debugon, "invalid address %s\n", address);
			exit(1);
		}
	} else {
		host.hostlen = ANY_LINK;
		if (!subaddress_found)
			host.hostlen |= ANY_SUBADDRESS;
		else {
			host.hostlen |= strlen(subaddress);
			if (pack(subaddress, host.host)) {
				fprintf(debugon, "invalid subaddress %s\n",
					subaddress);
				exit(1);
			}
		}
	}
	/* x29 protocol id is the string 01 xx xx xx
	 */
	host.datalen = 1;
	host.data[0] = 1;

	if (error = bind(s, &host, sizeof(host))) {
		fprintf(debugon, "*** Error %d: bind failed\n", errno);
		exit(1);
	}
	bzero(&facility, sizeof(facility));
	facility.fast_select_type = FAST_ACPT_CLR;
	facility.reverse_charge = allow_rev_chg;
	if (ioctl(s, X25_WR_FACILITY, &facility)) {
		fprintf(debugon, "*** Error %d: could not write facilities\n",
			errno);
		exit(1);
	}
	if (listen(s, 4)) {
		fprintf(debugon, "*** Error %d: listen failed\n", errno);
		exit(1);
	}
	for (;;) {
		if ((news = accept(s, &src, &srclen)) == -1) {
			if (errno == EINTR)
				continue;
			if (errno == EFASTDATA) {
				fprintf(debugon, "EFASTDATA not accepted\n");
				close(news);
				continue;
			}
			fprintf(debugon, "*** Error %d: accept failed\n",
				errno);
			continue;
		}
		if (ioctl(news, X25_SEND_CALL_ACPT)) {
			fprintf(debugon, "*** Error %d: X25_SEND_CALL_ACPT\n",
				errno);
			close(news);
			continue;
		}
		/* Read called (local) address, lcn, linkid, and calling
		 * and called AEF, if any.
		 */
		unpack(src.host, callingdte, src.hostlen & ADR_LEN_MASK);
		strcpy(calling_adr, callingdte);
		(void) ioctl(news, X25_GET_LINK, &linkid);
		(void) ioctl(news, X25_RD_LCGN, &lcn);
		(void) ioctl(news, X25_RD_LOCAL_ADR, &dst);
		unpack(dst.host, calleddte, dst.hostlen & ADR_LEN_MASK);
		strcpy(called_adr, calleddte);
		fact.type = T_FACILITIES;
		(void) ioctl(news, X25_GET_FACILITY, &fact);
		facts = fact.f_facilities;
		cg_aef[0] = cd_aef[0] = '\0';
		if (facts & F_CALLING_AEF) {
			fact.type = T_CALLING_AEF;
			(void) ioctl(news, X25_GET_FACILITY, &fact);
			unpack(fact.f_cg_aef, cg_aef, fact.f_cg_aef_len);
			strcpy(calling_adr, cg_aef);
		}
		if (facts & F_CALLED_AEF) {
			fact.type = T_CALLED_AEF;
			(void) ioctl(news, X25_GET_FACILITY, &fact);
			unpack(fact.f_cd_aef, cd_aef, fact.f_cd_aef_len);
			strcpy(called_adr, cd_aef);
		}
		if (traceon) {
			setpgrp(0, 0);
			x29pad(news);
			exit(0);
		} else if (fork() == 0) {
			int	pgrp = getpid();

			close(s);
			setpgrp(0, 0);
			if (ioctl(news, SIOCSPGRP, &pgrp)) {
				fprintf(debugon, "*** Error %d: SIOCSPGRP\n",
					errno);
				exit(1);
			}
			x29pad(news);
			exit(0);
		} else
			close(news);
	}
}
