/**************************************************************************
 FILE:
	ind_usrreq.h
	
	@(#)llc_usrreq.h 1.4 88/02/01 Copyr 1986 Sun Micro

 DESCRIPTION:
	User level include file for use of the SOCK_DGRAM interface to
	the SunLink OSI 802.2 driver.
	
 **************************************************************************/
 
/* 802.2 layer entries */
#define LLCPROTO_LLC1		900

/*
 * Macros to manipulate sockaddr's in appropriate 802 format.
 * Lingo to remember:
 *
 *	lsap == mac address + lsel
 *	mac  == 802.2 media access control address (e.g. Ethernet 
 *		6-byte address, 6-byte token-bus address)
 *	lsel == 1-byte "protocol id" which identifies a particular client
 *		of 802.2.  
 *
 *	NB:  lsel's are one-byte quantities!
 *
 * 802.2 addresses are stored in standard 'struct sockaddr's.
 */


#define init802_lsap(psa) \
	bzero((char *)psa, sizeof(*psa)); psa->sa_family = AF_802;

#define set802_mac(pbuf, psa) \
	bcopy((char *)pbuf, \
	      (char *)((struct sockaddr_802 *)psa)->s802_macaddr.l_fmt, \
	      6)

#define set802_lsel(lsel, psa) \
	(((struct sockaddr_802 *)psa)->s802_lsel = lsel)

#define get802_mac(pbuf, psa) \
	bcopy((char *)((struct sockaddr_802 *)psa)->s802_macaddr.l_fmt, \
	      (char *)pbuf, 6)

#define get802_lsel(lsel, psa) \
	(lsel = ((struct sockaddr_802 *)psa)->s802_lsel)

#define copy802_lsap(pfrom, pto) \
	set802_mac(((struct sockaddr_802 *)pfrom)->s802_macaddr.l_fmt, pto); \
	set802_lsel(((struct sockaddr_802 *)pfrom)->s802_lsel, pto)

#define copy802_mac(pfrom, pto) \
	bcopy((char *)((struct sockaddr_802 *)pfrom)->s802_macaddr.l_fmt, \
	      (char *)((struct sockaddr_802 *)pto)->s802_macaddr.l_fmt, \
	      6)

/*
 * The user can request that the llc interface choose an unused lsel on
 * his or her behalf.
 */

#define CHOOSEANY_802_LSEL	0xef
#define chooseany802_lsel(psa) \
	(((struct sockaddr_802 *)psa)->pad[0] = CHOOSEANY_802_LSEL)

#define tst_chooseany802_lsel(psa) \
	(((struct sockaddr_802 *)psa)->pad[0] == CHOOSEANY_802_LSEL)

/*
 * As bcmp():  return 0 when addresses match, non-zero otherwise.
 */
#define compare802_macs(psa1, psa2) \
	bcmp((char *)((struct sockaddr_802 *)psa1)->s802_macaddr.l_fmt,	\
	     (char *)((struct sockaddr_802 *)psa2)->s802_macaddr.l_fmt,	\
	     sizeof(((struct sockaddr_802 *)psa1)->s802_macaddr.l_fmt))

#define compare802_lsels(psa1, psa2) \
	((((struct sockaddr_802 *)psa1)->s802_lsel == \
	((struct sockaddr_802 *)psa2)->s802_lsel) ? 0 : 1)

#define compare802_lsaps(psa1, psa2) \
	(((compare802_macs(psa1, psa2) == 0) && \
		(compare802_lsels(psa1, psa2) == 0)) ? 0 : 1)
